/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.reduce.impl;

import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.transform.reduce.AggregableColumnReduction;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.base.Preconditions;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class GeographicMidpointReduction
implements AggregableColumnReduction {
    public static final double EDGE_CASE_EPS = 1.0E-9;
    private String delim;
    private String newColumnName;

    public GeographicMidpointReduction(String delim) {
        this(delim, null);
    }

    public GeographicMidpointReduction(@JsonProperty(value="delim") String delim, @JsonProperty(value="newColumnName") String newColumnName) {
        this.delim = delim;
        this.newColumnName = newColumnName;
    }

    @Override
    public IAggregableReduceOp<Writable, List<Writable>> reduceOp() {
        return new AverageCoordinateReduceOp(this.delim);
    }

    @Override
    public List<String> getColumnsOutputName(String columnInputName) {
        if (this.newColumnName != null) {
            return Collections.singletonList(this.newColumnName);
        }
        return Collections.singletonList("midpoint(" + columnInputName + ")");
    }

    @Override
    public List<ColumnMetaData> getColumnOutputMetaData(List<String> newColumnName, ColumnMetaData columnInputMeta) {
        return Collections.singletonList(new StringMetaData(newColumnName.get(0)));
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
    }

    @Override
    public Schema getInputSchema() {
        return null;
    }

    @Override
    public String outputColumnName() {
        return null;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[0];
    }

    @Override
    public String[] columnNames() {
        return new String[0];
    }

    @Override
    public String columnName() {
        return null;
    }

    public String getDelim() {
        return this.delim;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeographicMidpointReduction)) {
            return false;
        }
        GeographicMidpointReduction other = (GeographicMidpointReduction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$delim = this.getDelim();
        String other$delim = other.getDelim();
        if (this$delim == null ? other$delim != null : !this$delim.equals(other$delim)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        return !(this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeographicMidpointReduction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $delim = this.getDelim();
        result = result * 59 + ($delim == null ? 43 : $delim.hashCode());
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        return result;
    }

    public String toString() {
        return "GeographicMidpointReduction(delim=" + this.getDelim() + ", newColumnName=" + this.getNewColumnName() + ")";
    }

    public static class AverageCoordinateReduceOp
    implements IAggregableReduceOp<Writable, List<Writable>> {
        private static final double PI_180 = Math.PI / 180;
        private String delim;
        private double sumx;
        private double sumy;
        private double sumz;
        private int count;

        public AverageCoordinateReduceOp(String delim) {
            this.delim = delim;
        }

        @Override
        public <W extends IAggregableReduceOp<Writable, List<Writable>>> void combine(W accu) {
            if (accu instanceof AverageCoordinateReduceOp) {
                AverageCoordinateReduceOp r = (AverageCoordinateReduceOp)accu;
                this.sumx += r.sumx;
                this.sumy += r.sumy;
                this.sumz += r.sumz;
                this.count += r.count;
            } else {
                throw new IllegalStateException("Cannot combine type of class: " + accu.getClass());
            }
        }

        public void accept(Writable writable) {
            String str = writable.toString();
            String[] split = str.split(this.delim);
            if (split.length != 2) {
                throw new IllegalStateException("Could not parse lat/long string: \"" + str + "\"");
            }
            double latDeg = Double.parseDouble(split[0]);
            double longDeg = Double.parseDouble(split[1]);
            Preconditions.checkState((latDeg >= -90.0 && latDeg <= 90.0 ? 1 : 0) != 0, (String)"Invalid latitude: must be -90 to -90. Got: %s", (double)latDeg);
            Preconditions.checkState((latDeg >= -180.0 && latDeg <= 180.0 ? 1 : 0) != 0, (String)"Invalid longitude: must be -180 to -180. Got: %s", (double)longDeg);
            double lat = latDeg * (Math.PI / 180);
            double lng = longDeg * (Math.PI / 180);
            double x = Math.cos(lat) * Math.cos(lng);
            double y = Math.cos(lat) * Math.sin(lng);
            double z = Math.sin(lat);
            this.sumx += x;
            this.sumy += y;
            this.sumz += z;
            ++this.count;
        }

        public List<Writable> get() {
            double x = this.sumx / (double)this.count;
            double y = this.sumy / (double)this.count;
            double z = this.sumz / (double)this.count;
            if (this.count == 0) {
                throw new IllegalStateException("Cannot calculate geographic midpoint: no datapoints were added to be reduced");
            }
            if (Math.abs(x) < 1.0E-9 && Math.abs(y) < 1.0E-9 && Math.abs(z) < 1.0E-9) {
                throw new IllegalStateException("No Geographic midpoint exists: midpoint is center of the earth");
            }
            double longRad = Math.atan2(y, x);
            double hyp = Math.sqrt(x * x + y * y);
            double latRad = Math.atan2(z, hyp);
            double latDeg = latRad / (Math.PI / 180);
            double longDeg = longRad / (Math.PI / 180);
            Preconditions.checkState((!Double.isNaN(latDeg) ? 1 : 0) != 0, (String)"Final latitude is NaN");
            Preconditions.checkState((!Double.isNaN(longDeg) ? 1 : 0) != 0, (String)"Final longitude is NaN");
            String str = latDeg + this.delim + longDeg;
            return Collections.singletonList(new Text(str));
        }
    }
}

