/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class PivotTransform
extends BaseTransform {
    private final String keyColumn;
    private final String valueColumn;
    private Writable defaultValue;

    public PivotTransform(String keyColumnName, String valueColumnName) {
        this(keyColumnName, valueColumnName, null);
    }

    public PivotTransform(String keyColumnName, String valueColumnName, Writable defaultValue) {
        this.keyColumn = keyColumnName;
        this.valueColumn = valueColumnName;
        this.defaultValue = defaultValue;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.keyColumn) || !inputSchema.hasColumn(this.valueColumn)) {
            throw new UnsupportedOperationException("Key or value column not found: " + this.keyColumn + ", " + this.valueColumn + " in " + inputSchema.getColumnNames());
        }
        List<String> origNames = inputSchema.getColumnNames();
        List<ColumnMetaData> origMeta = inputSchema.getColumnMetaData();
        int i = 0;
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> typesIter = origMeta.iterator();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.numColumns());
        int idxKey = inputSchema.getIndexOfColumn(this.keyColumn);
        int idxValue = inputSchema.getIndexOfColumn(this.valueColumn);
        ColumnMetaData valueMeta = inputSchema.getMetaData(idxValue);
        while (namesIter.hasNext()) {
            String s = namesIter.next();
            ColumnMetaData t = typesIter.next();
            if (i == idxKey) {
                List<String> stateNames = ((CategoricalMetaData)inputSchema.getMetaData(idxKey)).getStateNames();
                for (String stateName : stateNames) {
                    String newName = s + "[" + stateName + "]";
                    ColumnMetaData newValueMeta = valueMeta.clone();
                    newValueMeta.setName(newName);
                    newMeta.add(newValueMeta);
                }
            } else {
                if (i == idxValue) {
                    ++i;
                    continue;
                }
                newMeta.add(t);
            }
            ++i;
        }
        if (this.defaultValue == null) {
            switch (valueMeta.getColumnType()) {
                case String: {
                    this.defaultValue = new Text("");
                    break;
                }
                case Integer: {
                    this.defaultValue = new IntWritable(0);
                    break;
                }
                case Long: {
                    this.defaultValue = new LongWritable(0L);
                    break;
                }
                case Double: {
                    this.defaultValue = new DoubleWritable(0.0);
                    break;
                }
                case Float: {
                    this.defaultValue = new FloatWritable(0.0f);
                    break;
                }
                case Categorical: {
                    this.defaultValue = new NullWritable();
                    break;
                }
                case Time: {
                    this.defaultValue = new LongWritable(0L);
                    break;
                }
                case Bytes: {
                    throw new UnsupportedOperationException("Cannot infer default value for bytes");
                }
                case Boolean: {
                    this.defaultValue = new Text("false");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot infer default value for " + (Object)((Object)valueMeta.getColumnType()));
                }
            }
        }
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public String outputColumnName() {
        throw new UnsupportedOperationException("Output column name will be more than 1");
    }

    @Override
    public String[] outputColumnNames() {
        List<String> l = ((CategoricalMetaData)this.inputSchema.getMetaData(this.keyColumn)).getStateNames();
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.keyColumn, this.valueColumn};
    }

    @Override
    public String columnName() {
        throw new UnsupportedOperationException("Multiple input columns");
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int idxKey = this.inputSchema.getIndexOfColumn(this.keyColumn);
        int idxValue = this.inputSchema.getIndexOfColumn(this.valueColumn);
        List<String> stateNames = ((CategoricalMetaData)this.inputSchema.getMetaData(idxKey)).getStateNames();
        int i = 0;
        ArrayList<Writable> out = new ArrayList<Writable>();
        for (Writable w : writables) {
            if (i == idxKey) {
                String str = w.toString();
                int stateIdx = stateNames.indexOf(str);
                if (stateIdx < 0) {
                    throw new RuntimeException("Unknown state (index not found): " + str);
                }
                for (int j = 0; j < stateNames.size(); ++j) {
                    if (j == stateIdx) {
                        out.add(writables.get(idxValue));
                        continue;
                    }
                    out.add(this.defaultValue);
                }
            } else {
                if (i == idxValue) {
                    ++i;
                    continue;
                }
                out.add(w);
            }
            ++i;
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        List l = (List)input;
        Writable k = (Writable)l.get(0);
        Writable v = (Writable)l.get(1);
        int idxKey = this.inputSchema.getIndexOfColumn(this.keyColumn);
        List<String> stateNames = ((CategoricalMetaData)this.inputSchema.getMetaData(idxKey)).getStateNames();
        int n = stateNames.size();
        int position = stateNames.indexOf(k.toString());
        ArrayList<Writable> out = new ArrayList<Writable>();
        for (int j = 0; j < n; ++j) {
            if (j == position) {
                out.add(v);
                continue;
            }
            out.add(this.defaultValue);
        }
        return out;
    }

    @Override
    public Object mapSequence(Object sequence) {
        List values = (List)sequence;
        ArrayList<List> ret = new ArrayList<List>();
        for (Object obj : values) {
            ret.add((List)this.map(obj));
        }
        return ret;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public Writable getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Writable defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PivotTransform)) {
            return false;
        }
        PivotTransform other = (PivotTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        String this$valueColumn = this.getValueColumn();
        String other$valueColumn = other.getValueColumn();
        if (this$valueColumn == null ? other$valueColumn != null : !this$valueColumn.equals(other$valueColumn)) {
            return false;
        }
        Writable this$defaultValue = this.getDefaultValue();
        Writable other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PivotTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        String $valueColumn = this.getValueColumn();
        result = result * 59 + ($valueColumn == null ? 43 : $valueColumn.hashCode());
        Writable $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PivotTransform(keyColumn=" + this.getKeyColumn() + ", valueColumn=" + this.getValueColumn() + ", defaultValue=" + this.getDefaultValue() + ")";
    }
}

