/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.serde;

import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.DataAction;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.reduce.IAssociativeReducer;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.transform.serde.ListWrappers;
import org.nd4j.shade.jackson.core.type.TypeReference;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public abstract class BaseSerializer {
    public abstract ObjectMapper getObjectMapper();

    private <T> T load(String str, Class<T> clazz) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return (T)om.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T load(String str, TypeReference<T> typeReference) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return (T)om.readValue(str, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(Object o) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(Transform[] transforms) {
        return this.serializeTransformList(Arrays.asList(transforms));
    }

    public String serializeTransformList(List<Transform> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.TransformList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(Filter[] filters) {
        return this.serializeFilterList(Arrays.asList(filters));
    }

    public String serializeFilterList(List<Filter> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.FilterList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(Condition[] conditions) {
        return this.serializeConditionList(Arrays.asList(conditions));
    }

    public String serializeConditionList(List<Condition> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.ConditionList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(IAssociativeReducer[] reducers) {
        return this.serializeReducerList(Arrays.asList(reducers));
    }

    public String serializeReducerList(List<IAssociativeReducer> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.ReducerList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(SequenceComparator[] seqComparators) {
        return this.serializeSequenceComparatorList(Arrays.asList(seqComparators));
    }

    public String serializeSequenceComparatorList(List<SequenceComparator> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.SequenceComparatorList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(DataAction[] dataActions) {
        return this.serializeDataActionList(Arrays.asList(dataActions));
    }

    public String serializeDataActionList(List<DataAction> list) {
        ObjectMapper om = this.getObjectMapper();
        try {
            return om.writeValueAsString((Object)new ListWrappers.DataActionList(list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Transform deserializeTransform(String str) {
        return this.load(str, Transform.class);
    }

    public Filter deserializeFilter(String str) {
        return this.load(str, Filter.class);
    }

    public Condition deserializeCondition(String str) {
        return this.load(str, Condition.class);
    }

    public IAssociativeReducer deserializeReducer(String str) {
        return this.load(str, IAssociativeReducer.class);
    }

    public SequenceComparator deserializeSequenceComparator(String str) {
        return this.load(str, SequenceComparator.class);
    }

    public CalculateSortedRank deserializeSortedRank(String str) {
        return this.load(str, CalculateSortedRank.class);
    }

    public SequenceSplit deserializeSequenceSplit(String str) {
        return this.load(str, SequenceSplit.class);
    }

    public DataAction deserializeDataAction(String str) {
        return this.load(str, DataAction.class);
    }

    public List<Transform> deserializeTransformList(String str) {
        return this.load(str, ListWrappers.TransformList.class).getList();
    }

    public List<Filter> deserializeFilterList(String str) {
        return this.load(str, ListWrappers.FilterList.class).getList();
    }

    public List<Condition> deserializeConditionList(String str) {
        return this.load(str, ListWrappers.ConditionList.class).getList();
    }

    public List<IAssociativeReducer> deserializeReducerList(String str) {
        return this.load(str, ListWrappers.ReducerList.class).getList();
    }

    public List<SequenceComparator> deserializeSequenceComparatorList(String str) {
        return this.load(str, ListWrappers.SequenceComparatorList.class).getList();
    }

    public List<DataAction> deserializeDataActionList(String str) {
        return this.load(str, ListWrappers.DataActionList.class).getList();
    }
}

