/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnIdx"})
public class FirstDigitTransform
extends BaseTransform {
    public static final String OTHER_CATEGORY = "Other";
    protected String inputColumn;
    protected String outputColumn;
    protected Mode mode;
    private int columnIdx = -1;

    public FirstDigitTransform(@JsonProperty(value="inputColumn") String inputColumn, @JsonProperty(value="outputColumn") String outputColumn, @JsonProperty(value="mode") Mode mode) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
        this.mode = mode;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> out = new ArrayList<Writable>();
        int i = 0;
        boolean inplace = this.inputColumn.equals(this.outputColumn);
        for (Writable w : writables) {
            if (i++ == this.columnIdx) {
                String s;
                if (!inplace) {
                    out.add(w);
                }
                if ((s = w.toString()).isEmpty()) {
                    if (this.mode == Mode.INCLUDE_OTHER_CATEGORY) {
                        out.add(new Text(OTHER_CATEGORY));
                        continue;
                    }
                    throw new IllegalStateException("Encountered empty string in FirstDigitTransform that is set to Mode.EXCEPTION_ON_INVALID. Either data contains an invalid (non-numerical) entry, or set FirstDigitTransform to Mode.INCLUDE_OTHER_CATEGORY");
                }
                char first = s.charAt(0);
                if (first == '-' && s.length() > 1) {
                    first = s.charAt(1);
                }
                if (first >= '0' && first <= '9') {
                    out.add(new Text(String.valueOf(first)));
                    continue;
                }
                if (this.mode == Mode.INCLUDE_OTHER_CATEGORY) {
                    out.add(new Text(OTHER_CATEGORY));
                    continue;
                }
                String s2 = s;
                if (s.length() > 100) {
                    s2 = s2.substring(0, 100) + "...";
                }
                throw new IllegalStateException("Encountered string \"" + s2 + "\" with non-numerical first character in FirstDigitTransform that is set to Mode.EXCEPTION_ON_INVALID. Either data contains an invalid (non-numerical) entry, or set FirstDigitTransform to Mode.INCLUDE_OTHER_CATEGORY");
            }
            out.add(w);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String toString() {
        return "FirstDigitTransform(input=\"" + this.inputColumn + "\",output=\"" + this.outputColumn + "\",mode=" + (Object)((Object)this.mode) + ")";
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<String> origNames = inputSchema.getColumnNames();
        List<ColumnMetaData> origMeta = inputSchema.getColumnMetaData();
        Preconditions.checkState((boolean)origNames.contains(this.inputColumn), (String)"Input column with name \"%s\" not found in schema", (Object)this.inputColumn);
        Preconditions.checkState((this.inputColumn.equals(this.outputColumn) || !origNames.contains(this.outputColumn) ? 1 : 0) != 0, (String)"Output column with name \"%s\" already exists in schema (only allowable if input column == output column)", (Object)this.outputColumn);
        ArrayList<ColumnMetaData> outMeta = new ArrayList<ColumnMetaData>(origNames.size() + 1);
        for (int i = 0; i < origNames.size(); ++i) {
            String s = origNames.get(i);
            if (s.equals(this.inputColumn)) {
                if (!this.outputColumn.equals(this.inputColumn)) {
                    outMeta.add(origMeta.get(i));
                }
                List<String> l = Collections.unmodifiableList(this.mode == Mode.INCLUDE_OTHER_CATEGORY ? Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", OTHER_CATEGORY) : Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"));
                CategoricalMetaData cm = new CategoricalMetaData(this.outputColumn, l);
                outMeta.add(cm);
                continue;
            }
            outMeta.add(origMeta.get(i));
        }
        return inputSchema.newSchema(outMeta);
    }

    @Override
    public String outputColumnName() {
        return this.outputColumn;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.outputColumn};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.inputColumn};
    }

    @Override
    public String columnName() {
        return this.inputColumn;
    }

    @Override
    public void setInputSchema(Schema schema) {
        super.setInputSchema(schema);
        this.columnIdx = schema.getIndexOfColumn(this.inputColumn);
        Preconditions.checkState((this.columnIdx >= 0 ? 1 : 0) != 0, (String)"Input column \"%s\" not found in schema", (Object)this.inputColumn);
    }

    public static enum Mode {
        EXCEPTION_ON_INVALID,
        INCLUDE_OTHER_CATEGORY;

    }
}

