/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.counter;

import com.tdunning.math.stats.TDigest;
import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.counter.StatCounter;
import org.datavec.api.writable.Writable;

public class DoubleAnalysisCounter
implements AnalysisCounter<DoubleAnalysisCounter> {
    private StatCounter counter = new StatCounter();
    private long countZero = 0L;
    private long countMinValue = 0L;
    private long countMaxValue = 0L;
    private long countPositive = 0L;
    private long countNegative = 0L;
    private long countNaN = 0L;
    private TDigest digest = TDigest.createDigest((double)100.0);

    public DoubleAnalysisCounter() {
    }

    public double getMinValueSeen() {
        return this.counter.getMin();
    }

    public double getMaxValueSeen() {
        return this.counter.getMax();
    }

    public double getSum() {
        return this.counter.getSum();
    }

    public long getCountTotal() {
        return this.counter.getCount();
    }

    public double getSampleStdev() {
        return this.counter.getStddev(false);
    }

    public double getMean() {
        return this.counter.getMean();
    }

    public double getSampleVariance() {
        return this.counter.getVariance(false);
    }

    @Override
    public DoubleAnalysisCounter add(Writable writable) {
        double value = writable.toDouble();
        if (value == 0.0) {
            ++this.countZero;
        }
        if (value == Double.NaN) {
            ++this.countNaN;
        }
        if (value == this.getMinValueSeen()) {
            ++this.countMinValue;
        } else if (value < this.getMinValueSeen()) {
            this.countMinValue = 1L;
        }
        if (value == this.getMaxValueSeen()) {
            ++this.countMaxValue;
        } else if (value > this.getMaxValueSeen()) {
            this.countMaxValue = 1L;
        }
        if (value >= 0.0) {
            ++this.countPositive;
        } else {
            ++this.countNegative;
        }
        this.digest.add(value);
        this.counter.add(value);
        return this;
    }

    @Override
    public DoubleAnalysisCounter merge(DoubleAnalysisCounter other) {
        double otherMin = other.getMinValueSeen();
        long newCountMinValue = this.getMinValueSeen() == otherMin ? this.countMinValue + other.getCountMinValue() : (this.getMinValueSeen() > otherMin ? other.getCountMinValue() : this.countMinValue);
        double otherMax = other.getMaxValueSeen();
        long newCountMaxValue = this.getMaxValueSeen() == otherMax ? this.countMaxValue + other.getCountMaxValue() : (this.getMaxValueSeen() < otherMax ? other.getCountMaxValue() : this.countMaxValue);
        this.digest.add(other.getDigest());
        return new DoubleAnalysisCounter(this.counter.merge(other.getCounter()), this.countZero + other.getCountZero(), newCountMinValue, newCountMaxValue, this.countPositive + other.getCountPositive(), this.countNegative + other.getCountNegative(), this.countNaN + other.getCountNaN(), this.digest);
    }

    public DoubleAnalysisCounter(StatCounter counter, long countZero, long countMinValue, long countMaxValue, long countPositive, long countNegative, long countNaN, TDigest digest) {
        this.counter = counter;
        this.countZero = countZero;
        this.countMinValue = countMinValue;
        this.countMaxValue = countMaxValue;
        this.countPositive = countPositive;
        this.countNegative = countNegative;
        this.countNaN = countNaN;
        this.digest = digest;
    }

    public StatCounter getCounter() {
        return this.counter;
    }

    public long getCountZero() {
        return this.countZero;
    }

    public long getCountMinValue() {
        return this.countMinValue;
    }

    public long getCountMaxValue() {
        return this.countMaxValue;
    }

    public long getCountPositive() {
        return this.countPositive;
    }

    public long getCountNegative() {
        return this.countNegative;
    }

    public long getCountNaN() {
        return this.countNaN;
    }

    public TDigest getDigest() {
        return this.digest;
    }

    public void setCounter(StatCounter counter) {
        this.counter = counter;
    }

    public void setCountZero(long countZero) {
        this.countZero = countZero;
    }

    public void setCountMinValue(long countMinValue) {
        this.countMinValue = countMinValue;
    }

    public void setCountMaxValue(long countMaxValue) {
        this.countMaxValue = countMaxValue;
    }

    public void setCountPositive(long countPositive) {
        this.countPositive = countPositive;
    }

    public void setCountNegative(long countNegative) {
        this.countNegative = countNegative;
    }

    public void setCountNaN(long countNaN) {
        this.countNaN = countNaN;
    }

    public void setDigest(TDigest digest) {
        this.digest = digest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleAnalysisCounter)) {
            return false;
        }
        DoubleAnalysisCounter other = (DoubleAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountZero() != other.getCountZero()) {
            return false;
        }
        if (this.getCountMinValue() != other.getCountMinValue()) {
            return false;
        }
        if (this.getCountMaxValue() != other.getCountMaxValue()) {
            return false;
        }
        if (this.getCountPositive() != other.getCountPositive()) {
            return false;
        }
        if (this.getCountNegative() != other.getCountNegative()) {
            return false;
        }
        if (this.getCountNaN() != other.getCountNaN()) {
            return false;
        }
        StatCounter this$counter = this.getCounter();
        StatCounter other$counter = other.getCounter();
        if (this$counter == null ? other$counter != null : !this$counter.equals(other$counter)) {
            return false;
        }
        TDigest this$digest = this.getDigest();
        TDigest other$digest = other.getDigest();
        return !(this$digest == null ? other$digest != null : !this$digest.equals(other$digest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countZero = this.getCountZero();
        result = result * 59 + (int)($countZero >>> 32 ^ $countZero);
        long $countMinValue = this.getCountMinValue();
        result = result * 59 + (int)($countMinValue >>> 32 ^ $countMinValue);
        long $countMaxValue = this.getCountMaxValue();
        result = result * 59 + (int)($countMaxValue >>> 32 ^ $countMaxValue);
        long $countPositive = this.getCountPositive();
        result = result * 59 + (int)($countPositive >>> 32 ^ $countPositive);
        long $countNegative = this.getCountNegative();
        result = result * 59 + (int)($countNegative >>> 32 ^ $countNegative);
        long $countNaN = this.getCountNaN();
        result = result * 59 + (int)($countNaN >>> 32 ^ $countNaN);
        StatCounter $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        TDigest $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        return result;
    }

    public String toString() {
        return "DoubleAnalysisCounter(counter=" + this.getCounter() + ", countZero=" + this.getCountZero() + ", countMinValue=" + this.getCountMinValue() + ", countMaxValue=" + this.getCountMaxValue() + ", countPositive=" + this.getCountPositive() + ", countNegative=" + this.getCountNegative() + ", countNaN=" + this.getCountNaN() + ", digest=" + this.getDigest() + ")";
    }
}

