/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.files.UriFromPathIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberedFileInputSplit
implements InputSplit {
    private static final Logger log = LoggerFactory.getLogger(NumberedFileInputSplit.class);
    private final String baseString;
    private final int minIdx;
    private final int maxIdx;
    private static final Pattern p = Pattern.compile("\\%(0\\d)?d");

    public NumberedFileInputSplit(String baseString, int minIdxInclusive, int maxIdxInclusive) {
        Matcher m = p.matcher(baseString);
        if (baseString == null || !m.find()) {
            throw new IllegalArgumentException("Base String must match this regular expression: " + p.toString());
        }
        this.baseString = baseString;
        this.minIdx = minIdxInclusive;
        this.maxIdx = maxIdxInclusive;
    }

    @Override
    public boolean canWriteToLocation(URI location) {
        return location.isAbsolute();
    }

    @Override
    public String addNewLocation() {
        return null;
    }

    @Override
    public String addNewLocation(String location) {
        return null;
    }

    @Override
    public void updateSplitLocations(boolean reset) {
    }

    @Override
    public boolean needsBootstrapForWrite() {
        return this.locations() == null || this.locations().length < 1 || this.locations().length == 1 && !this.locations()[0].isAbsolute();
    }

    @Override
    public void bootStrapForWrite() {
        if (this.locations().length == 1 && !this.locations()[0].isAbsolute()) {
            File parentDir = new File(this.locations()[0]);
            File writeFile = new File(parentDir, "write-file");
            try {
                writeFile.createNewFile();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @Override
    public OutputStream openOutputStreamFor(String location) throws Exception {
        FileOutputStream ret = location.startsWith("file:") ? new FileOutputStream(new File(URI.create(location))) : new FileOutputStream(new File(location));
        return ret;
    }

    @Override
    public InputStream openInputStreamFor(String location) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(location);
        return fileInputStream;
    }

    @Override
    public long length() {
        return this.maxIdx - this.minIdx + 1;
    }

    @Override
    public URI[] locations() {
        URI[] uris = new URI[(int)this.length()];
        int x = 0;
        if (this.baseString.matches(".{2,}:/.*")) {
            for (int i = this.minIdx; i <= this.maxIdx; ++i) {
                uris[x++] = URI.create(String.format(this.baseString, i));
            }
        } else {
            for (int i = this.minIdx; i <= this.maxIdx; ++i) {
                uris[x++] = new File(String.format(this.baseString, i)).toURI();
            }
        }
        return uris;
    }

    @Override
    public Iterator<URI> locationsIterator() {
        return new UriFromPathIterator(this.locationsPathIterator());
    }

    @Override
    public Iterator<String> locationsPathIterator() {
        return new NumberedFileIterator();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    private class NumberedFileIterator
    implements Iterator<String> {
        private int currIdx;

        private NumberedFileIterator() {
            this.currIdx = NumberedFileInputSplit.this.minIdx;
        }

        @Override
        public boolean hasNext() {
            return this.currIdx <= NumberedFileInputSplit.this.maxIdx;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return String.format(NumberedFileInputSplit.this.baseString, this.currIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

