/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class RenameColumnsTransform
implements Transform,
ColumnOp {
    private final List<String> oldNames;
    private final List<String> newNames;
    private Schema inputSchema;

    public RenameColumnsTransform(String oldName, String newName) {
        this(Collections.singletonList(oldName), Collections.singletonList(newName));
    }

    public RenameColumnsTransform(@JsonProperty(value="oldNames") List<String> oldNames, @JsonProperty(value="newNames") List<String> newNames) {
        if (oldNames.size() != newNames.size()) {
            throw new IllegalArgumentException("Invalid input: old/new names lists differ in length");
        }
        this.oldNames = oldNames;
        this.newNames = newNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumnsTransform o2 = (RenameColumnsTransform)o;
        if (!this.oldNames.equals(o2.oldNames)) {
            return false;
        }
        return this.newNames.equals(o2.newNames);
    }

    public int hashCode() {
        int result = this.oldNames.hashCode();
        result = 31 * result + this.newNames.hashCode();
        return result;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<String> inputNames = inputSchema.getColumnNames();
        ArrayList<ColumnMetaData> outputMeta = new ArrayList<ColumnMetaData>();
        for (String s : inputNames) {
            int idx = this.oldNames.indexOf(s);
            if (idx >= 0) {
                ColumnMetaData meta = inputSchema.getMetaData(s).clone();
                meta.setName(this.newNames.get(idx));
                outputMeta.add(meta);
                continue;
            }
            outputMeta.add(inputSchema.getMetaData(s));
        }
        return inputSchema.newSchema(outputMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        return writables;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        return sequence;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    public String toString() {
        return "RenameColumnsTransform(oldNames=" + this.oldNames + ",newNames=" + this.newNames + ")";
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.newNames.toArray(new String[this.newNames.size()]);
    }

    @Override
    public String[] columnNames() {
        return this.oldNames.toArray(new String[this.oldNames.size()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }
}

