/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.split;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"separationMilliseconds", "timeColumnIdx", "schema"})
public class SequenceSplitTimeSeparation
implements SequenceSplit {
    private final String timeColumn;
    private final long timeQuantity;
    private final TimeUnit timeUnit;
    private final long separationMilliseconds;
    private int timeColumnIdx = -1;
    private Schema schema;

    public SequenceSplitTimeSeparation(@JsonProperty(value="timeColumn") String timeColumn, @JsonProperty(value="timeQuantity") long timeQuantity, @JsonProperty(value="timeUnit") TimeUnit timeUnit) {
        this.timeColumn = timeColumn;
        this.timeQuantity = timeQuantity;
        this.timeUnit = timeUnit;
        this.separationMilliseconds = TimeUnit.MILLISECONDS.convert(timeQuantity, timeUnit);
    }

    @Override
    public List<List<List<Writable>>> split(List<List<Writable>> sequence) {
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        long lastTimeStepTime = Long.MIN_VALUE;
        ArrayList<List<Writable>> currentSplit = null;
        for (List<Writable> timeStep : sequence) {
            long currStepTime = timeStep.get(this.timeColumnIdx).toLong();
            if (lastTimeStepTime == Long.MIN_VALUE || currStepTime - lastTimeStepTime > this.separationMilliseconds) {
                if (currentSplit != null) {
                    out.add(currentSplit);
                }
                currentSplit = new ArrayList<List<Writable>>();
            }
            currentSplit.add(timeStep);
            lastTimeStepTime = currStepTime;
        }
        out.add(currentSplit);
        return out;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.timeColumn)) {
            throw new IllegalStateException("Invalid state: schema does not have column with name \"" + this.timeColumn + "\"");
        }
        if (inputSchema.getMetaData(this.timeColumn).getColumnType() != ColumnType.Time) {
            throw new IllegalStateException("Invalid input schema: schema column \"" + this.timeColumn + "\" is not a time column. (Is type: " + (Object)((Object)inputSchema.getMetaData(this.timeColumn).getColumnType()) + ")");
        }
        this.timeColumnIdx = inputSchema.getIndexOfColumn(this.timeColumn);
        this.schema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    public String toString() {
        return "SequenceSplitTimeSeparation(timeColumn=\"" + this.timeColumn + "\",timeQuantity=" + this.timeQuantity + ",timeUnit=" + (Object)((Object)this.timeUnit) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceSplitTimeSeparation)) {
            return false;
        }
        SequenceSplitTimeSeparation other = (SequenceSplitTimeSeparation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$timeColumn = this.timeColumn;
        String other$timeColumn = other.timeColumn;
        if (this$timeColumn == null ? other$timeColumn != null : !this$timeColumn.equals(other$timeColumn)) {
            return false;
        }
        if (this.timeQuantity != other.timeQuantity) {
            return false;
        }
        TimeUnit this$timeUnit = this.timeUnit;
        TimeUnit other$timeUnit = other.timeUnit;
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceSplitTimeSeparation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $timeColumn = this.timeColumn;
        result = result * 59 + ($timeColumn == null ? 43 : $timeColumn.hashCode());
        long $timeQuantity = this.timeQuantity;
        result = result * 59 + (int)($timeQuantity >>> 32 ^ $timeQuantity);
        TimeUnit $timeUnit = this.timeUnit;
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }
}

