/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class StandardizeNormalizer
extends BaseDoubleTransform {
    protected final double mean;
    protected final double stdev;

    public StandardizeNormalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mean") double mean, @JsonProperty(value="stdev") double stdev) {
        super(columnName);
        this.mean = mean;
        this.stdev = stdev;
    }

    @Override
    public Writable map(Writable writable) {
        double val = writable.toDouble();
        return new DoubleWritable((val - this.mean) / this.stdev);
    }

    @Override
    public String toString() {
        return "StandardizeNormalizer(mean=" + this.mean + ",stdev=" + this.stdev + ")";
    }
}

