/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"inputSchema", "columnNumber"})
public class StringToCategoricalTransform
extends BaseColumnTransform {
    private final List<String> stateNames;

    public StringToCategoricalTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="stateNames") List<String> stateNames) {
        super(columnName);
        this.stateNames = stateNames;
    }

    public StringToCategoricalTransform(String columnName, String ... stateNames) {
        this(columnName, Arrays.asList(stateNames));
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        return new CategoricalMetaData(newColumnName, this.stateNames);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return columnWritable;
    }

    @Override
    public String toString() {
        return "StringToCategoricalTransform(stateNames=" + this.stateNames + ")";
    }
}

