/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.join;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Writable;

public class Join
implements Serializable {
    private JoinType joinType;
    private Schema leftSchema;
    private Schema rightSchema;
    private String[] keyColumnsLeft;
    private String[] keyColumnsRight;

    private Join(Builder builder) {
        this.joinType = builder.joinType;
        this.leftSchema = builder.leftSchema;
        this.rightSchema = builder.rightSchema;
        this.keyColumnsLeft = builder.keyColumnsLeft;
        this.keyColumnsRight = builder.keyColumnsRight;
    }

    public Schema getOutputSchema() {
        String name;
        int i;
        if (this.leftSchema == null) {
            throw new IllegalStateException("Left schema is not set (null)");
        }
        if (this.rightSchema == null) {
            throw new IllegalStateException("Right schema is not set (null)");
        }
        if (this.keyColumnsLeft == null) {
            throw new IllegalStateException("Left key columns are not set (null)");
        }
        if (this.keyColumnsRight == null) {
            throw new IllegalArgumentException("Right key columns are not set (null");
        }
        ArrayList<ColumnMetaData> metaDataOut = new ArrayList<ColumnMetaData>();
        HashSet<String> columnNamesSeenSoFar = new HashSet<String>();
        List<String> columnNamesLeft = this.leftSchema.getColumnNames();
        List<String> columnNamesRight = this.rightSchema.getColumnNames();
        List<ColumnMetaData> metaDataLeft = this.leftSchema.getColumnMetaData();
        List<ColumnMetaData> metaDataRight = this.rightSchema.getColumnMetaData();
        for (i = 0; i < columnNamesLeft.size(); ++i) {
            name = columnNamesLeft.get(i);
            metaDataOut.add(metaDataLeft.get(i));
            columnNamesSeenSoFar.add(name);
        }
        for (i = 0; i < columnNamesRight.size(); ++i) {
            name = columnNamesRight.get(i);
            if (ArrayUtils.contains((Object[])this.keyColumnsRight, (Object)name)) continue;
            if (columnNamesSeenSoFar.contains(name)) {
                throw new IllegalStateException("Cannot produce output schema: columns with name \"" + name + "\" appear in both left and right schemas (and is not a key column for right schema)");
            }
            metaDataOut.add(metaDataRight.get(i));
        }
        return this.leftSchema.newSchema(metaDataOut);
    }

    public List<Writable> joinExamples(List<Writable> leftExample, List<Writable> rightExample) {
        ArrayList<Writable> out = new ArrayList<Writable>();
        if (leftExample == null) {
            if (rightExample == null) {
                throw new IllegalArgumentException("Both examples are null (max 1 allowed to be null)");
            }
            int nLeft = this.leftSchema.numColumns();
            List<String> leftNames = this.leftSchema.getColumnNames();
            int keysSoFar = 0;
            for (int i = 0; i < nLeft; ++i) {
                String name = leftNames.get(i);
                if (ArrayUtils.contains((Object[])this.keyColumnsLeft, (Object)name)) {
                    String rightKeyName = this.keyColumnsRight[keysSoFar];
                    int idxOfRightKey = this.rightSchema.getIndexOfColumn(rightKeyName);
                    out.add(rightExample.get(idxOfRightKey));
                    continue;
                }
                out.add(NullWritable.INSTANCE);
            }
        } else {
            out.addAll(leftExample);
        }
        List<String> rightNames = this.rightSchema.getColumnNames();
        if (rightExample == null) {
            int nRight = this.rightSchema.numColumns();
            for (int i = 0; i < nRight; ++i) {
                String name = rightNames.get(i);
                if (ArrayUtils.contains((Object[])this.keyColumnsRight, (Object)name)) continue;
                out.add(NullWritable.INSTANCE);
            }
        } else {
            for (int i = 0; i < rightExample.size(); ++i) {
                String name = rightNames.get(i);
                if (ArrayUtils.contains((Object[])this.keyColumnsRight, (Object)name)) continue;
                out.add(rightExample.get(i));
            }
        }
        return out;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Schema getLeftSchema() {
        return this.leftSchema;
    }

    public Schema getRightSchema() {
        return this.rightSchema;
    }

    public String[] getKeyColumnsLeft() {
        return this.keyColumnsLeft;
    }

    public String[] getKeyColumnsRight() {
        return this.keyColumnsRight;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setLeftSchema(Schema leftSchema) {
        this.leftSchema = leftSchema;
    }

    public void setRightSchema(Schema rightSchema) {
        this.rightSchema = rightSchema;
    }

    public void setKeyColumnsLeft(String[] keyColumnsLeft) {
        this.keyColumnsLeft = keyColumnsLeft;
    }

    public void setKeyColumnsRight(String[] keyColumnsRight) {
        this.keyColumnsRight = keyColumnsRight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !((Object)((Object)this$joinType)).equals((Object)other$joinType)) {
            return false;
        }
        Schema this$leftSchema = this.getLeftSchema();
        Schema other$leftSchema = other.getLeftSchema();
        if (this$leftSchema == null ? other$leftSchema != null : !((Object)this$leftSchema).equals(other$leftSchema)) {
            return false;
        }
        Schema this$rightSchema = this.getRightSchema();
        Schema other$rightSchema = other.getRightSchema();
        if (this$rightSchema == null ? other$rightSchema != null : !((Object)this$rightSchema).equals(other$rightSchema)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getKeyColumnsLeft(), other.getKeyColumnsLeft())) {
            return false;
        }
        return Arrays.deepEquals(this.getKeyColumnsRight(), other.getKeyColumnsRight());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : ((Object)((Object)$joinType)).hashCode());
        Schema $leftSchema = this.getLeftSchema();
        result = result * 59 + ($leftSchema == null ? 43 : ((Object)$leftSchema).hashCode());
        Schema $rightSchema = this.getRightSchema();
        result = result * 59 + ($rightSchema == null ? 43 : ((Object)$rightSchema).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getKeyColumnsLeft());
        result = result * 59 + Arrays.deepHashCode(this.getKeyColumnsRight());
        return result;
    }

    public String toString() {
        return "Join(joinType=" + (Object)((Object)this.getJoinType()) + ", leftSchema=" + this.getLeftSchema() + ", rightSchema=" + this.getRightSchema() + ", keyColumnsLeft=" + Arrays.deepToString(this.getKeyColumnsLeft()) + ", keyColumnsRight=" + Arrays.deepToString(this.getKeyColumnsRight()) + ")";
    }

    public static class Builder {
        private JoinType joinType;
        private Schema leftSchema;
        private Schema rightSchema;
        private String[] keyColumnsLeft;
        private String[] keyColumnsRight;

        public Builder(JoinType type) {
            this.joinType = type;
        }

        public Builder setSchemas(Schema left, Schema right) {
            this.leftSchema = left;
            this.rightSchema = right;
            return this;
        }

        public Builder setKeyColumns(String ... keyColumnNames) {
            this.setKeyColumnsLeft(keyColumnNames);
            return this.setKeyColumnsRight(keyColumnNames);
        }

        public Builder setKeyColumnsLeft(String ... keyColumnNames) {
            this.keyColumnsLeft = keyColumnNames;
            return this;
        }

        public Builder setKeyColumnsRight(String ... keyColumnNames) {
            this.keyColumnsRight = keyColumnNames;
            return this;
        }

        public Join build() {
            if (this.leftSchema == null || this.rightSchema == null) {
                throw new IllegalStateException("Cannot build Join: left and/or right schemas are null");
            }
            return new Join(this);
        }
    }

    public static enum JoinType {
        Inner,
        LeftOuter,
        RightOuter,
        FullOuter;

    }
}

