/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DeriveColumnsFromTimeTransform
implements Transform {
    private final String columnName;
    private final String insertAfter;
    private final List<DerivedColumn> derivedColumns;
    private Schema inputSchema;
    private DateTimeZone inputTimeZone;
    private int insertAfterIdx = -1;
    private int deriveFromIdx = -1;

    private DeriveColumnsFromTimeTransform(Builder builder) {
        this.derivedColumns = builder.derivedColumns;
        this.columnName = builder.columnName;
        this.insertAfter = builder.insertAfter;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size() + this.derivedColumns.size());
        List<String> oldNames = inputSchema.getColumnNames();
        ArrayList<String> newNames = new ArrayList<String>(oldNames.size() + this.derivedColumns.size());
        for (int i = 0; i < oldMeta.size(); ++i) {
            String current = oldNames.get(i);
            newNames.add(current);
            newMeta.add(oldMeta.get(i));
            if (!this.insertAfter.equals(current)) continue;
            block5: for (DerivedColumn d : this.derivedColumns) {
                newNames.add(d.columnName);
                switch (d.columnType) {
                    case String: {
                        newMeta.add(new StringMetaData());
                        continue block5;
                    }
                    case Integer: {
                        newMeta.add(new IntegerMetaData());
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected column type: " + (Object)((Object)d.columnType));
            }
        }
        return inputSchema.newSchema(newNames, newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.insertAfterIdx = inputSchema.getColumnNames().indexOf(this.insertAfter);
        if (this.insertAfterIdx == -1) {
            throw new IllegalStateException("Invalid schema/insert after column: input schema does not contain column \"" + this.insertAfter + "\"");
        }
        this.deriveFromIdx = inputSchema.getColumnNames().indexOf(this.columnName);
        if (this.deriveFromIdx == -1) {
            throw new IllegalStateException("Invalid source column: input schema does not contain column \"" + this.columnName + "\"");
        }
        this.inputSchema = inputSchema;
        if (!(inputSchema.getMetaData(this.columnName) instanceof TimeMetaData)) {
            throw new IllegalStateException("Invalid state: input column \"" + this.columnName + "\" is not a time column. Is: " + inputSchema.getMetaData(this.columnName));
        }
        TimeMetaData meta = (TimeMetaData)inputSchema.getMetaData(this.columnName);
        this.inputTimeZone = meta.getTimeZone();
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int i = 0;
        Writable source = writables.get(this.deriveFromIdx);
        ArrayList<Writable> list = new ArrayList<Writable>(writables.size() + this.derivedColumns.size());
        for (Writable w : writables) {
            list.add(w);
            if (i++ != this.insertAfterIdx) continue;
            block5: for (DerivedColumn d : this.derivedColumns) {
                switch (d.columnType) {
                    case String: {
                        list.add(new Text(d.dateTimeFormatter.print(source.toLong())));
                        continue block5;
                    }
                    case Integer: {
                        DateTime dt = new DateTime(source.toLong(), this.inputTimeZone);
                        list.add(new IntWritable(dt.get(d.fieldType)));
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected column type: " + (Object)((Object)d.columnType));
            }
        }
        return list;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(sequence.size());
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeriveColumnsFromTimeTransform(timeColumnName=\"").append(this.columnName).append("\",insertAfter=\"").append(this.insertAfter).append("\",derivedColumns=(");
        boolean first = true;
        for (DerivedColumn d : this.derivedColumns) {
            if (!first) {
                sb.append(",");
            }
            sb.append(d);
            first = false;
        }
        sb.append("))");
        return sb.toString();
    }

    private static class DerivedColumn
    implements Serializable {
        private final String columnName;
        private final ColumnType columnType;
        private final String format;
        private final DateTimeZone dateTimeZone;
        private final DateTimeFieldType fieldType;
        private transient DateTimeFormatter dateTimeFormatter;

        public DerivedColumn(String columnName, ColumnType columnType, String format, DateTimeZone dateTimeZone, DateTimeFieldType fieldType) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.format = format;
            this.dateTimeZone = dateTimeZone;
            this.fieldType = fieldType;
            if (format != null) {
                this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.format).withZone(dateTimeZone);
            }
        }

        public String toString() {
            return "(name=" + this.columnName + ",type=" + (Object)((Object)this.columnType) + ",derived=" + (this.format != null ? this.format : this.fieldType) + ")";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.format != null) {
                this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.format).withZone(this.dateTimeZone);
            }
        }
    }

    public static class Builder {
        private final String columnName;
        private String insertAfter;
        private final List<DerivedColumn> derivedColumns = new ArrayList<DerivedColumn>();

        public Builder(String timeColumnName) {
            this.columnName = timeColumnName;
            this.insertAfter = timeColumnName;
        }

        public Builder insertAfter(String columnName) {
            this.insertAfter = columnName;
            return this;
        }

        public Builder addStringDerivedColumn(String columnName, String format, DateTimeZone timeZone) {
            this.derivedColumns.add(new DerivedColumn(columnName, ColumnType.String, format, timeZone, null));
            return this;
        }

        public Builder addIntegerDerivedColumn(String columnName, DateTimeFieldType type) {
            this.derivedColumns.add(new DerivedColumn(columnName, ColumnType.Integer, null, null, type));
            return this;
        }

        public DeriveColumnsFromTimeTransform build() {
            return new DeriveColumnsFromTimeTransform(this);
        }
    }
}

