/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class RenameColumnsTransform
implements Transform {
    private final List<String> oldNames;
    private final List<String> newNames;
    private Schema inputSchema;

    public RenameColumnsTransform(String oldName, String newName) {
        this(Collections.singletonList(oldName), Collections.singletonList(newName));
    }

    public RenameColumnsTransform(List<String> oldNames, List<String> newNames) {
        if (oldNames.size() != newNames.size()) {
            throw new IllegalArgumentException("Invalid input: old/new names lists differ in length");
        }
        this.oldNames = oldNames;
        this.newNames = newNames;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<String> inputNames = inputSchema.getColumnNames();
        ArrayList<String> outputNames = new ArrayList<String>(this.oldNames.size());
        for (String s : inputNames) {
            int idx = this.oldNames.indexOf(s);
            if (idx >= 0) {
                outputNames.add(this.newNames.get(idx));
                continue;
            }
            outputNames.add(s);
        }
        return inputSchema.newSchema(outputNames, inputSchema.getColumnMetaData());
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        return writables;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        return sequence;
    }

    public String toString() {
        return "RenameColumnsTransform(oldNames=" + this.oldNames + ",newNames=" + this.newNames + ")";
    }
}

