/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.Writable;

public class StringMetaData
implements ColumnMetaData {
    private final String regex;
    private final Integer minLength;
    private final Integer maxLength;

    public StringMetaData() {
        this(null, null, null);
    }

    public StringMetaData(String mustMatchRegex, Integer minLength, Integer maxLength) {
        this.regex = mustMatchRegex;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.String;
    }

    @Override
    public boolean isValid(Writable writable) {
        String str = writable.toString();
        int len = str.length();
        if (this.minLength != null && len < this.minLength) {
            return false;
        }
        if (this.maxLength != null && len > this.maxLength) {
            return false;
        }
        return this.regex == null || str.matches(this.regex);
    }

    @Override
    public StringMetaData clone() {
        return new StringMetaData(this.regex, this.minLength, this.maxLength);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringMetaData(");
        if (this.minLength != null) {
            sb.append("minLengthAllowed=").append(this.minLength);
        }
        if (this.maxLength != null) {
            if (this.minLength != null) {
                sb.append(",");
            }
            sb.append("maxLengthAllowed=").append(this.maxLength);
        }
        if (this.regex != null) {
            if (this.minLength != null || this.maxLength != null) {
                sb.append(",");
            }
            sb.append("regex=").append(this.regex);
        }
        sb.append(")");
        return sb.toString();
    }
}

