/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class DoubleColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final double value;
    private final Set<Double> set;

    public DoubleColumnCondition(String column, ConditionOp op, double value) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public DoubleColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, double value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public DoubleColumnCondition(String column, ConditionOp op, Set<Double> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public DoubleColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Double> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = 0.0;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toDouble() < this.value;
            }
            case LessOrEqual: {
                return writable.toDouble() <= this.value;
            }
            case GreaterThan: {
                return writable.toDouble() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toDouble() >= this.value;
            }
            case Equal: {
                return writable.toDouble() == this.value;
            }
            case NotEqual: {
                return writable.toDouble() != this.value;
            }
            case InSet: {
                return this.set.contains(writable.toDouble());
            }
            case NotInSet: {
                return !this.set.contains(writable.toDouble());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "DoubleColumnCondition(colName=\"" + this.column + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : Double.valueOf(this.value)) + ")";
    }
}

