/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.List;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public abstract class BaseColumnCondition
implements Condition {
    public static final SequenceConditionMode DEFAULT_SEQUENCE_CONDITION_MODE = SequenceConditionMode.Or;
    protected final String column;
    protected int columnIdx = -1;
    protected Schema schema;
    protected SequenceConditionMode sequenceMode;

    protected BaseColumnCondition(String column, SequenceConditionMode sequenceConditionMode) {
        this.column = column;
        this.sequenceMode = sequenceConditionMode;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.columnIdx = schema.getColumnNames().indexOf(this.column);
        if (this.columnIdx < 0) {
            throw new IllegalStateException("Invalid state: column \"" + this.column + "\" not present in input schema");
        }
        this.schema = schema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public boolean condition(List<Writable> list) {
        return this.columnCondition(list.get(this.columnIdx));
    }

    @Override
    public boolean conditionSequence(List<List<Writable>> list) {
        switch (this.sequenceMode) {
            case And: {
                for (List<Writable> l : list) {
                    if (this.condition(l)) continue;
                    return false;
                }
                return true;
            }
            case Or: {
                for (List<Writable> l : list) {
                    if (!this.condition(l)) continue;
                    return true;
                }
                return false;
            }
            case NoSequenceMode: {
                throw new IllegalStateException("Column condition " + this.toString() + " does not support sequence execution");
            }
        }
        throw new RuntimeException("Unknown/not implemented sequence mode: " + (Object)((Object)this.sequenceMode));
    }

    public abstract boolean columnCondition(Writable var1);

    public abstract String toString();
}

