/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.DataAction;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.analysis.DataAnalysis;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.reduce.IReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.ConvertFromSequence;
import org.datavec.api.transform.sequence.ConvertToSequence;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.transform.sequence.window.ReduceSequenceByWindowTransform;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.transform.transform.categorical.CategoricalToIntegerTransform;
import org.datavec.api.transform.transform.categorical.CategoricalToOneHotTransform;
import org.datavec.api.transform.transform.categorical.IntegerToCategoricalTransform;
import org.datavec.api.transform.transform.categorical.StringToCategoricalTransform;
import org.datavec.api.transform.transform.column.DuplicateColumnsTransform;
import org.datavec.api.transform.transform.column.RemoveColumnsTransform;
import org.datavec.api.transform.transform.column.RenameColumnsTransform;
import org.datavec.api.transform.transform.column.ReorderColumnsTransform;
import org.datavec.api.transform.transform.condition.ConditionalReplaceValueTransform;
import org.datavec.api.transform.transform.doubletransform.DoubleColumnsMathOpTransform;
import org.datavec.api.transform.transform.doubletransform.DoubleMathOpTransform;
import org.datavec.api.transform.transform.doubletransform.Log2Normalizer;
import org.datavec.api.transform.transform.doubletransform.MinMaxNormalizer;
import org.datavec.api.transform.transform.doubletransform.StandardizeNormalizer;
import org.datavec.api.transform.transform.doubletransform.SubtractMeanNormalizer;
import org.datavec.api.transform.transform.integer.IntegerColumnsMathOpTransform;
import org.datavec.api.transform.transform.integer.IntegerMathOpTransform;
import org.datavec.api.transform.transform.longtransform.LongColumnsMathOpTransform;
import org.datavec.api.transform.transform.longtransform.LongMathOpTransform;
import org.datavec.api.transform.transform.normalize.Normalize;
import org.datavec.api.transform.transform.string.RemoveWhiteSpaceTransform;
import org.datavec.api.transform.transform.string.StringMapTransform;
import org.datavec.api.transform.transform.time.StringToTimeTransform;
import org.datavec.api.transform.transform.time.TimeMathOpTransform;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;

public class TransformProcess
implements Serializable {
    private final Schema initialSchema;
    private List<DataAction> actionList;

    private TransformProcess(Builder builder) {
        this.actionList = builder.actionList;
        this.initialSchema = builder.initialSchema;
        Schema currInputSchema = builder.initialSchema;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                t.setInputSchema(currInputSchema);
                currInputSchema = t.transform(currInputSchema);
                continue;
            }
            if (d.getFilter() != null) {
                d.getFilter().setInputSchema(currInputSchema);
                continue;
            }
            if (d.getConvertToSequence() != null) {
                if (currInputSchema instanceof SequenceSchema) {
                    throw new RuntimeException("Cannot convert to sequence: schema is already a sequence schema: " + currInputSchema);
                }
                ConvertToSequence cts = d.getConvertToSequence();
                cts.setInputSchema(currInputSchema);
                currInputSchema = cts.transform(currInputSchema);
                continue;
            }
            if (d.getConvertFromSequence() != null) {
                ConvertFromSequence cfs = d.getConvertFromSequence();
                if (!(currInputSchema instanceof SequenceSchema)) {
                    throw new RuntimeException("Cannot convert from sequence: schema is not a sequence schema: " + currInputSchema);
                }
                cfs.setInputSchema((SequenceSchema)currInputSchema);
                currInputSchema = cfs.transform((SequenceSchema)currInputSchema);
                continue;
            }
            if (d.getSequenceSplit() != null) {
                d.getSequenceSplit().setInputSchema(currInputSchema);
                continue;
            }
            if (d.getReducer() != null) {
                IReducer reducer = d.getReducer();
                reducer.setInputSchema(currInputSchema);
                currInputSchema = reducer.transform(currInputSchema);
                continue;
            }
            if (d.getCalculateSortedRank() != null) {
                CalculateSortedRank csr = d.getCalculateSortedRank();
                csr.setInputSchema(currInputSchema);
                currInputSchema = csr.transform(currInputSchema);
                continue;
            }
            throw new RuntimeException("Unknown action: " + d);
        }
    }

    public List<DataAction> getActionList() {
        return this.actionList;
    }

    public Schema getFinalSchema() {
        return this.getSchemaAfterStep(this.actionList.size());
    }

    public Schema getSchemaAfterStep(int step) {
        Schema currInputSchema = this.initialSchema;
        int i = 0;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currInputSchema = t.transform(currInputSchema);
            } else {
                if (d.getFilter() != null) {
                    ++i;
                    continue;
                }
                if (d.getConvertToSequence() != null) {
                    if (currInputSchema instanceof SequenceSchema) {
                        throw new RuntimeException("Cannot convert to sequence: schema is already a sequence schema: " + currInputSchema);
                    }
                    ConvertToSequence cts = d.getConvertToSequence();
                    currInputSchema = cts.transform(currInputSchema);
                } else if (d.getConvertFromSequence() != null) {
                    ConvertFromSequence cfs = d.getConvertFromSequence();
                    if (!(currInputSchema instanceof SequenceSchema)) {
                        throw new RuntimeException("Cannot convert from sequence: schema is not a sequence schema: " + currInputSchema);
                    }
                    currInputSchema = cfs.transform((SequenceSchema)currInputSchema);
                } else {
                    if (d.getSequenceSplit() != null) continue;
                    if (d.getReducer() != null) {
                        IReducer reducer = d.getReducer();
                        currInputSchema = reducer.transform(currInputSchema);
                    } else if (d.getCalculateSortedRank() != null) {
                        CalculateSortedRank csr = d.getCalculateSortedRank();
                        currInputSchema = csr.transform(currInputSchema);
                    } else {
                        throw new RuntimeException("Unknown action: " + d);
                    }
                }
            }
            if (i++ != step) continue;
            return currInputSchema;
        }
        return currInputSchema;
    }

    public List<Writable> execute(List<Writable> input) {
        List<Writable> currValues = input;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currValues = t.map(currValues);
                continue;
            }
            if (d.getFilter() != null) {
                Filter f = d.getFilter();
                if (!f.removeExample(currValues)) continue;
                return null;
            }
            if (d.getConvertToSequence() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a ConvertToSequence operation");
            }
            if (d.getConvertFromSequence() != null) {
                throw new RuntimeException("Unexpected operation: TransformProcess contains a ConvertFromSequence operation");
            }
            if (d.getSequenceSplit() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a SequenceSplit operation");
            }
            throw new RuntimeException("Unknown action: " + d);
        }
        return currValues;
    }

    public List<List<Writable>> executeSequenceToSequence(List<List<Writable>> input) {
        List<List<Writable>> currValues = input;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currValues = t.mapSequence(currValues);
                continue;
            }
            if (d.getFilter() != null) {
                throw new RuntimeException("Sequence filtering not yet implemnted here");
            }
            if (d.getConvertToSequence() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a ConvertToSequence operation");
            }
            if (d.getConvertFromSequence() != null) {
                throw new RuntimeException("Unexpected operation: TransformProcess contains a ConvertFromSequence operation");
            }
            if (d.getSequenceSplit() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a SequenceSplit operation");
            }
            throw new RuntimeException("Unknown action: " + d);
        }
        return currValues;
    }

    public List<List<Writable>> executeSequence(List<List<Writable>> inputSequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Schema getInitialSchema() {
        return this.initialSchema;
    }

    public void setActionList(List<DataAction> actionList) {
        this.actionList = actionList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformProcess)) {
            return false;
        }
        TransformProcess other = (TransformProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$initialSchema = this.getInitialSchema();
        Schema other$initialSchema = other.getInitialSchema();
        if (this$initialSchema == null ? other$initialSchema != null : !this$initialSchema.equals(other$initialSchema)) {
            return false;
        }
        List<DataAction> this$actionList = this.getActionList();
        List<DataAction> other$actionList = other.getActionList();
        return !(this$actionList == null ? other$actionList != null : !((Object)this$actionList).equals(other$actionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $initialSchema = this.getInitialSchema();
        result = result * 59 + ($initialSchema == null ? 43 : $initialSchema.hashCode());
        List<DataAction> $actionList = this.getActionList();
        result = result * 59 + ($actionList == null ? 43 : ((Object)$actionList).hashCode());
        return result;
    }

    public String toString() {
        return "TransformProcess(initialSchema=" + this.getInitialSchema() + ", actionList=" + this.getActionList() + ")";
    }

    public static class Builder {
        private List<DataAction> actionList = new ArrayList<DataAction>();
        private Schema initialSchema;

        public Builder(Schema initialSchema) {
            this.initialSchema = initialSchema;
        }

        public Builder transform(Transform transform) {
            this.actionList.add(new DataAction(transform));
            return this;
        }

        public Builder filter(Filter filter) {
            this.actionList.add(new DataAction(filter));
            return this;
        }

        public Builder removeColumns(String ... columnNames) {
            return this.transform(new RemoveColumnsTransform(columnNames));
        }

        public Builder removeColumns(Collection<String> columnNames) {
            return this.transform(new RemoveColumnsTransform(columnNames.toArray(new String[columnNames.size()])));
        }

        public Builder renameColumn(String oldName, String newName) {
            return this.transform(new RenameColumnsTransform(oldName, newName));
        }

        public Builder renameColumns(List<String> oldNames, List<String> newNames) {
            return this.transform(new RenameColumnsTransform(oldNames, newNames));
        }

        public Builder reorderColumns(String ... newOrder) {
            return this.transform(new ReorderColumnsTransform(newOrder));
        }

        public Builder duplicateColumn(String columnName, String newName) {
            return this.transform(new DuplicateColumnsTransform(Collections.singletonList(columnName), Collections.singletonList(newName)));
        }

        public Builder duplicateColumns(List<String> columnNames, List<String> newNames) {
            return this.transform(new DuplicateColumnsTransform(columnNames, newNames));
        }

        public Builder integerMathOp(String columnName, MathOp mathOp, int scalar) {
            return this.transform(new IntegerMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder integerColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new IntegerColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder longMathOp(String columnName, MathOp mathOp, long scalar) {
            return this.transform(new LongMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder longColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new LongColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder doubleMathOp(String columnName, MathOp mathOp, double scalar) {
            return this.transform(new DoubleMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder doubleColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new DoubleColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder timeMathOp(String columnName, MathOp mathOp, long timeQuantity, TimeUnit timeUnit) {
            return this.transform(new TimeMathOpTransform(columnName, mathOp, timeQuantity, timeUnit));
        }

        public Builder categoricalToOneHot(String ... columnNames) {
            for (String s : columnNames) {
                this.transform(new CategoricalToOneHotTransform(s));
            }
            return this;
        }

        public Builder categoricalToInteger(String ... columnNames) {
            for (String s : columnNames) {
                this.transform(new CategoricalToIntegerTransform(s));
            }
            return this;
        }

        public Builder integerToCategorical(String columnName, List<String> categoryStateNames) {
            return this.transform(new IntegerToCategoricalTransform(columnName, categoryStateNames));
        }

        public Builder integerToCategorical(String columnName, Map<Integer, String> categoryIndexNameMap) {
            return this.transform(new IntegerToCategoricalTransform(columnName, categoryIndexNameMap));
        }

        public Builder normalize(String column, Normalize type, DataAnalysis da) {
            ColumnAnalysis ca = da.getColumnAnalysis(column);
            if (!(ca instanceof NumericalColumnAnalysis)) {
                throw new IllegalStateException("Column \"" + column + "\" analysis is not numerical. " + "Column is not numerical?");
            }
            NumericalColumnAnalysis nca = (NumericalColumnAnalysis)ca;
            double min = nca.getMinDouble();
            double max = nca.getMaxDouble();
            double mean = nca.getMean();
            double sigma = nca.getSampleStdev();
            switch (type) {
                case MinMax: {
                    return this.transform(new MinMaxNormalizer(column, min, max));
                }
                case MinMax2: {
                    return this.transform(new MinMaxNormalizer(column, min, max, -1.0, 1.0));
                }
                case Standardize: {
                    return this.transform(new StandardizeNormalizer(column, mean, sigma));
                }
                case SubtractMean: {
                    return this.transform(new SubtractMeanNormalizer(column, mean));
                }
                case Log2Mean: {
                    return this.transform(new Log2Normalizer(column, mean, min, 0.5));
                }
                case Log2MeanExcludingMin: {
                    long countMin = nca.getCountMinValue();
                    double meanExMin = (mean * (double)ca.getCountTotal() - (double)countMin * min) / (double)(ca.getCountTotal() - countMin);
                    return this.transform(new Log2Normalizer(column, meanExMin, min, 0.5));
                }
            }
            throw new RuntimeException("Unknown/not implemented normalization type: " + (Object)((Object)type));
        }

        public Builder convertToSequence(String keyColumn, SequenceComparator comparator) {
            this.actionList.add(new DataAction(new ConvertToSequence(keyColumn, comparator)));
            return this;
        }

        public Builder convertFromSequence() {
            this.actionList.add(new DataAction(new ConvertFromSequence()));
            return this;
        }

        public Builder splitSequence(SequenceSplit split) {
            this.actionList.add(new DataAction(split));
            return this;
        }

        public Builder reduce(IReducer reducer) {
            this.actionList.add(new DataAction(reducer));
            return this;
        }

        public Builder reduceSequenceByWindow(IReducer reducer, WindowFunction windowFunction) {
            this.actionList.add(new DataAction(new ReduceSequenceByWindowTransform(reducer, windowFunction)));
            return this;
        }

        public Builder calculateSortedRank(String newColumnName, String sortOnColumn, Comparator<Writable> comparator) {
            this.actionList.add(new DataAction(new CalculateSortedRank(newColumnName, sortOnColumn, comparator)));
            return this;
        }

        public Builder calculateSortedRank(String newColumnName, String sortOnColumn, Comparator<Writable> comparator, boolean ascending) {
            this.actionList.add(new DataAction(new CalculateSortedRank(newColumnName, sortOnColumn, comparator, ascending)));
            return this;
        }

        public Builder stringToCategorical(String columnName, List<String> stateNames) {
            return this.transform(new StringToCategoricalTransform(columnName, stateNames));
        }

        public Builder stringRemoveWhitespaceTransform(String columnName) {
            return this.transform(new RemoveWhiteSpaceTransform(columnName));
        }

        public Builder stringMapTransform(String columnName, Map<String, String> mapping) {
            return this.transform(new StringMapTransform(columnName, mapping));
        }

        public Builder stringToTimeTransform(String column, String format, DateTimeZone dateTimeZone) {
            return this.transform(new StringToTimeTransform(column, format, dateTimeZone));
        }

        public Builder conditionalReplaceValueTransform(String column, Writable newValue, Condition condition) {
            return this.transform(new ConditionalReplaceValueTransform(column, newValue, condition));
        }

        public TransformProcess build() {
            return new TransformProcess(this);
        }
    }
}

