/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class FieldSelection {
    public static final Writable DEFAULT_MISSING_VALUE = new Text("");
    private List<String[]> fieldPaths;
    private List<Writable> valueIfMissing;

    private FieldSelection(Builder builder) {
        this.fieldPaths = builder.fieldPaths;
        this.valueIfMissing = builder.valueIfMissing;
    }

    public List<String[]> getFieldPaths() {
        return this.fieldPaths;
    }

    public List<Writable> getValueIfMissing() {
        return this.valueIfMissing;
    }

    public int getNumFields() {
        return this.fieldPaths.size();
    }

    public static class Builder {
        private List<String[]> fieldPaths = new ArrayList<String[]>();
        private List<Writable> valueIfMissing = new ArrayList<Writable>();

        public Builder addField(String ... fieldPath) {
            return this.addField(DEFAULT_MISSING_VALUE, fieldPath);
        }

        public Builder addField(Writable valueIfMissing, String ... fieldPath) {
            this.fieldPaths.add(fieldPath);
            this.valueIfMissing.add(valueIfMissing);
            return this;
        }

        public FieldSelection build() {
            return new FieldSelection(this);
        }
    }
}

