/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.xml.XMLStoreManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.fieldmanager.FetchFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER_XML = Localiser.getInstance((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLStoreManager.class.getClassLoader());
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public XMLPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        if (op.getClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(op);
                throw new NucleusUserException(LOCALISER_XML.msg("XML.Insert.ObjectWithIdAlreadyExists", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            Document doc = (Document)mconn.getConnection();
            AbstractClassMetaData acmd = op.getClassMetaData();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            Node classnode = this.getNodeForClass(doc, acmd);
            ((XMLStoreManager)this.storeMgr).getJAXBHandler().marshall(op.getObject(), classnode, op.getExecutionContext().getClassLoaderResolver());
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (acmd.isVersioned()) {
                // empty if block
            }
            int[] fieldNumbers = op.getClassMetaData().getAllMemberPositions();
            op.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(op, true));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)LOCALISER_XML.msg("XML.Insert.ObjectPersisted", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData acmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            Document doc = (Document)mconn.getConnection();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.Update.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)str));
            }
            if (acmd.isVersioned()) {
                // empty if block
            }
            Node classnode = this.getNodeForClass(doc, acmd);
            op.loadUnloadedFields();
            Node node = XMLUtils.findNode(doc, op);
            node.getParentNode().removeChild(node);
            ((XMLStoreManager)this.storeMgr).getJAXBHandler().marshall(op.getObject(), classnode, op.getExecutionContext().getClassLoaderResolver());
            op.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(op, false));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementUpdateCount();
                ec.getStatistics().incrementNumWrites();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            AbstractClassMetaData acmd;
            Document doc = (Document)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.Delete.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            if ((acmd = op.getClassMetaData()).isVersioned()) {
                // empty if block
            }
            Node node = XMLUtils.findNode(doc, op);
            node.getParentNode().removeChild(node);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_XML.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuffer fieldsString = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldsString.append(",");
                    }
                    fieldsString.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_XML.msg("XML.Fetch.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)fieldsString));
            }
            Document doc = (Document)mconn.getConnection();
            op.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(op, doc));
            if (cmd.isVersioned()) {
                // empty if block
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_XML.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
                ec.getStatistics().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData acmd = op.getClassMetaData();
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(LOCALISER_XML.msg("XML.DatastoreID"));
        }
        if (acmd.getIdentityType() == IdentityType.NONDURABLE) {
            throw new NucleusException("Nondurable not supported");
        }
        ExecutionContext ec = op.getExecutionContext();
        boolean isStored = false;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_XML.msg("XML.Locate.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
        }
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        String expression = null;
        try {
            Document doc = (Document)mconn.getConnection();
            expression = XMLUtils.getXPathForClass(acmd);
            if (expression == null) {
                if (doc.getDocumentElement() != null) {
                    expression = "/" + doc.getDocumentElement().getNodeName();
                } else {
                    throw new NucleusObjectNotFoundException(LOCALISER_XML.msg("XML.Object.NotFound", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)expression));
                }
            }
            expression = expression + "/" + XMLUtils.getElementNameForClass(acmd);
            String[] pk = acmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pk.length; ++i) {
                AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                String pkElement = XMLUtils.getElementNameForMember(pkmmd, 2);
                Object obj = op.provideField(acmd.getPKMemberPositions()[i]);
                expression = expression + "/" + pkElement + "/text()='" + obj.toString() + "'";
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            isStored = (Boolean)this.xpath.evaluate(expression, doc, XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            throw new NucleusObjectNotFoundException(LOCALISER_XML.msg("XML.Object.NotFound", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)expression));
        }
        finally {
            mconn.release();
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_XML.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        if (!isStored) {
            throw new NucleusObjectNotFoundException(LOCALISER_XML.msg("XML.Object.NotFound", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)expression));
        }
    }

    private Node getNodeForClass(Document doc, AbstractClassMetaData acmd) throws XPathExpressionException, DOMException {
        Node classnode;
        String expression = XMLUtils.getXPathForClass(acmd);
        if (expression == null) {
            if (doc.getDocumentElement() == null) {
                doc.appendChild(doc.createElement(XMLUtils.getDefaultRootXPath()));
            }
            classnode = doc.getDocumentElement();
        } else {
            if (this.xpath.evaluate(expression, doc, XPathConstants.NODE) == null) {
                StringTokenizer xpathElement = new StringTokenizer(expression, "/");
                String path = "";
                String currentelement = null;
                Node node = doc;
                while (xpathElement.hasMoreElements()) {
                    currentelement = xpathElement.nextToken();
                    Node n = (Node)this.xpath.evaluate(path = path + "/" + currentelement, doc, XPathConstants.NODE);
                    if (n == null) {
                        node = node.appendChild(doc.createElement(currentelement));
                        continue;
                    }
                    node = n;
                }
            }
            classnode = (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
        }
        return classnode;
    }
}

