/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractCandidateLazyLoadList;
import org.datanucleus.store.xml.XMLStoreManager;
import org.datanucleus.store.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLCandidateList
extends AbstractCandidateLazyLoadList {
    ManagedConnection mconn;
    boolean ignoreCache;
    List<Integer> numberInstancesPerClass = null;

    public XMLCandidateList(Class cls, boolean subclasses, ExecutionContext ec, String cacheType, ManagedConnection mconn, boolean ignoreCache) {
        super(cls, subclasses, ec, cacheType);
        this.mconn = mconn;
        this.ignoreCache = ignoreCache;
        Document doc = (Document)mconn.getConnection();
        XPath xpath = XPathFactory.newInstance().newXPath();
        this.numberInstancesPerClass = new ArrayList<Integer>();
        for (AbstractClassMetaData cmd : this.cmds) {
            Element el = null;
            String expression = XMLUtils.getXPathForClass(cmd);
            if (expression == null) {
                el = doc.getDocumentElement();
            } else {
                try {
                    el = (Element)xpath.evaluate(expression, doc, XPathConstants.NODE);
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            int size = 0;
            if (el != null) {
                String classElementName = XMLUtils.getElementNameForClass(cmd);
                for (int i = 0; i < el.getChildNodes().getLength(); ++i) {
                    Element elem;
                    if (!(el.getChildNodes().item(i) instanceof Element) || !classElementName.equals((elem = (Element)el.getChildNodes().item(i)).getNodeName())) continue;
                    ++size;
                }
            }
            this.numberInstancesPerClass.add(size);
        }
    }

    protected int getSize() {
        int size = 0;
        Iterator<Integer> numberIter = this.numberInstancesPerClass.iterator();
        while (numberIter.hasNext()) {
            size += numberIter.next().intValue();
        }
        return size;
    }

    protected Object retrieveObjectForIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new NoSuchElementException();
        }
        Document doc = (Document)this.mconn.getConnection();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Iterator cmdIter = this.cmds.iterator();
        Iterator<Integer> numIter = this.numberInstancesPerClass.iterator();
        int first = 0;
        int last = -1;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData cmd = (AbstractClassMetaData)cmdIter.next();
            int number = numIter.next();
            last = first + number;
            if (index >= first && index < last) {
                ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
                int current = first;
                Element el = null;
                String expression = XMLUtils.getXPathForClass(cmd);
                if (expression == null) {
                    el = doc.getDocumentElement();
                } else {
                    try {
                        el = (Element)xpath.evaluate(expression, doc, XPathConstants.NODE);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                }
                if (el == null) continue;
                Class cls = clr.classForName(cmd.getFullClassName());
                String classElementName = XMLUtils.getElementNameForClass(cmd);
                for (int i = 0; i < el.getChildNodes().getLength(); ++i) {
                    Element elem;
                    if (!(el.getChildNodes().item(i) instanceof Element) || !classElementName.equals((elem = (Element)el.getChildNodes().item(i)).getNodeName())) continue;
                    if (current == index) {
                        try {
                            Object obj = ((XMLStoreManager)this.ec.getStoreManager()).getJAXBHandler().unmarshall(cls, el.getChildNodes().item(i), clr);
                            XMLUtils.prepareXMLObjectForUse(obj, this.ec, cmd);
                            return obj;
                        }
                        catch (JAXBException jaxbe) {
                            throw new NucleusUserException("Error in extracting object from XML", (Throwable)jaxbe);
                        }
                    }
                    ++current;
                }
                continue;
            }
            first += number;
        }
        return null;
    }
}

