/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.fieldmanager;

import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FetchFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    Object value;
    Document doc;
    Node node;

    public FetchFieldManager(ObjectProvider sm, Document doc) {
        this.sm = sm;
        this.doc = doc;
        this.node = XMLUtils.findNode(doc, sm);
        try {
            this.value = JAXBRuntimeBinder.unmarshall(sm.getObject().getClass(), this.node, sm.getExecutionContext().getMetaDataManager(), sm.getExecutionContext().getClassLoaderResolver());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public String fetchStringField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (String)this.sm.provideField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (relationType == 0) {
            this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
            return this.sm.provideField(fieldNumber);
        }
        if (mmd.getEmbeddedMetaData() == null) {
            switch (relationType) {
                case 1: 
                case 2: 
                case 6: {
                    AbstractClassMetaData cmd = this.sm.getExecutionContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    NodeList nList = ((Element)this.node).getElementsByTagName(mmd.getName());
                    if (nList.getLength() == 1) {
                        Object id = ec.getApiAdapter().getNewApplicationIdentityObjectId(clr.classForName(cmd.getFullClassName()), (Object)nList.item(0).getFirstChild().getNodeValue());
                        Object related = ec.findObject(id, true, true, null);
                        if (relationType == 2) {
                            ObjectProvider relatedSM = ec.findObjectProvider(related);
                            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.sm.getObject(), related);
                            relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject());
                        }
                        return related;
                    }
                    return null;
                }
                case 3: 
                case 4: {
                    if (mmd.hasCollection()) {
                        AbstractClassMetaData cmd2 = this.sm.getExecutionContext().getMetaDataManager().getMetaDataForClass(mmd.getCollection().getElementType(), clr);
                        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
                        Collection collection = (Collection)this.sm.provideField(fieldNumber);
                        NodeList nLists = ((Element)this.node).getElementsByTagName(XMLUtils.getElementNameForMember(mmd, 3));
                        for (int i = 0; i < nLists.getLength(); ++i) {
                            String nodeValue = nLists.item(i).getFirstChild().getNodeValue();
                            if (nodeValue == null || nodeValue.trim().length() <= 0) continue;
                            AbstractClassMetaData elementCmd = XMLUtils.findMetaDataForNode(this.doc, cmd2, ec.getMetaDataManager(), nodeValue, clr);
                            if (elementCmd == null && cmd2 != null) {
                                throw new NucleusException("Unable to find object of type " + cmd2.getFullClassName() + " with id=" + nodeValue);
                            }
                            Object id = ec.getApiAdapter().getNewApplicationIdentityObjectId(clr.classForName(elementCmd.getFullClassName()), (Object)nodeValue);
                            Object related = ec.findObject(id, true, true, null);
                            if (relationType == 4) {
                                ObjectProvider relatedSM = ec.findObjectProvider(related);
                                AbstractMemberMetaData relatedMmd = relatedSM.getClassMetaData().getMetaDataForMember(mmd.getMappedBy());
                                relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject());
                            }
                            collection.add(related);
                        }
                        return this.sm.wrapSCOField(fieldNumber, (Object)collection, false, false, true);
                    }
                    if (!mmd.hasArray() && !mmd.hasMap()) break;
                }
            }
        }
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Boolean)this.sm.provideField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Byte)this.sm.provideField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return ((Character)this.sm.provideField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Double)this.sm.provideField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return ((Float)this.sm.provideField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Integer)this.sm.provideField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Long)this.sm.provideField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        this.sm.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Short)this.sm.provideField(fieldNumber);
    }
}

