/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class MathFloorMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression ignore, List<SQLExpression> args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke Math.floor without an argument");
        }
        SQLExpression expr = args.get(0);
        if (expr == null) {
            return new NullLiteral(stmt, null, null, null);
        }
        if (expr instanceof SQLLiteral) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                BigInteger absValue = new BigInteger(String.valueOf(Math.floor(originalValue)));
                return new ByteLiteral(stmt, expr.getJavaTypeMapping(), absValue, null);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double absValue = Math.floor(originalValue);
                return new FloatingPointLiteral(stmt, expr.getJavaTypeMapping(), absValue, null);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double absValue = Math.floor(originalValue);
                return new FloatingPointLiteral(stmt, expr.getJavaTypeMapping(), absValue, null);
            }
            throw new IllegalExpressionOperationException("Math.floor()", expr);
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        return exprFactory.invokeMethod(stmt, null, "floor", null, args);
    }
}

