/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.OracleTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.OracleMappingManagerImpl;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OracleBlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OracleClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OracleXMLTypeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLCubeFunction;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.method.SQLRollupFunction;
import org.datanucleus.store.rdbms.sql.method.StringConcat1Method;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf2Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.StringTranslateMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalQuarterMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalWeekMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod2;
import org.datanucleus.store.rdbms.sql.operation.Mod2Operation;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OracleAdapter
extends BaseDatastoreAdapter {
    public static final String OJDBC_DRIVER_NAME = "Oracle JDBC driver";
    public static final String ORACLE_8_RESERVED_WORDS = "ACCESS,AUDIT,CLUSTER,COMMENT,COMPRESS,EXCLUSIVE,FILE,IDENTIFIED,INCREMENT,INDEX,INITIAL,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOWAIT,NUMBER,OFFLINE,ONLINE,PCTFREE,RAW,RENAME,RESOURCE,ROWID,ROWNUM,SHARE,SUCCESSFUL,SYNONYM,SYSDATE,UID,VALIDATE,VARCHAR2,VALIDATE,VARCHAR2";
    public static final String ORACLE_9_RESERVED_WORDS = "ACCESS,CHAR,DEFAULT,ADD,CHECK,DELETE,ALL,CLUSTER,DESC,ALTER,COLUMN,DISTINCT,AND,COMMENT,DROP,ANY,COMPRESS,ELSE,AS,CONNECT,EXCLUSIVE,ASC,CREATE,EXISTS,AUDIT,CURRENT,FILE,BETWEEN,DATE,FLOAT,BY,DECIMAL,FOR,FROM,NOT,SHARE,GRANT,NOWAIT,SIZE,GROUP,NULL,SMALLINT,HAVING,NUMBER,START,IDENTIFIED,OF,SUCCESSFUL,IMMEDIATE,OFFLINE,SYNONYM,IN,ON,SYSDATE,INCREMENT,ONLINE,TABLE,INDEX,OPTION,THEN,INITIAL,OR,TO,INSERT,ORDER,TRIGGER,INTEGER,PCTFREE,UID,INTERSECT,PRIOR,UNION,INTO,PRIVILEGES,UNIQUE,IS,PUBLIC,UPDATE,LEVEL,RAW,USER,LIKE,RENAME,VALIDATE,LOCK,RESOURCE,VALUES,LONG,REVOKE,VARCHAR,MAXEXTENTS,ROW,VARCHAR2,MINUS,ROWID,VIEW,MLSLABEL,ROWNUM,WHENEVER,MODE,ROWS,WHERE,MODIFY,SELECT,WITH,NOAUDIT,SESSION,NOCOMPRESS,SET";
    public static final String ORACLE_10_RESERVED_WORDS = "ACCESS,ADD,ALL,ALTER,AND,ANY,AS,ASC,AUDIT,BETWEEN,BY,CHAR,CHECK,CLUSTER,COLUMN,COMMENT,COMPRESS,CONNECT,CREATE,CURRENT,DATE,DECIMAL,DEFAULT,DELETE,DESC,DISTINCT,DROP,ELSE,EXCLUSIVE,EXISTS,FILE,FLOAT,FOR,FROM,GRANT,GROUP,HAVING,IDENTIFIED,IMMEDIATE,IN,INCREMENT,INDEX,INITIAL,INSERT,INTEGER,INTERSECT,INTO,IS,LEVEL,LIKE,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOT,NOWAIT,NULL,NUMBER,OF,OFFLINE,ON,ONLINE,OPTION,OR,ORDER,PCTFREE,PRIOR,PRIVILEGES,PUBLIC,RAW,RENAME,RESOURCE,REVOKE,ROW,ROWID,ROWNUM,ROWS,SELECT,SESSION,SET,SHARE,SIZE,SMALLINT,START,SUCCESSFUL,SYNONYM,SYSDATE,TABLE,THEN,TO,TRIGGER,UID,UNION,UNIQUE,UPDATE,USER,VALIDATE,VALUES,VARCHAR,VARCHAR2,VIEW,WHENEVER,WHERE,WITH";

    public OracleAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion <= 8) {
            this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)ORACLE_8_RESERVED_WORDS));
        } else if (this.datastoreMajorVersion == 9) {
            this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)ORACLE_9_RESERVED_WORDS));
        } else {
            this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)ORACLE_10_RESERVED_WORDS));
        }
        this.supportedOptions.add("LockRowUsingSelectForUpdate");
        this.supportedOptions.add("LockRowSelectForUpdateNowait");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("NullEqualsEmptyString");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("GroupByIncludesAllSelectPrimaries");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.remove("BooleanExpression");
        if (this.datastoreMajorVersion < 9) {
            this.supportedOptions.remove("ANSI_Join_Syntax");
        } else {
            this.supportedOptions.add("ANSI_Join_Syntax");
        }
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkDeleteActionRestrict");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionRestrict");
        this.supportedOptions.remove("FkUpdateActionNull");
        this.supportedOptions.remove("FkUpdateActionCascade");
        if (this.datastoreMajorVersion >= 12) {
            this.supportedOptions.add("IdentityColumns");
        }
        if (this.datastoreMajorVersion == 11 && this.datastoreMinorVersion >= 2 || this.datastoreMajorVersion >= 12) {
            this.supportedOptions.add("ColumnLengthSemantics");
        }
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLTypeInfo sqlType2 = new OracleTypeInfo("CLOB", 2005, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "CLOB", 0, 0, 10);
        sqlType2.setAllowsPrecisionSpec(false);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType2, true);
        sqlType2 = new OracleTypeInfo("DATE", 91, 7, null, null, null, 1, false, 3, false, false, false, "DATE", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType2, true);
        sqlType2 = new OracleTypeInfo("DECIMAL", 3, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType2, true);
        sqlType2 = new OracleTypeInfo("DOUBLE PRECISION", 8, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType2, true);
        sqlType2 = new OracleTypeInfo("SYS.XMLTYPE", 2007, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "SYS.XMLTYPE", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2007, sqlType2, true);
        sqlType2 = new OracleTypeInfo("NVARCHAR2", -9, 4000, "'", "'", null, 1, true, 3, false, false, false, "NVARCHAR2", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-9, sqlType2, true);
        Collection<SQLTypeInfo> sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2004);
        if (sqlTypes != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2005)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        this.supportedJdbcTypesById.put(2007, "XMLTYPE");
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new OracleTypeInfo(rs);
    }

    @Override
    public MappingManager getMappingManager(RDBMSStoreManager storeMgr) {
        return new OracleMappingManagerImpl(storeMgr);
    }

    @Override
    public String getVendorID() {
        return "oracle";
    }

    @Override
    public String getSurrogateForEmptyStrings() {
        return "\u0001";
    }

    @Override
    public String getCatalogName(Connection conn) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String string;
            String stmtText = "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("Oracle does not support CREATE SCHEMA; you need to create a USER (manually)");
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("Oracle does not support DROP SCHEMA; you need to delete a USER (manually)");
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public ResultSet getExistingIndexes(Connection conn, String catalog, String schema, String table) throws SQLException {
        if (this.isReservedKeyword(table) || !table.matches("[a-zA-Z]{1}\\w*(\\$|\\#)*\\w*")) {
            String GET_INDEXES_STMT = "SELECT null as table_cat, owner as table_schem, table_name, 0 as NON_UNIQUE, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, num_rows as cardinality, blocks as pages, null as filter_condition FROM all_tables WHERE table_name = ? AND owner = ? UNION SELECT null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'UNIQUE', 0, 1), null as index_qualifier, i.index_name, 1 as type, c.column_position as ordinal_position, c.column_name, null as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition FROM all_indexes i, all_ind_columns c WHERE i.table_name = ? AND i.owner = ? AND i.index_name = c.index_name AND i.table_owner = c.table_owner AND i.table_name = c.table_name AND i.owner = c.index_owner ORDER BY non_unique, type, index_name, ordinal_position";
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Retrieving Oracle index info using the following SQL : " + GET_INDEXES_STMT));
            PreparedStatement stmt = conn.prepareStatement(GET_INDEXES_STMT);
            stmt.setString(1, table);
            stmt.setString(2, schema);
            stmt.setString(3, table);
            stmt.setString(4, schema);
            return stmt.executeQuery();
        }
        return super.getExistingIndexes(conn, catalog, schema, table);
    }

    @Override
    public String getDropTableStatement(Table table) {
        if (this.datastoreMajorVersion >= 10) {
            return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS PURGE";
        }
        return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS";
    }

    @Override
    public String getIdentityKeyword(StoreManager storeMgr) {
        return "generated always as identity";
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT ");
        stmt.append(sequenceName);
        stmt.append(".NEXTVAL from dual ");
        return stmt.toString();
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        String typeName = info.getTypeName();
        int dataType = -1;
        if (typeName == null) {
            dataType = 0;
        } else if (typeName.equals("ROWID")) {
            dataType = 4;
        } else if (typeName.equals("NUMBER") || typeName.equals("VARNUM")) {
            dataType = 2;
        } else if (typeName.equals("VARCHAR2")) {
            dataType = 12;
        } else if (typeName.equals("CHAR")) {
            dataType = 1;
        } else if (typeName.equals("DATE")) {
            dataType = 91;
        } else if (typeName.equals("CLOB") || typeName.equals("NCLOB")) {
            dataType = 2005;
        } else if (typeName.equals("BLOB")) {
            dataType = 2004;
        } else if (typeName.equals("LONG")) {
            dataType = -1;
        } else if (typeName.equals("LONG RAW")) {
            dataType = -4;
        } else if (typeName.equals("RAW")) {
            dataType = -3;
        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = 93;
        } else if (typeName.equals("FLOAT")) {
            dataType = 6;
        } else {
            NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"020191", (Object[])new Object[]{typeName}));
            dataType = 1111;
        }
        info.setDataType((short)dataType);
        return info;
    }

    @Override
    public int getTransactionIsolationForSchemaCreation() {
        return 2;
    }

    @Override
    public ResultSet getColumns(Connection conn, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        StringBuilder columnsQuery = new StringBuilder();
        columnsQuery.append("SELECT NULL TABLE_CAT, OWNER TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL DATA_TYPE, ");
        columnsQuery.append("DATA_TYPE TYPE_NAME, DECODE(DATA_TYPE,'NUMBER',DATA_PRECISION,DATA_LENGTH) COLUMN_SIZE, ");
        columnsQuery.append("0 BUFFER_LENGTH, DATA_SCALE DECIMAL_DIGITS, 10 NUM_PREC_RADIX, ");
        columnsQuery.append("DECODE(NULLABLE,'Y',1,0) NULLABLE, NULL REMARKS, NULL COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, ");
        columnsQuery.append("DATA_LENGTH CHAR_OCTET_LENGTH, COLUMN_ID ORDINAL_POSITION, DECODE(NULLABLE,'Y','YES','NO') IS_NULLABLE ");
        columnsQuery.append("FROM ALL_TAB_COLUMNS ");
        boolean outputWhere = false;
        if (schema != null && schema.length() > 0) {
            columnsQuery.append("WHERE OWNER LIKE '").append(schema).append("' ");
            outputWhere = true;
        }
        if (table != null) {
            if (!outputWhere) {
                columnsQuery.append("WHERE ");
                outputWhere = true;
            } else {
                columnsQuery.append("AND ");
            }
            if (table.length() > 0) {
                columnsQuery.append("TABLE_NAME LIKE '").append(table).append("' ");
            } else {
                columnsQuery.append("TABLE_NAME IS NULL ");
            }
        }
        columnsQuery.append("ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Retrieving Oracle column info using the following SQL : " + columnsQuery));
        PreparedStatement columnsStmt = conn.prepareStatement(columnsQuery.toString());
        ResultSet columnsResult = columnsStmt.executeQuery();
        columnsQuery = null;
        return columnsResult;
    }

    @Override
    public String getDatastoreDateStatement() {
        return "SELECT CURRENT_TIMESTAMP FROM DUAL";
    }

    @Override
    public String getOrderString(StoreManager storeMgr, String orderString, SQLExpression sqlExpr) {
        String nlsSortOrder = "LATIN";
        String sortOrder = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_ORACLE_NLS_SORT_ORDER);
        if (sortOrder != null) {
            nlsSortOrder = sortOrder.toUpperCase();
        }
        if (sqlExpr instanceof CharacterExpression && !nlsSortOrder.equals("BINARY")) {
            return "NLSSORT(" + orderString + ", 'NLS_SORT = " + nlsSortOrder + "')";
        }
        if (this.datastoreMajorVersion < 9 && sqlExpr instanceof BooleanExpression && !sqlExpr.getJavaTypeMapping().getColumnMapping(0).isStringBased()) {
            throw new NucleusException(Localiser.msg((String)"052505")).setFatal();
        }
        return orderString;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().equalsIgnoreCase("72000") && sqle.getErrorCode() == 1013) {
            return true;
        }
        return super.isStatementTimeout(sqle);
    }

    @Override
    public boolean validToSelectMappingInStatement(SelectStatement stmt, JavaTypeMapping m) {
        if (m.getNumberOfColumnMappings() <= 0) {
            return true;
        }
        for (int i = 0; i < m.getNumberOfColumnMappings(); ++i) {
            Column col = m.getColumnMapping(i).getColumn();
            if (col.getJdbcType() != JdbcType.CLOB && col.getJdbcType() != JdbcType.BLOB || !stmt.isDistinct()) continue;
            NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using DISTINCT"));
            return false;
        }
        return true;
    }

    @Override
    public String getRangeByRowNumberColumn2() {
        return "ROWNUM";
    }

    @Override
    public Class<? extends SQLOperation> getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod2Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class<? extends SQLMethod> getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod2.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod2.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod2.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod2.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod2.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod2.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod2.class;
            }
            if ("WEEK".equals(methodName)) {
                return TemporalWeekMethod6.class;
            }
            if ("QUARTER".equals(methodName)) {
                return TemporalQuarterMethod2.class;
            }
            if ("SQL_cube".equals(methodName)) {
                return SQLCubeFunction.class;
            }
            if ("SQL_rollup".equals(methodName)) {
                return SQLRollupFunction.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("concat".equals(methodName)) {
                    return StringConcat1Method.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf2Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength3Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring3Method.class;
                }
                if ("translate".equals(methodName)) {
                    return StringTranslateMethod.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod2.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod2.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod2.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod2.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod2.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod2.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod2.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod2.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod2.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod2.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod2.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod2.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod2.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod2.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod2.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod2.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod2.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod2.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod2.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod2.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod2.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", false);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Character.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", false);
        this.registerColumnMapping(Double.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Double.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), OracleClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), OracleBlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), OracleXMLTypeColumnMapping.class, "XMLTYPE", "XMLTYPE", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR2", false);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(BigInteger.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(java.sql.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), OracleBlobColumnMapping.class, JDBCType.BLOB, "BLOB", true);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONG RAW", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "RAW", false);
        this.registerColumnMapping(Serializable.class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "RAW", false);
        this.registerColumnMapping(byte[].class.getName(), OracleBlobColumnMapping.class, JDBCType.BLOB, "BLOB", true);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONG RAW", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "RAW", false);
        this.registerColumnMapping(byte[].class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(byte[].class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "RAW", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMBER", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

