/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.MissingColumnException;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.exceptions.NotAViewException;
import org.datanucleus.store.rdbms.exceptions.PrimaryKeyColumnNotAllowedException;
import org.datanucleus.store.rdbms.exceptions.UnexpectedColumnException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class ViewImpl
extends AbstractTable {
    public ViewImpl(DatastoreIdentifier name, RDBMSStoreManager storeMgr) {
        super(name, storeMgr);
    }

    @Override
    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
    }

    @Override
    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    @Override
    public boolean validate(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection<Throwable> autoCreateErrors) throws SQLException {
        RDBMSSchemaHandler handler;
        String tableType;
        this.assertIsInitialized();
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"031004", (Object[])new Object[]{this}));
        }
        if ((tableType = (handler = (RDBMSSchemaHandler)this.storeMgr.getSchemaHandler()).getTableType(conn, this)) == null) {
            throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
        }
        if (!tableType.equals("VIEW")) {
            throw new NotAViewException(this.toString(), tableType);
        }
        HashMap unvalidated = new HashMap(this.columnsByIdentifier);
        for (RDBMSColumnInfo rDBMSColumnInfo : this.storeMgr.getColumnInfoForTable(this, conn)) {
            DatastoreIdentifier colIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, rDBMSColumnInfo.getColumnName());
            Column col = (Column)unvalidated.get(colIdentifier);
            if (col == null) {
                if (this.hasColumnName(colIdentifier)) continue;
                throw new UnexpectedColumnException(this.toString(), rDBMSColumnInfo.getColumnName(), this.getSchemaName(), this.getCatalogName());
            }
            if (validateColumnStructure) {
                col.validate(rDBMSColumnInfo);
                unvalidated.remove(colIdentifier);
                continue;
            }
            unvalidated.remove(colIdentifier);
        }
        if (unvalidated.size() > 0) {
            throw new MissingColumnException(this, unvalidated.values());
        }
        this.state = 4;
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"045000", (long)(System.currentTimeMillis() - startTime)));
        }
        return false;
    }

    @Override
    protected List<String> getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getDropViewStatement(this));
        return stmts;
    }

    @Override
    protected synchronized void addColumnInternal(Column col) {
        if (col.isPrimaryKey()) {
            throw new PrimaryKeyColumnNotAllowedException(this.toString(), col.getIdentifier().toString());
        }
        super.addColumnInternal(col);
    }
}

