/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.RegularExpressionConverter;

public class StringMatchesMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() > 2) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        if (!(args.get(0) instanceof StringExpression) && !(args.get(0) instanceof ParameterLiteral)) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        SQLExpression likeExpr = args.get(0);
        if (!(likeExpr instanceof StringExpression || likeExpr instanceof CharacterExpression || likeExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"like/matches", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        SQLExpression escapeExpr = null;
        if (args.size() > 1) {
            escapeExpr = args.get(1);
        }
        if ((likeExpr instanceof StringLiteral || likeExpr instanceof ParameterLiteral) && likeExpr.isParameter()) {
            stmt.getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)likeExpr));
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (expr instanceof StringLiteral && likeExpr instanceof StringLiteral) {
            String primary = (String)((StringLiteral)expr).getValue();
            String pattern = (String)((StringLiteral)likeExpr).getValue();
            return new BooleanLiteral(stmt, exprFactory.getMappingForType(Boolean.TYPE, false), primary.matches(pattern));
        }
        if (expr instanceof StringLiteral) {
            return this.getBooleanLikeExpression(stmt, expr, likeExpr, escapeExpr);
        }
        if (expr instanceof StringExpression && likeExpr instanceof StringLiteral) {
            String pattern = (String)((StringLiteral)likeExpr).getValue();
            if (stmt.getQueryGenerator().getQueryLanguage().equalsIgnoreCase("JDOQL")) {
                boolean caseSensitive = false;
                if (pattern.startsWith("(?i)")) {
                    caseSensitive = true;
                    pattern = pattern.substring(4);
                }
                DatastoreAdapter dba = stmt.getDatastoreAdapter();
                RegularExpressionConverter converter = new RegularExpressionConverter(dba.getPatternExpressionZeroMoreCharacters().charAt(0), dba.getPatternExpressionAnyCharacter().charAt(0), dba.getEscapeCharacter().charAt(0));
                if (caseSensitive) {
                    SQLExpression patternExpr = exprFactory.newLiteral(stmt, likeExpr.getJavaTypeMapping(), converter.convert(pattern).toLowerCase());
                    return this.getBooleanLikeExpression(stmt, expr.invoke("toLowerCase", null), patternExpr, escapeExpr);
                }
                SQLExpression patternExpr = exprFactory.newLiteral(stmt, likeExpr.getJavaTypeMapping(), converter.convert(pattern));
                return this.getBooleanLikeExpression(stmt, expr, patternExpr, escapeExpr);
            }
            SQLExpression patternExpr = exprFactory.newLiteral(stmt, likeExpr.getJavaTypeMapping(), pattern);
            return this.getBooleanLikeExpression(stmt, expr, patternExpr, escapeExpr);
        }
        if (expr instanceof StringExpression) {
            return this.getExpressionForStringExpressionInput(stmt, expr, likeExpr, escapeExpr);
        }
        throw new NucleusException(Localiser.msg((String)"060001", (Object[])new Object[]{"matches", expr}));
    }

    protected BooleanExpression getExpressionForStringExpressionInput(SQLStatement stmt, SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        BooleanExpression likeExpr = this.getBooleanLikeExpression(stmt, expr, regExpr, escapeExpr);
        return likeExpr;
    }

    protected BooleanExpression getBooleanLikeExpression(SQLStatement stmt, SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        BooleanExpression likeExpr = new BooleanExpression(stmt, exprFactory.getMappingForType(Boolean.TYPE, false));
        SQLText sql = likeExpr.toSQLText();
        sql.clearStatement();
        if (Expression.OP_LIKE.isHigherThanLeftSide(expr.getLowestOperator())) {
            sql.append("(").append(expr).append(")");
        } else {
            sql.append(expr);
        }
        sql.append(" LIKE ");
        if (Expression.OP_LIKE.isHigherThanRightSide(regExpr.getLowestOperator())) {
            sql.append("(").append(regExpr).append(")");
        } else {
            sql.append(regExpr);
        }
        BaseDatastoreAdapter dba = (BaseDatastoreAdapter)stmt.getRDBMSManager().getDatastoreAdapter();
        if (escapeExpr != null) {
            if (escapeExpr instanceof CharacterLiteral) {
                String chr = "" + ((CharacterLiteral)escapeExpr).getValue();
                if (chr.equals(dba.getEscapeCharacter())) {
                    sql.append(dba.getEscapePatternExpression());
                } else {
                    sql.append(" ESCAPE " + escapeExpr);
                }
            } else {
                sql.append(" ESCAPE " + escapeExpr);
            }
        } else {
            sql.append(" " + dba.getEscapePatternExpression());
        }
        return likeExpr;
    }
}

