/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleCollectionMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static NumericExpression getNumericExpression(SQLExpression expr) {
        RDBMSStoreManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        SQLExpressionFactory factory = storeMgr.getSQLExpressionFactory();
        DatastoreAdapter dba = expr.getSQLStatement().getDatastoreAdapter();
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        if (expr instanceof SQLLiteral) {
            BigInteger value = new BigInteger((String)((SQLLiteral)((Object)expr)).getValue());
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        return new NumericExpression(expr.getSQLStatement(), expr.getJavaTypeMapping(), dba.getNumericConversionFunction(), args);
    }

    public static SQLExpression getLiteralForOne(SQLStatement stmt) {
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(BigInteger.class);
        return storeMgr.getSQLExpressionFactory().newLiteral(stmt, mapping, BigInteger.ONE);
    }

    public static SQLExpression getEscapedPatternExpression(SQLExpression patternExpr) {
        if (patternExpr instanceof StringLiteral) {
            String value = (String)((StringLiteral)patternExpr).getValue();
            SQLExpressionFactory exprFactory = patternExpr.getSQLStatement().getSQLExpressionFactory();
            JavaTypeMapping m = exprFactory.getMappingForType(String.class, false);
            if (value != null) {
                value = value.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
            }
            return exprFactory.newLiteral(patternExpr.getSQLStatement(), m, value);
        }
        return patternExpr;
    }

    public static int populatePrimaryKeyMappingsValuesForPCMapping(JavaTypeMapping[] pkMappings, Object[] pkFieldValues, int position, PersistableMapping pcMapping, AbstractClassMetaData cmd, AbstractMemberMetaData mmd, Object fieldValue, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ExecutionContext ec = storeMgr.getApiAdapter().getExecutionContext(fieldValue);
        JavaTypeMapping[] subMappings = pcMapping.getJavaTypeMapping();
        if (subMappings.length == 0) {
            DatastoreClass table = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            JavaTypeMapping ownerMapping = table.getMemberMapping(mmd);
            EmbeddedMapping embMapping = (EmbeddedMapping)ownerMapping;
            for (int k = 0; k < embMapping.getNumberOfJavaTypeMappings(); ++k) {
                JavaTypeMapping subMapping;
                pkMappings[position] = subMapping = embMapping.getJavaTypeMapping(k);
                pkFieldValues[position] = ExpressionUtils.getValueForMemberOfObject(ec, subMapping.getMemberMetaData(), fieldValue);
                ++position;
            }
        } else {
            AbstractClassMetaData pcCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(pcMapping.getType(), clr);
            int[] pcPkPositions = pcCmd.getPKMemberPositions();
            for (int k = 0; k < subMappings.length; ++k) {
                Object val;
                AbstractMemberMetaData pcMmd = pcCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcPkPositions[k]);
                if (subMappings[k] instanceof PersistableMapping) {
                    val = ExpressionUtils.getValueForMemberOfObject(ec, pcMmd, fieldValue);
                    position = ExpressionUtils.populatePrimaryKeyMappingsValuesForPCMapping(pkMappings, pkFieldValues, position, (PersistableMapping)subMappings[k], pcCmd, pcMmd, val, storeMgr, clr);
                    continue;
                }
                val = ExpressionUtils.getValueForMemberOfObject(ec, pcMmd, fieldValue);
                pkMappings[position] = subMappings[k];
                pkFieldValues[position] = val;
                ++position;
            }
        }
        return position;
    }

    public static Object getValueForMemberOfObject(ExecutionContext ec, AbstractMemberMetaData mmd, Object object) {
        if (ec == null) {
            return ClassUtils.getValueOfFieldByReflection((Object)object, (String)mmd.getName());
        }
        DNStateManager sm = ec.findStateManager(object);
        if (!mmd.isPrimaryKey()) {
            sm.isLoaded(mmd.getAbsoluteFieldNumber());
        }
        SingleValueFieldManager fm = new SingleValueFieldManager();
        sm.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, (FieldManager)fm);
        return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
    }

    public static BooleanExpression getAppIdEqualityExpression(Object id, SQLExpression expr, RDBMSStoreManager storeMgr, ClassLoaderResolver clr, AbstractClassMetaData acmd, Integer index, BooleanExpression bExpr) {
        if (index == null) {
            index = 0;
        }
        String[] pkFieldNames = acmd.getPrimaryKeyMemberNames();
        for (int i = 0; i < pkFieldNames.length; ++i) {
            Object value = ClassUtils.getValueOfFieldByReflection((Object)id, (String)pkFieldNames[i]);
            String pcClassName = storeMgr.getClassNameForObjectID(value, clr, null);
            if (pcClassName != null) {
                AbstractClassMetaData scmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                if (bExpr == null) {
                    bExpr = ExpressionUtils.getAppIdEqualityExpression(value, expr, storeMgr, clr, scmd, index, null);
                    continue;
                }
                bExpr = bExpr.and(ExpressionUtils.getAppIdEqualityExpression(value, expr, storeMgr, clr, scmd, index, bExpr));
                continue;
            }
            ColumnExpression source = expr.subExprs.getExpression(index);
            JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithColumnMapping(value.getClass(), false, false, clr);
            SQLExpression target = expr.getSQLStatement().getSQLExpressionFactory().newLiteral(expr.getSQLStatement(), mapping, value);
            bExpr = bExpr == null ? ((SQLExpression)source).eq(target) : bExpr.and(((SQLExpression)source).eq(target));
            if (target.subExprs.size() == 0) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                continue;
            }
            index = index + target.subExprs.size();
        }
        return bExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BooleanExpression getEqualityExpressionForObjectExpressions(ObjectExpression expr1, ObjectExpression expr2, boolean equals) {
        SQLStatement stmt = expr1.stmt;
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        ApiAdapter api = storeMgr.getApiAdapter();
        if (expr1 instanceof ObjectLiteral && expr2 instanceof ObjectLiteral) {
            ObjectLiteral lit1 = (ObjectLiteral)expr1;
            ObjectLiteral lit2 = (ObjectLiteral)expr2;
            return new BooleanLiteral(stmt, expr1.mapping, equals ? lit1.getValue().equals(lit2.getValue()) : !lit1.getValue().equals(lit2.getValue()));
        }
        if (expr1 instanceof ObjectLiteral || expr2 instanceof ObjectLiteral) {
            Object value;
            BooleanExpression bExpr = null;
            boolean secondIsLiteral = expr2 instanceof ObjectLiteral;
            Object object = value = !secondIsLiteral ? ((ObjectLiteral)expr1).getValue() : ((ObjectLiteral)expr2).getValue();
            if (IdentityUtils.isDatastoreIdentity((Object)value)) {
                Object valueKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)value);
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(valueKey.getClass(), false);
                SQLExpression oidLit = exprFactory.newLiteral(stmt, m, valueKey);
                if (!equals) return secondIsLiteral ? expr1.subExprs.getExpression(0).ne(oidLit) : expr2.subExprs.getExpression(0).ne(oidLit);
                return secondIsLiteral ? expr1.subExprs.getExpression(0).eq(oidLit) : expr2.subExprs.getExpression(0).eq(oidLit);
            }
            if (IdentityUtils.isSingleFieldIdentity((Object)value)) {
                Object valueKey = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)value);
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(valueKey.getClass(), false);
                SQLExpression oidLit = exprFactory.newLiteral(stmt, m, valueKey);
                if (!equals) return secondIsLiteral ? expr1.subExprs.getExpression(0).ne(oidLit) : expr2.subExprs.getExpression(0).ne(oidLit);
                return secondIsLiteral ? expr1.subExprs.getExpression(0).eq(oidLit) : expr2.subExprs.getExpression(0).eq(oidLit);
            }
            AbstractClassMetaData cmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
            if (cmd != null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    if (api.getIdForObject(value) != null) {
                        int i;
                        ObjectExpression expr = secondIsLiteral ? expr1 : expr2;
                        JavaTypeMapping[] pkMappingsApp = new JavaTypeMapping[expr.subExprs.size()];
                        Object[] pkFieldValues = new Object[expr.subExprs.size()];
                        int position = 0;
                        ExecutionContext ec = api.getExecutionContext(value);
                        JavaTypeMapping thisMapping = expr.mapping;
                        if (expr.mapping instanceof ReferenceMapping) {
                            thisMapping = null;
                            ReferenceMapping refMapping = (ReferenceMapping)expr.mapping;
                            JavaTypeMapping[] implMappings = refMapping.getJavaTypeMapping();
                            for (int i2 = 0; i2 < implMappings.length; ++i2) {
                                Class implType = clr.classForName(implMappings[i2].getType());
                                if (!implType.isAssignableFrom(value.getClass())) continue;
                                thisMapping = implMappings[i2];
                                break;
                            }
                        }
                        if (thisMapping == null) {
                            return exprFactory.newLiteral(stmt, expr1.mapping, false).eq(exprFactory.newLiteral(stmt, expr1.mapping, true));
                        }
                        for (i = 0; i < cmd.getNoOfPrimaryKeyMembers(); ++i) {
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                            Object fieldValue = ExpressionUtils.getValueForMemberOfObject(ec, mmd, value);
                            JavaTypeMapping mapping = ((PersistableMapping)thisMapping).getJavaTypeMapping()[i];
                            if (mapping instanceof PersistableMapping) {
                                position = ExpressionUtils.populatePrimaryKeyMappingsValuesForPCMapping(pkMappingsApp, pkFieldValues, position, (PersistableMapping)mapping, cmd, mmd, fieldValue, storeMgr, clr);
                                continue;
                            }
                            pkMappingsApp[position] = mapping;
                            pkFieldValues[position] = fieldValue;
                            ++position;
                        }
                        i = 0;
                        while (i < expr.subExprs.size()) {
                            ColumnExpression source = expr.subExprs.getExpression(i);
                            SQLExpression target = exprFactory.newLiteral(stmt, pkMappingsApp[i], pkFieldValues[i]);
                            BooleanExpression subExpr = secondIsLiteral ? ((SQLExpression)source).eq(target) : target.eq(source);
                            bExpr = bExpr == null ? subExpr : bExpr.and(subExpr);
                            ++i;
                        }
                        return bExpr;
                    }
                    if (secondIsLiteral) {
                        int i = 0;
                        while (i < expr1.subExprs.size()) {
                            NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"037003", (Object[])new Object[]{value}));
                            bExpr = exprFactory.newLiteral(stmt, expr1.mapping, false).eq(exprFactory.newLiteral(stmt, expr1.mapping, true));
                            ++i;
                        }
                        return bExpr;
                    }
                    int i = 0;
                    while (i < expr2.subExprs.size()) {
                        NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"037003", (Object[])new Object[]{value}));
                        bExpr = exprFactory.newLiteral(stmt, expr2.mapping, false).eq(exprFactory.newLiteral(stmt, expr2.mapping, true));
                        ++i;
                    }
                    return bExpr;
                }
                if (cmd.getIdentityType() != IdentityType.DATASTORE) return null;
                ColumnExpression source = secondIsLiteral ? expr1.subExprs.getExpression(0) : expr2.subExprs.getExpression(0);
                JavaTypeMapping mapping = secondIsLiteral ? expr1.mapping : expr2.mapping;
                Object objectId = api.getIdForObject(value);
                if (objectId == null) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"037003", (Object[])new Object[]{value}));
                    return exprFactory.newLiteral(stmt, mapping, false).eq(exprFactory.newLiteral(stmt, mapping, true));
                }
                Object objectIdKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)objectId);
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(objectIdKey.getClass(), false);
                SQLExpression oidExpr = exprFactory.newLiteral(stmt, m, objectIdKey);
                if (!equals) return source.ne(oidExpr);
                return ((SQLExpression)source).eq(oidExpr);
            }
            String pcClassName = storeMgr.getClassNameForObjectID(value, clr, null);
            if (pcClassName == null) return exprFactory.newLiteral(stmt, expr1.mapping, false).eq(exprFactory.newLiteral(stmt, expr1.mapping, true));
            cmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
            return secondIsLiteral ? ExpressionUtils.getAppIdEqualityExpression(value, expr1, storeMgr, clr, cmd, null, null) : ExpressionUtils.getAppIdEqualityExpression(value, expr2, storeMgr, clr, cmd, null, null);
        }
        SQLExpression resultExpr = null;
        for (int i = 0; i < expr1.subExprs.size(); ++i) {
            ColumnExpression sourceExpr = expr1.subExprs.getExpression(i);
            ColumnExpression targetExpr = expr2.subExprs.getExpression(i);
            resultExpr = resultExpr == null ? ((SQLExpression)sourceExpr).eq(targetExpr) : ((BooleanExpression)resultExpr).and(((SQLExpression)sourceExpr).eq(targetExpr));
        }
        if (equals) return resultExpr;
        return new BooleanExpression(Expression.OP_NOT, resultExpr != null ? resultExpr.encloseInParentheses() : null);
    }

    public static void checkAndCorrectExpressionMappingsForBooleanComparison(SQLExpression expr1, SQLExpression expr2) {
        if (expr1.isParameter() && expr2.isParameter()) {
            if (expr1 instanceof SQLLiteral && ((SQLLiteral)((Object)expr2)).getValue() != null) {
                expr1.getSQLStatement().getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)expr2));
            } else if (expr2 instanceof SQLLiteral && ((SQLLiteral)((Object)expr2)).getValue() != null) {
                expr1.getSQLStatement().getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)expr2));
            }
        }
        if (expr1 instanceof SQLLiteral) {
            ExpressionUtils.checkAndCorrectLiteralForConsistentMappingsForBooleanComparison((SQLLiteral)((Object)expr1), expr2);
        } else if (expr2 instanceof SQLLiteral) {
            ExpressionUtils.checkAndCorrectLiteralForConsistentMappingsForBooleanComparison((SQLLiteral)((Object)expr2), expr1);
        }
    }

    protected static void checkAndCorrectLiteralForConsistentMappingsForBooleanComparison(SQLLiteral lit, SQLExpression expr) {
        JavaTypeMapping litMapping = ((SQLExpression)((Object)lit)).getJavaTypeMapping();
        JavaTypeMapping exprMapping = expr.getJavaTypeMapping();
        if (exprMapping == null || exprMapping.getNumberOfColumnMappings() == 0) {
            return;
        }
        if (litMapping instanceof PersistableMapping && exprMapping instanceof ReferenceMapping) {
            return;
        }
        if (litMapping instanceof SingleCollectionMapping) {
            return;
        }
        boolean needsUpdating = false;
        if (litMapping.getNumberOfColumnMappings() != exprMapping.getNumberOfColumnMappings()) {
            needsUpdating = true;
        } else {
            for (int i = 0; i < litMapping.getNumberOfColumnMappings(); ++i) {
                ColumnMapping colMapping = litMapping.getColumnMapping(i);
                if (colMapping != null && colMapping.getClass() == exprMapping.getColumnMapping(i).getClass()) continue;
                needsUpdating = true;
                break;
            }
        }
        if (needsUpdating) {
            Class litMappingCls = litMapping.getJavaType();
            Class mappingCls = exprMapping.getJavaType();
            if (!(litMappingCls != Double.class && litMappingCls != Float.class && litMappingCls != BigDecimal.class || mappingCls != Integer.class && mappingCls != Long.class && mappingCls != Short.class && mappingCls != BigInteger.class && mappingCls != Byte.class)) {
                if (litMappingCls == BigDecimal.class) {
                    expr.getSQLStatement().getQueryGenerator().useParameterExpressionAsLiteral(lit);
                }
                needsUpdating = false;
            }
            if (litMappingCls == Byte.class && mappingCls != Byte.class) {
                needsUpdating = false;
            }
        }
        if (needsUpdating) {
            NucleusLogger.QUERY.debug((Object)("Updating mapping of " + lit + " to be " + expr.getJavaTypeMapping()));
            ((SQLExpression)((Object)lit)).setJavaTypeMapping(expr.getJavaTypeMapping());
        }
    }
}

