/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.MapKeySetStore;
import org.datanucleus.store.rdbms.scostore.MapValueCollectionStore;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JoinMapStore<K, V>
extends AbstractMapStore<K, V> {
    protected MapTable mapTable;
    protected DatastoreClass valueTable;
    private String putStmt;
    private String updateStmt;
    private String removeStmt;
    private String clearStmt;
    private String maxAdapterColumnIdStmt;
    private volatile String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;
    private SetStore<K> keySetStore = null;
    private CollectionStore<V> valueSetStore = null;
    private SetStore entrySetStore = null;
    protected final JavaTypeMapping adapterMapping;

    public JoinMapStore(MapTable mapTable, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.setOwner(mapTable.getOwnerMemberMetaData());
        this.mapTable = mapTable;
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.adapterMapping = mapTable.getOrderMapping();
        this.keyType = mapTable.getKeyType();
        this.keysAreEmbedded = mapTable.isEmbeddedKey();
        this.keysAreSerialised = mapTable.isSerialisedKey();
        this.valueType = mapTable.getValueType();
        this.valuesAreEmbedded = mapTable.isEmbeddedValue();
        this.valuesAreSerialised = mapTable.isSerialisedValue();
        this.keyCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(clr.classForName(this.keyType), clr);
        Class valueClass = clr.classForName(this.valueType);
        if (ClassUtils.isReferenceType((Class)valueClass)) {
            NucleusLogger.PERSISTENCE.warn((Object)Localiser.msg((String)"056066", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), this.valueType}));
            this.valueCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(valueClass, null, clr);
            if (this.valueCmd != null) {
                this.valueTable = this.storeMgr.getDatastoreClass(this.valueCmd.getFullClassName(), clr);
            }
        } else {
            this.valueCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.valueCmd != null) {
                this.valueTable = this.valuesAreEmbedded ? null : this.storeMgr.getDatastoreClass(this.valueType, clr);
            }
        }
        this.initialise();
    }

    protected void initialise() {
        this.containsValueStmt = JoinMapStore.getContainsValueStmt(this.getOwnerMapping(), this.getValueMapping(), this.mapTable);
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    public void putAll(DNStateManager<?> sm, Map<? extends K, ? extends V> m, Map<K, V> currentMap) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.validateKeyForWriting(sm, e.getKey());
            this.validateValueForWriting(sm, e.getValue());
        }
        HashSet<Map.Entry> puts = new HashSet<Map.Entry>();
        HashSet<Map.Entry> updates = new HashSet<Map.Entry>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (currentMap.containsKey(key)) {
                if (currentMap.get(key) == value) continue;
                updates.add(entry);
                continue;
            }
            puts.add(entry);
        }
        this.processPutsAndUpdates(sm, puts, updates);
    }

    @Override
    public void putAll(DNStateManager sm, Map<? extends K, ? extends V> m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.validateKeyForWriting(sm, e.getKey());
            this.validateValueForWriting(sm, e.getValue());
        }
        HashMap currentMap = new HashMap();
        SetStore entrySet = this.entrySetStore();
        Iterator entrySetIter = entrySet.iterator(sm);
        while (entrySetIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entrySetIter.next();
            currentMap.put(entry.getKey(), entry.getValue());
        }
        HashSet<Map.Entry> puts = new HashSet<Map.Entry>();
        HashSet<Map.Entry> updates = new HashSet<Map.Entry>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            if (currentMap.containsKey(key)) {
                updates.add(entry);
                continue;
            }
            puts.add(entry);
        }
        this.processPutsAndUpdates(sm, puts, updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPutsAndUpdates(DNStateManager sm, Set<Map.Entry> puts, Set<Map.Entry> updates) {
        Map.Entry entry;
        Iterator<Map.Entry> iter;
        ManagedConnection mconn;
        boolean batched = this.allowsBatching();
        if (!puts.isEmpty()) {
            try {
                mconn = this.storeMgr.getConnectionManager().getConnection(sm.getExecutionContext());
                try {
                    iter = puts.iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        this.internalPut(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056016", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (!updates.isEmpty()) {
            try {
                mconn = this.storeMgr.getConnectionManager().getConnection(sm.getExecutionContext());
                try {
                    iter = updates.iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        this.internalUpdate(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException mde) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056016", (Object[])new Object[]{mde.getMessage()}), (Throwable)mde);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DNStateManager sm, K key, V value, V previousValue, boolean present) {
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        if (present && value == previousValue) {
            return;
        }
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                if (present) {
                    this.internalUpdate(sm, mconn, false, key, value, true);
                } else {
                    this.internalPut(sm, mconn, false, key, value, true);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056016", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && previousValue != null && !this.containsValue(sm, previousValue)) {
            sm.getExecutionContext().deleteObjectInternal(previousValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(DNStateManager sm, K key, V value) {
        MapMetaData mapmd;
        V oldValue;
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        boolean exists = false;
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        if (oldValue != value) {
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                try {
                    if (exists) {
                        this.internalUpdate(sm, mconn, false, key, value, true);
                    } else {
                        this.internalPut(sm, mconn, false, key, value, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056016", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if ((mapmd = this.ownerMemberMetaData.getMap()).isDependentValue() && !mapmd.isEmbeddedValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public V remove(DNStateManager sm, Object key) {
        boolean exists;
        V oldValue;
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        ExecutionContext ec = sm.getExecutionContext();
        if (exists) {
            this.removeInternal(sm, key);
        }
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        ApiAdapter api = ec.getApiAdapter();
        if (mapmd.isDependentKey() && !mapmd.isEmbeddedKey() && api.isPersistable(key)) {
            ec.deleteObjectInternal(key);
        }
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && api.isPersistable(oldValue) && !this.containsValue(sm, oldValue)) {
            ec.deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public void remove(DNStateManager sm, Object key, Object oldValue) {
        if (!this.validateKeyForReading(sm, key)) {
            return;
        }
        this.removeInternal(sm, key);
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        ExecutionContext ec = sm.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        if (mapmd.isDependentKey() && !mapmd.isEmbeddedKey() && api.isPersistable(key)) {
            ec.deleteObjectInternal(key);
        }
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && api.isPersistable(oldValue) && !this.containsValue(sm, oldValue)) {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public void clear(DNStateManager ownerSM) {
        HashSet<Object> dependentElements = null;
        if (this.ownerMemberMetaData.getMap().isDependentKey() || this.ownerMemberMetaData.getMap().isDependentValue()) {
            dependentElements = new HashSet<Object>();
            ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
            Iterator iter = this.entrySetStore().iterator(ownerSM);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                MapMetaData mapmd = this.ownerMemberMetaData.getMap();
                if (api.isPersistable(entry.getKey()) && mapmd.isDependentKey() && !mapmd.isEmbeddedKey()) {
                    dependentElements.add(entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || !mapmd.isDependentValue() || mapmd.isEmbeddedValue()) continue;
                dependentElements.add(entry.getValue());
            }
        }
        this.clearInternal(ownerSM);
        if (dependentElements != null && !dependentElements.isEmpty()) {
            ownerSM.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    public synchronized SetStore keySetStore() {
        if (this.keySetStore == null) {
            this.keySetStore = new MapKeySetStore(this.mapTable, this, this.clr);
        }
        return this.keySetStore;
    }

    public synchronized CollectionStore valueCollectionStore() {
        if (this.valueSetStore == null) {
            this.valueSetStore = new MapValueCollectionStore(this.mapTable, this, this.clr);
        }
        return this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        if (this.entrySetStore == null) {
            this.entrySetStore = new MapEntrySetStore(this.mapTable, this, this.clr);
        }
        return this.entrySetStore;
    }

    public JavaTypeMapping getAdapterMapping() {
        return this.adapterMapping;
    }

    private String getPutStmt() {
        int i;
        StringBuilder stmt = new StringBuilder("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfColumnMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.ownerMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfColumnMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.adapterMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfColumnMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.keyMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getColumnMapping(i).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfColumnMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.ownerMapping.getColumnMapping(i).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfColumnMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.adapterMapping.getColumnMapping(i).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfColumnMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.keyMapping.getColumnMapping(i).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < this.valueMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(this.valueMapping.getColumnMapping(i).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, false);
        return stmt.toString();
    }

    private String getRemoveStmt() {
        StringBuilder stmt = new StringBuilder("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, false);
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuilder stmt = new StringBuilder("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V getValue(DNStateManager ownerSM, Object key) throws NoSuchElementException {
        Boolean serializeRead;
        if (!this.validateKeyForReading(ownerSM, key)) {
            return null;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (this.getStmtLocked == null) {
            JoinMapStore joinMapStore = this;
            synchronized (joinMapStore) {
                if (this.getStmtLocked == null) {
                    SelectStatement sqlStmt = this.getSQLStatementForGet(ownerSM);
                    this.getStmtUnlocked = ((SQLStatement)sqlStmt).getSQLText().toSQL();
                    sqlStmt.addExtension("lock-for-update", true);
                    this.getStmtLocked = ((SQLStatement)sqlStmt).getSQLText().toSQL();
                }
            }
        }
        String stmt = (serializeRead = ec.getTransaction().getSerializeRead()) != null && serializeRead != false ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(ec, ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerSM.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(ec, ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                    boolean found = rs.next();
                    if (!found) {
                        throw new NoSuchElementException();
                    }
                    if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                        int[] param = new int[this.valueMapping.getNumberOfColumnMappings()];
                        for (int i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                            int ownerFieldNumber = this.mapTable.getOwnerMemberMetaData().getAbsoluteFieldNumber();
                            value = this.valueMapping.getObject(ec, rs, param, ownerSM, ownerFieldNumber);
                        } else {
                            value = this.valueMapping.getObject(ec, rs, param);
                        }
                    } else if (this.valueMapping instanceof ReferenceMapping) {
                        int[] param = new int[this.valueMapping.getNumberOfColumnMappings()];
                        for (int i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        value = this.valueMapping.getObject(ec, rs, param);
                    } else {
                        PersistentClassROF rof = new PersistentClassROF(ec, rs, false, ec.getFetchPlan(), this.getMappingDef, this.valueCmd, this.clr.classForName(this.valueType));
                        value = rof.getObject();
                    }
                    JDBCUtils.logWarnings(rs);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056014", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return (V)value;
    }

    protected SelectStatement getSQLStatementForGet(DNStateManager ownerSM) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SelectStatement sqlStmt = null;
        ExecutionContext ec = ownerSM.getExecutionContext();
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            sqlStmt = new SelectStatement(this.storeMgr, this.mapTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
        } else {
            Collection valueSubclassNames;
            this.getMappingDef = new StatementClassMapping();
            if (!this.valueCmd.getFullClassName().equals(valueCls.getName())) {
                valueCls = clr.classForName(this.valueCmd.getFullClassName());
            }
            UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null, this.mapTable, null, this.valueMapping);
            stmtGen.setOption("selectDnType");
            this.getMappingDef.setNucleusTypeColumnName("DN_TYPE");
            sqlStmt = stmtGen.getStatement(ec);
            SQLTable valueSqlTbl = sqlStmt.getTable(this.valueTable, sqlStmt.getPrimaryTable().getGroupName());
            if (valueSqlTbl == null && (valueSubclassNames = this.storeMgr.getSubClassesForClass(this.valueType, true, clr)) != null && !valueSubclassNames.isEmpty()) {
                String valueSubclassName;
                DatastoreClass valueTbl;
                Iterator iterator = valueSubclassNames.iterator();
                while (iterator.hasNext() && ((valueTbl = this.storeMgr.getDatastoreClass(valueSubclassName = (String)iterator.next(), clr)) == null || (valueSqlTbl = sqlStmt.getTable(valueTbl, sqlStmt.getPrimaryTable().getGroupName())) == null)) {
                }
            }
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ec.getFetchPlan(), valueSqlTbl, this.valueCmd, ec.getFetchPlan().getMaxFetchDepth());
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        int numberOfUnions = sqlStmt.getNumberOfUnions();
        for (int j = 0; j < numberOfUnions + 1; ++j) {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfColumnMappings()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfColumnMappings()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(DNStateManager ownerSM) {
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    sqlControl.executeStatementUpdate(ec, mconn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{this.clearStmt}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInternal(DNStateManager sm, Object key) {
        ExecutionContext ec = sm.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.removeStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.removeStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{this.removeStmt}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(DNStateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, batched);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, this.mapTable, this);
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                sqlControl.executeStatementUpdate(ec, conn, this.updateStmt, ps, executeNow);
            }
            finally {
                sqlControl.closeStatement(conn, ps);
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(this.getUpdateStmt(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(DNStateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        int nextIdForAdapterColumn = -1;
        if (this.adapterMapping != null) {
            nextIdForAdapterColumn = this.getNextIDForAdapterColumn(ownerSM);
        }
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, this.mapTable, this);
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
            if (this.adapterMapping != null) {
                this.adapterMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.adapterMapping), nextIdForAdapterColumn);
                jdbcPosition += this.adapterMapping.getNumberOfColumnMappings();
            }
            jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
            nArray = sqlControl.executeStatementUpdate(ec, conn, this.putStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException(this.getPutStmt(), e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(DNStateManager sm) {
        int nextID;
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                        nextID = !rs.next() ? (nextID = 1) : rs.getInt(1) + 1;
                        JDBCUtils.logWarnings(rs);
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056020", (Object[])new Object[]{this.getMaxAdapterColumnIdStmt()}), (Throwable)e);
        }
        return nextID;
    }

    private String getMaxAdapterColumnIdStmt() {
        if (this.maxAdapterColumnIdStmt == null) {
            StringBuilder stmt = new StringBuilder("SELECT MAX(" + this.adapterMapping.getColumnMapping(0).getColumn().getIdentifier().toString() + ")");
            stmt.append(" FROM ");
            stmt.append(this.mapTable.toString());
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            this.maxAdapterColumnIdStmt = stmt.toString();
        }
        return this.maxAdapterColumnIdStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedKey(DNStateManager sm, Object key, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.keyMapping != null && this.keyMapping instanceof EmbeddedKeyPCMapping) {
            String fieldName = this.valueCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedKeyPCMapping)this.keyMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedKeyStmt(fieldMapping, this.getOwnerMapping(), this.getKeyMapping(), this.mapTable);
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, fieldMapping), key);
                        jdbcPosition += fieldMapping.getNumberOfColumnMappings();
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateEmbeddedKeyFieldsInStatement(sm, key, ps, jdbcPosition, this.mapTable, this);
                        sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = Localiser.msg((String)"056010", (Object[])new Object[]{stmt});
                NucleusLogger.DATASTORE_PERSIST.warn((Object)msg, (Throwable)e);
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedValue(DNStateManager sm, Object value, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.valueMapping != null && this.valueMapping instanceof EmbeddedValuePCMapping) {
            String fieldName = this.valueCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedValuePCMapping)this.valueMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedValueStmt(fieldMapping, this.getOwnerMapping(), this.getValueMapping(), this.mapTable);
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, fieldMapping), newValue);
                        jdbcPosition += fieldMapping.getNumberOfColumnMappings();
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateEmbeddedValueFieldsInStatement(sm, value, ps, jdbcPosition, this.mapTable, this);
                        sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = Localiser.msg((String)"056011", (Object[])new Object[]{stmt});
                NucleusLogger.DATASTORE_PERSIST.warn((Object)msg, (Throwable)e);
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return modified;
    }

    protected String getUpdateEmbeddedKeyStmt(JavaTypeMapping fieldMapping, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, Table mapTable) {
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(mapTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < fieldMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(fieldMapping.getColumnMapping(i).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, null, true);
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)keyMapping;
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfColumnMappings(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getColumnMapping(j).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(m.getColumnMapping(j).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getUpdateEmbeddedValueStmt(JavaTypeMapping fieldMapping, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, Table mapTable) {
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(mapTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < fieldMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(fieldMapping.getColumnMapping(i).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, null, true);
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)valueMapping;
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfColumnMappings(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getColumnMapping(j).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(m.getColumnMapping(j).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }
}

