/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.scostore.ArrayStore;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        if (this.mmd != null) {
            return this.mmd.getType();
        }
        return null;
    }

    @Override
    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.mmd != null && this.mmd.hasArray() && this.mmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
    }

    @Override
    public void postInsert(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        Object value = ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        if (this.containerIsStoredInSingleColumn()) {
            if (this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    DNStateManager elemOP;
                    if (elem == null || (elemOP = ec.findStateManager(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, elem, false, ownerSM, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        int arrayLength = Array.getLength(value);
        boolean persistentElements = this.mmd.getRelationType(ec.getClassLoaderResolver()) != RelationType.NONE;
        boolean needsAttaching = false;
        if (persistentElements) {
            int i;
            Object[] array = (Object[])value;
            if (!this.mmd.isCascadePersist()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
                }
                for (i = 0; i < arrayLength; ++i) {
                    if (ec.getApiAdapter().isDetached(array[i]) || ec.getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), array[i]);
                }
            } else if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
            for (i = 0; i < arrayLength; ++i) {
                if (!ownerSM.getExecutionContext().getApiAdapter().isDetached(array[i])) continue;
                needsAttaching = true;
                break;
            }
        }
        if (needsAttaching) {
            SCO collWrapper = this.replaceFieldWithWrapper(ownerSM, null);
            if (arrayLength > 0) {
                collWrapper.attachCopy(value);
                ownerSM.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)collWrapper).getBackingStore(), ownerSM);
            }
        } else if (arrayLength > 0) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ownerSM.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).set(ownerSM, value);
        }
    }

    @Override
    public void postFetch(DNStateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.mmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.mmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), null);
            } else {
                sm.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), array);
            }
        } else {
            sm.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), null);
        }
    }

    @Override
    public void postUpdate(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        Object value = ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    DNStateManager elemOP;
                    if (elem == null || (elemOP = ec.findStateManager(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, elem, false, ownerSM, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        if (value == null) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerSM);
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(ownerSM);
        backingStore.set(ownerSM, value);
    }

    @Override
    public void preDelete(DNStateManager ownerSM) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerSM.isLoaded(this.getAbsoluteFieldNumber());
        Object value = ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(ownerSM.getExecutionContext().getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(ownerSM);
    }
}

