/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.DeleteRequest;
import org.datanucleus.store.rdbms.request.FetchRequest;
import org.datanucleus.store.rdbms.request.InsertRequest;
import org.datanucleus.store.rdbms.request.LocateBulkRequest;
import org.datanucleus.store.rdbms.request.LocateRequest;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.request.UpdateRequest;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.SecondaryDatastoreClass;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RDBMSPersistenceHandler
extends AbstractPersistenceHandler {
    private Map<RequestIdentifier, Request> requestsByID = new ConcurrentReferenceHashMap(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    private DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        return ((RDBMSStoreManager)this.storeMgr).getDatastoreClass(className, clr);
    }

    public void insertObjects(DNStateManager ... sms) {
        super.insertObjects(sms);
    }

    public void insertObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, sm.getLoadedFieldNumbers());
        ExecutionContext ec = sm.getExecutionContext();
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        String className = sm.getClassMetaData().getFullClassName();
        DatastoreClass dc = this.getDatastoreClass(className, clr);
        if (dc == null) {
            if (sm.getClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(Localiser.msg((String)"032013", (Object[])new Object[]{className}));
            }
            throw new NucleusException(Localiser.msg((String)"032014", (Object[])new Object[]{className, sm.getClassMetaData().getInheritanceMetaData().getStrategy()})).setFatal();
        }
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementInsertCount();
        }
        this.insertObjectInTable(dc, sm, clr);
    }

    private void insertObjectInTable(DatastoreClass table, DNStateManager sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform InsertRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertObjectInTable(supertable, sm, clr);
        }
        this.getInsertRequest(table, sm.getClassMetaData(), clr).execute(sm);
        Collection<SecondaryDatastoreClass> secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryDatastoreClass secTable : secondaryTables) {
                this.insertObjectInTable(secTable, sm, clr);
            }
        }
    }

    private Request getInsertRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.INSERT, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new InsertRequest(table, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(DNStateManager sm, int[] memberNumbers) {
        ExecutionContext ec = sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] mmds = null;
        if (memberNumbers != null && memberNumbers.length > 0) {
            int[] memberNumbersToProcess = memberNumbers;
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (this.storeMgr.getBooleanProperty("datanucleus.rdbms.fetchUnloadedAutomatically") && !sm.getLifecycleState().isDeleted()) {
                boolean fetchPerformsSelect = false;
                for (int i = 0; i < memberNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbers[i]);
                    RelationType relationType = mmd.getRelationType(clr);
                    if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI || relationType == RelationType.MANY_TO_MANY_BI) continue;
                    fetchPerformsSelect = true;
                    break;
                }
                if (fetchPerformsSelect) {
                    int i;
                    ArrayList<Integer> memberNumberList = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < memberNumbers.length; ++i2) {
                        memberNumberList.add(memberNumbers[i2]);
                    }
                    boolean[] loadedFlags = sm.getLoadedFields();
                    for (i = 0; i < loadedFlags.length; ++i) {
                        AbstractMemberMetaData mmd;
                        RelationType relType;
                        boolean requested = false;
                        for (int j = 0; j < memberNumbers.length; ++j) {
                            if (memberNumbers[j] != i) continue;
                            requested = true;
                            break;
                        }
                        if (requested || loadedFlags[i] || (relType = (mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i)).getRelationType(clr)) != RelationType.NONE && relType != RelationType.ONE_TO_ONE_BI && relType != RelationType.ONE_TO_ONE_UNI) continue;
                        memberNumberList.add(i);
                    }
                    memberNumbersToProcess = new int[memberNumberList.size()];
                    i = 0;
                    Iterator fieldNumberIter = memberNumberList.iterator();
                    while (fieldNumberIter.hasNext()) {
                        memberNumbersToProcess[i++] = (Integer)fieldNumberIter.next();
                    }
                }
            }
            mmds = new AbstractMemberMetaData[memberNumbersToProcess.length];
            for (int i = 0; i < mmds.length; ++i) {
                mmds[i] = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbersToProcess[i]);
            }
        }
        if (sm.isEmbedded()) {
            StringBuilder str = new StringBuilder();
            if (mmds != null) {
                for (int i = 0; i < mmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(mmds[i].getName());
                }
            }
            NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + sm.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
        } else {
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
            DatastoreClass table = this.getDatastoreClass(sm.getClassMetaData().getFullClassName(), clr);
            Request req = this.getFetchRequest(table, mmds, sm.getClassMetaData(), clr);
            req.execute(sm);
        }
    }

    private Request getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.FETCH, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new FetchRequest(table, mmds, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, fieldNumbers);
        AbstractMemberMetaData[] mmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            ExecutionContext ec = sm.getExecutionContext();
            mmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < mmds.length; ++i) {
                mmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementUpdateCount();
            }
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            DatastoreClass dc = this.getDatastoreClass(sm.getObject().getClass().getName(), clr);
            this.updateObjectInTable(dc, sm, clr, mmds);
        }
    }

    private void updateObjectInTable(DatastoreClass table, DNStateManager sm, ClassLoaderResolver clr, AbstractMemberMetaData[] mmds) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform UpdateRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateObjectInTable(supertable, sm, clr, mmds);
        }
        this.getUpdateRequest(table, mmds, sm.getClassMetaData(), clr).execute(sm);
        Collection<SecondaryDatastoreClass> secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryDatastoreClass secTable : secondaryTables) {
                this.updateObjectInTable(secTable, sm, clr, mmds);
            }
        }
    }

    private Request getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.UPDATE, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new UpdateRequest(table, mmds, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementDeleteCount();
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        DatastoreClass dc = this.getDatastoreClass(sm.getClassMetaData().getFullClassName(), clr);
        this.deleteObjectFromTable(dc, sm, clr);
    }

    private void deleteObjectFromTable(DatastoreClass table, DNStateManager sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform DeleteRequest on RDBMS view " + table);
        }
        Collection<SecondaryDatastoreClass> secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryDatastoreClass secTable : secondaryTables) {
                this.deleteObjectFromTable(secTable, sm, clr);
            }
        }
        this.getDeleteRequest(table, sm.getClassMetaData(), clr).execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteObjectFromTable(supertable, sm, clr);
        }
    }

    private Request getDeleteRequest(DatastoreClass table, AbstractClassMetaData acmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.DELETE, acmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new DeleteRequest(table, acmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObjects(DNStateManager[] sms) {
        DatastoreClass table;
        if (sms == null || sms.length == 0) {
            return;
        }
        ClassLoaderResolver clr = sms[0].getExecutionContext().getClassLoaderResolver();
        HashMap<DatastoreClass, ArrayList<DNStateManager>> smsByTable = new HashMap<DatastoreClass, ArrayList<DNStateManager>>();
        for (int i = 0; i < sms.length; ++i) {
            AbstractClassMetaData cmd = sms[i].getClassMetaData();
            table = this.getDatastoreClass(cmd.getFullClassName(), clr);
            ArrayList<DNStateManager> smList = (ArrayList<DNStateManager>)smsByTable.get(table = table.getBaseDatastoreClass());
            if (smList == null) {
                smList = new ArrayList<DNStateManager>();
            }
            smList.add(sms[i]);
            smsByTable.put(table, smList);
        }
        for (Map.Entry entry : smsByTable.entrySet()) {
            table = (DatastoreClass)entry.getKey();
            List tableSMs = (List)entry.getValue();
            LocateBulkRequest req = new LocateBulkRequest(table);
            req.execute(tableSMs.toArray(new DNStateManager[tableSMs.size()]));
        }
    }

    public void locateObject(DNStateManager sm) {
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        DatastoreClass table = this.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        this.getLocateRequest(table, sm.getObject().getClass().getName()).execute(sm);
    }

    private Request getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.LOCATE, className);
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new LocateRequest(table);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            HashSet<RequestIdentifier> keySet = new HashSet<RequestIdentifier>(this.requestsByID.keySet());
            for (RequestIdentifier reqId : keySet) {
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }

    private void checkForSchemaUpdatesForFieldsOfObject(DNStateManager sm, int[] fieldNumbers) {
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSStoreManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.requestsByID.clear();
            }
        }
    }
}

