/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.ClassDefinitionException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.MapKeySetStore;
import org.datanucleus.store.rdbms.scostore.MapValueCollectionStore;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FKMapStore<K, V>
extends AbstractMapStore<K, V> {
    protected DatastoreClass mapTable;
    private String updateFkStmt;
    private String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;
    private final int ownerFieldNumber;
    protected int keyFieldNumber = -1;
    private int valueFieldNumber = -1;

    public FKMapStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        MapMetaData mapmd = (MapMetaData)mmd.getContainer();
        if (mapmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056002", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        boolean keyStoredInValue = false;
        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() == null) {
            throw new NucleusUserException(Localiser.msg((String)"056071", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        this.keyType = mapmd.getKeyType();
        this.valueType = mapmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = this.getStoreManager().getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new NucleusUserException(Localiser.msg((String)"056072", (Object[])new Object[]{mmd.getFullFieldName(), this.valueType}));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new NucleusUserException(Localiser.msg((String)"056073", (Object[])new Object[]{mmd.getFullFieldName(), this.keyType}));
        }
        String ownerFieldName = mmd.getMappedBy();
        if (keyStoredInValue) {
            this.valueCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.valueCmd == null) {
                throw new NucleusUserException(Localiser.msg((String)"056070", (Object[])new Object[]{this.valueType, mmd.getFullFieldName()}));
            }
            DatastoreClass joiningTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIdMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (mmd.getMappedBy() != null) {
                AbstractMemberMetaData vofmd = this.valueCmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056067", (Object[])new Object[]{mmd.getFullFieldName(), ownerFieldName, valueClass.getName()}));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new NucleusUserException(Localiser.msg((String)"056068", (Object[])new Object[]{mmd.getFullFieldName(), vofmd.getFullFieldName(), vofmd.getTypeName(), mmd.getAbstractClassMetaData().getFullClassName()}));
                }
                this.ownerFieldNumber = this.valueCmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = joiningTable.getMemberMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.valueType, ownerFieldName}));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(Localiser.msg((String)"056055", (Object[])new Object[]{ownerFieldName, this.valueType, vofmd.getTypeName(), mmd.getClassName()}));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = joiningTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056056", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.valueType}));
                }
            }
            if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) {
                throw new NucleusUserException(Localiser.msg((String)"056050", (Object[])new Object[]{valueClass.getName()}));
            }
            AbstractMemberMetaData vkfmd = null;
            String key_field_name = mmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null) {
                AbstractClassMetaData vkCmd = storeMgr.getMetaDataManager().getMetaDataForClass(valueClass, clr);
                AbstractMemberMetaData abstractMemberMetaData = vkfmd = vkCmd != null ? vkCmd.getMetaDataForMember(key_field_name) : null;
                if (vkfmd == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056052", (Object[])new Object[]{valueClass.getName(), key_field_name}));
                }
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(Localiser.msg((String)"056050", (Object[])new Object[]{mmd.getFullFieldName()}));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.keyType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(Localiser.msg((String)"056051", (Object[])new Object[]{mmd.getFullFieldName(), this.keyType, vkfmd.getType().getName()}));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.valueCmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = joiningTable.getMemberMapping(this.valueCmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new NucleusUserException(Localiser.msg((String)"056053", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.valueType, keyFieldName}));
            }
            if (!this.keyMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map key field: " + mmd.getFullFieldName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = joiningTable;
            if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.mapTable) {
                this.mapTable = (DatastoreClass)this.ownerMapping.getTable();
            }
        } else {
            this.keyCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.keyCmd == null) {
                throw new NucleusUserException(Localiser.msg((String)"056069", (Object[])new Object[]{this.keyType, mmd.getFullFieldName()}));
            }
            DatastoreClass joiningTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIdMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (mmd.getMappedBy() != null) {
                AbstractMemberMetaData kofmd = this.keyCmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056067", (Object[])new Object[]{mmd.getFullFieldName(), ownerFieldName, keyClass.getName()}));
                }
                if (!ClassUtils.typesAreCompatible((Class)kofmd.getType(), (String)mmd.getAbstractClassMetaData().getFullClassName(), (ClassLoaderResolver)clr)) {
                    throw new NucleusUserException(Localiser.msg((String)"056068", (Object[])new Object[]{mmd.getFullFieldName(), kofmd.getFullFieldName(), kofmd.getTypeName(), mmd.getAbstractClassMetaData().getFullClassName()}));
                }
                this.ownerFieldNumber = this.keyCmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = joiningTable.getMemberMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.keyType, ownerFieldName}));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(Localiser.msg((String)"056055", (Object[])new Object[]{ownerFieldName, this.keyType, kofmd.getTypeName(), mmd.getClassName()}));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = joiningTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056056", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.keyType}));
                }
            }
            if (mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) {
                throw new NucleusUserException(Localiser.msg((String)"056057", (Object[])new Object[]{keyClass.getName()}));
            }
            AbstractMemberMetaData vkfmd = null;
            String value_field_name = mmd.getValueMetaData().getMappedBy();
            if (value_field_name != null) {
                AbstractClassMetaData vkCmd = storeMgr.getMetaDataManager().getMetaDataForClass(keyClass, clr);
                AbstractMemberMetaData abstractMemberMetaData = vkfmd = vkCmd != null ? vkCmd.getMetaDataForMember(value_field_name) : null;
                if (vkfmd == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056059", (Object[])new Object[]{keyClass.getName(), value_field_name}));
                }
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(Localiser.msg((String)"056057", (Object[])new Object[]{mmd.getFullFieldName()}));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.valueType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(Localiser.msg((String)"056058", (Object[])new Object[]{mmd.getFullFieldName(), this.valueType, vkfmd.getType().getName()}));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.keyCmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = joiningTable.getMemberMapping(this.keyCmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new NucleusUserException(Localiser.msg((String)"056054", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.keyType, valueFieldName}));
            }
            if (!this.valueMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map value field: " + mmd.getFullFieldName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = joiningTable;
            if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.mapTable) {
                this.mapTable = (DatastoreClass)this.ownerMapping.getTable();
            }
        }
        this.initialise();
    }

    protected void initialise() {
        this.containsValueStmt = FKMapStore.getContainsValueStmt(this.getOwnerMapping(), this.getValueMapping(), this.mapTable);
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private boolean updateValueFk(ObjectProvider op, Object value, Object owner) {
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(op, value);
        return this.updateValueFkInternal(op, value, owner);
    }

    private boolean updateKeyFk(ObjectProvider op, Object key, Object owner) {
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(op, key);
        return this.updateKeyFkInternal(op, key, owner);
    }

    @Override
    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(Localiser.msg((String)"056063"));
        }
        super.validateValueType(clr, value);
    }

    public V put(final ObjectProvider op, final K newKey, V newValue) {
        ExecutionContext ec = op.getExecutionContext();
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(op, newKey);
            this.validateValueType(ec.getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(ec.getClassLoaderResolver(), newKey);
            this.validateValueForWriting(op, newValue);
        }
        Object oldValue = this.get(op, newKey);
        if (oldValue != newValue) {
            if (this.valueCmd != null) {
                if (oldValue != null && !oldValue.equals(newValue)) {
                    this.removeValue(op, newKey, oldValue);
                }
                final Object newOwner = op.getObject();
                if (ec.getApiAdapter().isPersistent(newValue)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newValue)) {
                        throw new NucleusUserException(Localiser.msg((String)"RDBMS.SCO.Map.WriteValueInvalidWithDifferentPM"), ec.getApiAdapter().getIdForObject(newValue));
                    }
                    ObjectProvider vsm = ec.findObjectProvider(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        vsm.isLoaded(this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateValueFk(op, newValue, newOwner);
                    }
                    vsm.isLoaded(this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.replaceFieldMakeDirty(this.keyFieldNumber, newKey);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, oldKey, newKey);
                    }
                } else {
                    ec.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(FKMapStore.this.keyFieldNumber, newKey);
                            JavaTypeMapping externalFKMapping = FKMapStore.this.mapTable.getExternalMapping(FKMapStore.this.ownerMemberMetaData, MappingType.EXTERNAL_FK);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue((Object)externalFKMapping, op.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider op2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            } else {
                final Object newOwner = op.getObject();
                if (ec.getApiAdapter().isPersistent(newKey)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newKey)) {
                        throw new NucleusUserException(Localiser.msg((String)"056060"), ec.getApiAdapter().getIdForObject(newKey));
                    }
                    ObjectProvider valOP = ec.findObjectProvider(newKey);
                    if (this.ownerFieldNumber >= 0) {
                        valOP.isLoaded(this.ownerFieldNumber);
                        Object oldOwner = valOP.provideField(this.ownerFieldNumber);
                        valOP.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(valOP).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateKeyFk(op, newKey, newOwner);
                    }
                    valOP.isLoaded(this.valueFieldNumber);
                    oldValue = valOP.provideField(this.valueFieldNumber);
                    valOP.replaceFieldMakeDirty(this.valueFieldNumber, newValue);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(valOP).relationChange(this.valueFieldNumber, oldValue, newValue);
                    }
                } else {
                    final V newValueObj = newValue;
                    ec.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(FKMapStore.this.valueFieldNumber, newValueObj);
                            JavaTypeMapping externalFKMapping = FKMapStore.this.mapTable.getExternalMapping(FKMapStore.this.ownerMemberMetaData, MappingType.EXTERNAL_FK);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue((Object)externalFKMapping, op.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider op2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(op, oldValue)) {
            ec.deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public V remove(ObjectProvider op, Object key) {
        if (!this.allowNulls && key == null) {
            return null;
        }
        Object oldValue = this.get(op, key);
        this.remove(op, key, oldValue);
        return oldValue;
    }

    public void remove(ObjectProvider op, Object key, Object oldValue) {
        ExecutionContext ec = op.getExecutionContext();
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                boolean deletingValue = false;
                ObjectProvider valueOP = ec.findObjectProvider(oldValue);
                if (this.ownerMemberMetaData.getMap().isDependentValue()) {
                    deletingValue = true;
                    ec.deleteObjectInternal(oldValue);
                    valueOP.flush();
                } else if (this.ownerMapping.isNullable()) {
                    if (this.ownerFieldNumber >= 0) {
                        Object oldOwner = valueOP.provideField(this.ownerFieldNumber);
                        valueOP.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                        valueOP.flush();
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(valueOP).relationChange(this.ownerFieldNumber, oldOwner, null);
                        }
                    } else {
                        this.updateValueFkInternal(op, oldValue, null);
                    }
                } else {
                    deletingValue = true;
                    ec.deleteObjectInternal(oldValue);
                    valueOP.flush();
                }
                if (this.ownerMemberMetaData.getMap().isDependentKey()) {
                    if (!deletingValue && this.keyMapping.isNullable()) {
                        valueOP.replaceFieldMakeDirty(this.keyFieldNumber, null);
                        valueOP.flush();
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(valueOP).relationChange(this.keyFieldNumber, key, null);
                        }
                    }
                    ec.deleteObjectInternal(key);
                    ObjectProvider keyOP = ec.findObjectProvider(key);
                    keyOP.flush();
                }
            }
        } else if (key != null) {
            boolean deletingKey = false;
            ObjectProvider keyOP = ec.findObjectProvider(key);
            if (this.ownerMemberMetaData.getMap().isDependentKey()) {
                deletingKey = true;
                ec.deleteObjectInternal(key);
                keyOP.flush();
            } else if (this.ownerMapping.isNullable()) {
                if (this.ownerFieldNumber >= 0) {
                    Object oldOwner = keyOP.provideField(this.ownerFieldNumber);
                    keyOP.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                    keyOP.flush();
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(keyOP).relationChange(this.ownerFieldNumber, oldOwner, null);
                    }
                } else {
                    this.updateKeyFkInternal(op, key, null);
                }
            } else {
                deletingKey = true;
                ec.deleteObjectInternal(key);
                keyOP.flush();
            }
            if (this.ownerMemberMetaData.getMap().isDependentValue()) {
                if (!deletingKey && this.valueMapping.isNullable()) {
                    keyOP.replaceFieldMakeDirty(this.valueFieldNumber, null);
                    keyOP.flush();
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(keyOP).relationChange(this.valueFieldNumber, oldValue, null);
                    }
                }
                ec.deleteObjectInternal(oldValue);
                ObjectProvider valOP = ec.findObjectProvider(oldValue);
                valOP.flush();
            }
        }
    }

    private void removeValue(ObjectProvider op, Object key, Object oldValue) {
        ExecutionContext ec = op.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
            if (ec.getManageRelations()) {
                ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
            }
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, null);
                }
            } else {
                this.updateValueFk(op, oldValue, null);
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public void clear(ObjectProvider op) {
        Iterator iter = this.keySetStore().iterator(op);
        while (iter.hasNext()) {
            Object key = iter.next();
            if (key == null && !this.allowNulls) continue;
            this.remove(op, key);
        }
    }

    public void clearKeyOfValue(ObjectProvider op, Object key, Object oldValue) {
        ExecutionContext ec = op.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            if (!ec.getApiAdapter().isDeleted(oldValue)) {
                vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
                }
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore() {
        return new MapKeySetStore(this.mapTable, this, this.clr);
    }

    public synchronized CollectionStore valueCollectionStore() {
        return new MapValueCollectionStore(this.mapTable, this, this.clr);
    }

    public synchronized SetStore entrySetStore() {
        return new MapEntrySetStore(this.mapTable, this, this.clr);
    }

    private String getUpdateFkStmt() {
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < this.ownerMapping.getNumberOfColumnMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(this.ownerMapping.getColumnMapping(i).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.valueMapping, null, true);
        } else {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, true);
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateValueFkInternal(ObjectProvider op, Object value, Object owner) {
        boolean retval;
        ExecutionContext ec = op.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, this.ownerMapping), null, op, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfColumnMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056027", (Object[])new Object[]{this.updateFkStmt}), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateKeyFkInternal(ObjectProvider op, Object key, Object owner) {
        boolean retval;
        ExecutionContext ec = op.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, this.ownerMapping), null, op, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfColumnMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056027", (Object[])new Object[]{this.updateFkStmt}), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V getValue(ObjectProvider ownerOP, Object key) throws NoSuchElementException {
        Boolean serializeRead;
        if (!this.validateKeyForReading(ownerOP, key)) {
            return null;
        }
        ExecutionContext ec = ownerOP.getExecutionContext();
        if (this.getStmtLocked == null) {
            FKMapStore fKMapStore = this;
            synchronized (fKMapStore) {
                SelectStatement sqlStmt = this.getSQLStatementForGet(ownerOP);
                this.getStmtUnlocked = ((SQLStatement)sqlStmt).getSQLText().toSQL();
                sqlStmt.addExtension("lock-for-update", true);
                this.getStmtLocked = ((SQLStatement)sqlStmt).getSQLText().toSQL();
            }
        }
        String stmt = (serializeRead = ec.getTransaction().getSerializeRead()) != null && serializeRead != false ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(ec, ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerOP.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(ec, ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                    boolean found = rs.next();
                    if (!found) {
                        throw new NoSuchElementException();
                    }
                    if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                        int[] param = new int[this.valueMapping.getNumberOfColumnMappings()];
                        for (int i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                            String msg = "You appear to have a map (persistable) value serialised/embedded into the key of the map at " + this.getOwnerMemberMetaData().getFullFieldName() + " Not supported";
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusDataStoreException(msg);
                        }
                        value = this.valueMapping.getObject(ec, rs, param);
                    } else if (this.valueMapping instanceof ReferenceMapping) {
                        int[] param = new int[this.valueMapping.getNumberOfColumnMappings()];
                        for (int i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        value = this.valueMapping.getObject(ec, rs, param);
                    } else {
                        value = new PersistentClassROF(ec, rs, false, ec.getFetchPlan(), this.getMappingDef, this.valueCmd, this.clr.classForName(this.valueType)).getObject();
                    }
                    JDBCUtils.logWarnings(rs);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056014", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return (V)value;
    }

    protected SelectStatement getSQLStatementForGet(ObjectProvider ownerOP) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SelectStatement sqlStmt = null;
        ExecutionContext ec = ownerOP.getExecutionContext();
        ClassLoaderResolver clr = ownerOP.getExecutionContext().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        if (this.ownerMemberMetaData.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            this.getMappingDef = new StatementClassMapping();
            if (this.mapTable.getDiscriminatorMetaData() != null && this.mapTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
                if (ClassUtils.isReferenceType((Class)valueCls)) {
                    String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(this.valueType, clr);
                    Class[] cls = new Class[clsNames.length];
                    for (int i = 0; i < clsNames.length; ++i) {
                        cls[i] = clr.classForName(clsNames[i]);
                    }
                    sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null).getStatement(ec);
                } else {
                    sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, valueCls, true, null, null).getStatement(ec);
                }
                this.iterateUsingDiscriminator = true;
            } else {
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
                stmtGen.setOption("selectDnType");
                this.getMappingDef.setNucleusTypeColumnName("DN_TYPE");
                sqlStmt = stmtGen.getStatement(ec);
            }
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ec.getFetchPlan(), sqlStmt.getPrimaryTable(), this.valueCmd, ec.getFetchPlan().getMaxFetchDepth());
        } else {
            sqlStmt = new SelectStatement(this.storeMgr, this.mapTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            if (this.valueCmd != null) {
                SQLTable valueSqlTbl = sqlStmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sqlStmt.getPrimaryTable(), this.valueMapping, (Table)this.mapTable, null, this.mapTable.getIdMapping(), null, null, true);
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ec.getFetchPlan(), valueSqlTbl, this.valueCmd, ec.getFetchPlan().getMaxFetchDepth());
            } else {
                sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
            }
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] ownerPositions = new int[this.ownerMapping.getNumberOfColumnMappings()];
                for (int k = 0; k < ownerPositions.length; ++k) {
                    ownerPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(ownerPositions);
                int[] keyPositions = new int[this.keyMapping.getNumberOfColumnMappings()];
                for (int k = 0; k < keyPositions.length; ++k) {
                    keyPositions[k] = inputParamNum++;
                }
                keyIdx.addParameterOccurrence(keyPositions);
            }
        } else {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfColumnMappings()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfColumnMappings()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }

    public boolean updateEmbeddedKey(ObjectProvider op, Object key, int fieldNumber, Object newValue) {
        return false;
    }

    public boolean updateEmbeddedValue(ObjectProvider op, Object value, int fieldNumber, Object newValue) {
        return false;
    }
}

