/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ColumnMappingPostSet;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public abstract class JavaTypeMapping {
    protected AbstractMemberMetaData mmd;
    protected FieldRole roleForMember = FieldRole.ROLE_NONE;
    protected ColumnMapping[] columnMappings = new ColumnMapping[0];
    protected Table table;
    protected RDBMSStoreManager storeMgr;
    protected String type;
    protected JavaTypeMapping referenceMapping;
    protected int absFieldNumber = -1;

    protected JavaTypeMapping() {
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        this.storeMgr = storeMgr;
        this.type = type;
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.storeMgr = table.getStoreManager();
        this.mmd = mmd;
        this.table = table;
        this.type = this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT ? mmd.getArray().getElementType() : (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT ? mmd.getCollection().getElementType() : (this.roleForMember == FieldRole.ROLE_MAP_KEY ? mmd.getMap().getKeyType() : (this.roleForMember == FieldRole.ROLE_MAP_VALUE ? mmd.getMap().getValueType() : mmd.getType().getName())));
    }

    public int hashCode() {
        return this.mmd == null || this.table == null ? super.hashCode() : this.mmd.hashCode() ^ this.table.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JavaTypeMapping other = (JavaTypeMapping)obj;
        return this.mmd.equals(other.mmd) && this.table.equals(other.table);
    }

    public void setMemberMetaData(AbstractMemberMetaData mmd) {
        this.mmd = mmd;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    public RDBMSStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public FieldRole getRoleForMember() {
        return this.roleForMember;
    }

    public void setRoleForMember(FieldRole role) {
        this.roleForMember = role;
    }

    protected int getAbsoluteFieldNumber() {
        if (this.absFieldNumber < 0 && this.mmd != null) {
            this.absFieldNumber = this.mmd.getAbsoluteFieldNumber();
        }
        return this.absFieldNumber;
    }

    public void setAbsFieldNumber(int num) {
        this.absFieldNumber = num;
    }

    public boolean isSerialised() {
        if (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getCollection() != null ? this.mmd.getCollection().isSerializedElement() : false;
        }
        if (this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getArray() != null ? this.mmd.getArray().isSerializedElement() : false;
        }
        if (this.roleForMember == FieldRole.ROLE_MAP_KEY) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedKey() : false;
        }
        if (this.roleForMember == FieldRole.ROLE_MAP_VALUE) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedValue() : false;
        }
        return this.mmd != null ? this.mmd.isSerialized() : false;
    }

    public boolean isNullable() {
        for (int i = 0; i < this.columnMappings.length; ++i) {
            if (this.columnMappings[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSimpleDatastoreRepresentation() {
        return true;
    }

    public boolean representableAsStringLiteralInStatement() {
        return true;
    }

    public ColumnMapping[] getColumnMappings() {
        return this.columnMappings;
    }

    public ColumnMapping getColumnMapping(int index) {
        return this.columnMappings[index];
    }

    public void addColumnMapping(ColumnMapping cm) {
        ColumnMapping[] dm = this.columnMappings;
        this.columnMappings = new ColumnMapping[this.columnMappings.length + 1];
        System.arraycopy(dm, 0, this.columnMappings, 0, dm.length);
        this.columnMappings[dm.length] = cm;
    }

    public int getNumberOfColumnMappings() {
        return this.columnMappings.length;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        return value;
    }

    public JavaTypeMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(JavaTypeMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public abstract Class getJavaType();

    public String getJavaTypeForColumnMapping(int index) {
        throw new UnsupportedOperationException("Datastore type mapping is not supported by: " + this.getClass());
    }

    public String getType() {
        return this.type;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    protected String failureMessage(String method) {
        return Localiser.msg((String)"041004", (Object[])new Object[]{this.getClass().getName(), method});
    }

    public void setBoolean(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public void setChar(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    public String getString(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value, ObjectProvider ownerOP, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex, ObjectProvider ownerOP, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    protected static ColumnMetaData[] getColumnMetaDataForMember(AbstractMemberMetaData mmd, FieldRole role) {
        if (mmd == null) {
            return null;
        }
        ColumnMetaData[] colmds = null;
        if (role == FieldRole.ROLE_COLLECTION_ELEMENT || role == FieldRole.ROLE_ARRAY_ELEMENT) {
            if (mmd.getJoinMetaData() != null && mmd.getElementMetaData() != null && mmd.getElementMetaData().getColumnMetaData() != null) {
                colmds = mmd.getElementMetaData().getColumnMetaData();
            }
        } else if (role == FieldRole.ROLE_MAP_KEY) {
            if (mmd.getJoinMetaData() != null && mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getColumnMetaData() != null) {
                colmds = mmd.getKeyMetaData().getColumnMetaData();
            }
        } else if (role == FieldRole.ROLE_MAP_VALUE) {
            if (mmd.getJoinMetaData() != null && mmd.getValueMetaData() != null && mmd.getValueMetaData().getColumnMetaData() != null) {
                colmds = mmd.getValueMetaData().getColumnMetaData();
            }
        } else if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            colmds = mmd.getColumnMetaData();
        }
        return colmds;
    }

    public boolean requiresSetPostProcessing() {
        for (int i = 0; i < this.columnMappings.length; ++i) {
            if (!(this.columnMappings[i] instanceof ColumnMappingPostSet)) continue;
            return true;
        }
        return false;
    }

    public void performSetPostProcessing(ObjectProvider op) {
    }
}

