/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.SQLiteTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf2Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod4;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class SQLiteAdapter
extends BaseDatastoreAdapter {
    protected static final int MAX_IDENTIFIER_LENGTH = 128;

    public SQLiteAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("FKInEndCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("IdentityPkInCreateTableColumnDef");
        this.supportedOptions.add("OrderByNullsUsingColumnIsNull");
        this.supportedOptions.remove("TxIsolationReadCommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("IdentityNullSpecification");
        this.supportedOptions.remove("RightOuterJoin");
        this.supportedOptions.remove("SomeAllAnySubqueries");
        this.supportedOptions.remove("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.remove("UpdateDeleteStmtAllowTableAliasInWhere");
        this.maxTableNameLength = 128;
        this.maxColumnNameLength = 128;
        this.maxConstraintNameLength = 128;
        this.maxIndexNameLength = 128;
    }

    @Override
    public String getVendorID() {
        return "sqlite";
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLiteTypeInfo sqlType = new SQLiteTypeInfo("double", 8, 0, null, null, null, 1, true, 3, false, false, false, "double", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new SQLiteTypeInfo("float", 6, 0, null, null, null, 1, true, 3, false, false, false, "float", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new SQLiteTypeInfo("decimal", 3, 0, null, null, null, 1, true, 3, false, false, false, "decimal", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new SQLiteTypeInfo("numeric", 2, 0, null, null, null, 1, true, 3, false, false, false, "numeric", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", 16, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", -7, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
        sqlType = new SQLiteTypeInfo("tinyint", -6, 0, null, null, null, 1, true, 3, false, false, false, "tinyint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new SQLiteTypeInfo("smallint", 5, 0, null, null, null, 1, true, 3, false, false, false, "smallint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)5, sqlType, true);
        sqlType = new SQLiteTypeInfo("bigint", -5, 0, null, null, null, 1, true, 3, false, false, false, "bigint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new SQLiteTypeInfo("char", 1, 255, null, null, null, 1, true, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new SQLiteTypeInfo("varchar", 12, 255, null, null, null, 1, true, 3, false, false, false, "varchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)12, sqlType, true);
        sqlType = new SQLiteTypeInfo("longvarchar", -1, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "longvarchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType, true);
        sqlType = new SQLiteTypeInfo("clob", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "clob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new SQLiteTypeInfo("date", 91, 0, null, null, null, 1, true, 3, false, false, false, "date", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        sqlType = new SQLiteTypeInfo("time", 92, 0, null, null, null, 1, true, 3, false, false, false, "time", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
        sqlType = new SQLiteTypeInfo("timestamp", 93, 0, null, null, null, 1, true, 3, false, false, false, "timestamp", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)93, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -2, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -3, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -4, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support CREATE SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support DROP SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ").append(tbl.getTable().toString());
        sql.append(" ").append(setSQL);
        return sql;
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE FROM " + tbl.getTable().toString();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 9223372036854775807 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        return "SELECT last_insert_rowid()";
    }

    @Override
    public String getIdentityKeyword(StoreManager storeMgr) {
        return "autoincrement";
    }

    @Override
    public Class getIdentityJavaTypeForType(Class type) {
        if (type.isPrimitive()) {
            return Integer.TYPE;
        }
        return Integer.class;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod4.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod4.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod4.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod4.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod5.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod5.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod5.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod6.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf2Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength3Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

