/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.rdbms.query.AbstractROF;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.query.StatementNewObjectMapping;
import org.datanucleus.store.rdbms.query.StatementResultMapping;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ResultClassROF
extends AbstractROF {
    private final Class resultClass;
    private final StatementMappingIndex[] stmtMappings;
    private StatementResultMapping resultDefinition;
    private final String[] resultFieldNames;
    private final Class[] resultFieldTypes;
    private final Map resultClassFieldsByName = new HashMap();
    private static Map<Class, ResultSetGetter> resultSetGetters = new HashMap<Class, ResultSetGetter>(15);

    public ResultClassROF(ExecutionContext ec, ResultSet rs, boolean ignoreCache, FetchPlan fp, Class cls, StatementResultMapping resultDefinition) {
        super(ec, rs, ignoreCache, fp);
        Class tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : (cls == null ? (resultDefinition != null && resultDefinition.getNumberOfResultExpressions() == 1 ? Object.class : Object[].class) : cls);
        this.resultClass = tmpClass;
        this.resultDefinition = resultDefinition;
        this.stmtMappings = null;
        if (resultDefinition != null) {
            this.resultFieldNames = new String[resultDefinition.getNumberOfResultExpressions()];
            this.resultFieldTypes = new Class[resultDefinition.getNumberOfResultExpressions()];
            for (int i = 0; i < this.resultFieldNames.length; ++i) {
                Object stmtMap = resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    this.resultFieldNames[i] = idx.getColumnAlias();
                    this.resultFieldTypes[i] = idx.getMapping().getJavaType();
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping || stmtMap instanceof StatementClassMapping) continue;
                throw new NucleusUserException("Unsupported component " + stmtMap.getClass().getName() + " found in results");
            }
        } else {
            this.resultFieldNames = null;
            this.resultFieldTypes = null;
        }
    }

    public ResultClassROF(ExecutionContext ec, ResultSet rs, boolean ignoreCache, FetchPlan fp, Class cls, StatementClassMapping classDefinition) {
        super(ec, rs, ignoreCache, fp);
        Class<HashMap> tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        this.resultClass = tmpClass;
        this.resultDefinition = null;
        int[] memberNumbers = classDefinition.getMemberNumbers();
        this.stmtMappings = new StatementMappingIndex[memberNumbers.length];
        this.resultFieldNames = new String[this.stmtMappings.length];
        this.resultFieldTypes = new Class[this.stmtMappings.length];
        for (int i = 0; i < this.stmtMappings.length; ++i) {
            this.stmtMappings[i] = classDefinition.getMappingForMemberPosition(memberNumbers[i]);
            this.resultFieldNames[i] = this.stmtMappings[i].getMapping().getMemberMetaData().getName();
            this.resultFieldTypes[i] = this.stmtMappings[i].getMapping().getJavaType();
        }
    }

    public ResultClassROF(ExecutionContext ec, ResultSet rs, boolean ignoreCache, FetchPlan fp, Class cls, String[] resultFieldNames) {
        super(ec, rs, ignoreCache, fp);
        Class<HashMap> tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        this.resultClass = tmpClass;
        if (QueryUtils.resultClassIsUserType((String)this.resultClass.getName())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ResultClassROF.this.populateDeclaredFieldsForUserType(ResultClassROF.this.resultClass);
                    return null;
                }
            });
        }
        this.stmtMappings = null;
        this.resultFieldTypes = null;
        this.resultFieldNames = resultFieldNames != null ? resultFieldNames : new String[]{};
    }

    @Override
    public Object getObject() {
        int i;
        Object[] fieldValues = null;
        if (this.resultDefinition != null) {
            fieldValues = new Object[this.resultDefinition.getNumberOfResultExpressions()];
            for (i = 0; i < this.resultDefinition.getNumberOfResultExpressions(); ++i) {
                Object stmtMap = this.resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    fieldValues[i] = idx.getMapping().getObject(this.ec, this.rs, idx.getColumnPositions());
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping) {
                    StatementNewObjectMapping newIdx = (StatementNewObjectMapping)stmtMap;
                    fieldValues[i] = this.getValueForNewObject(newIdx, this.ec, this.rs);
                    continue;
                }
                if (!(stmtMap instanceof StatementClassMapping)) continue;
                StatementClassMapping classMap = (StatementClassMapping)stmtMap;
                Class cls = this.ec.getClassLoaderResolver().classForName(classMap.getClassName());
                AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(cls, this.ec.getClassLoaderResolver());
                PersistentClassROF rof = new PersistentClassROF(this.ec, this.rs, this.ignoreCache, this.fp, classMap, acmd, cls);
                fieldValues[i] = rof.getObject();
                if (this.resultDefinition.getNumberOfResultExpressions() != 1 || !classMap.getClassName().equals(this.resultClass.getName())) continue;
                return fieldValues[0];
            }
        } else if (this.stmtMappings != null) {
            fieldValues = new Object[this.stmtMappings.length];
            for (i = 0; i < this.stmtMappings.length; ++i) {
                fieldValues[i] = this.stmtMappings[i] != null ? this.stmtMappings[i].getMapping().getObject(this.ec, this.rs, this.stmtMappings[i].getColumnPositions()) : null;
            }
        } else {
            try {
                fieldValues = new Object[this.resultFieldNames != null ? this.resultFieldNames.length : 0];
                for (i = 0; i < fieldValues.length; ++i) {
                    fieldValues[i] = this.getResultObject(this.rs, i + 1);
                }
            }
            catch (SQLException sqe) {
                String msg = Localiser.msg((String)"021043", (Object[])new Object[]{sqe.getMessage()});
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
        }
        if (this.resultClass == Object[].class) {
            return fieldValues;
        }
        if (QueryUtils.resultClassIsSimple((String)this.resultClass.getName())) {
            if (fieldValues.length == 1 && (fieldValues[0] == null || this.resultClass.isAssignableFrom(fieldValues[0].getClass()))) {
                return fieldValues[0];
            }
            if (fieldValues.length == 1 && !this.resultClass.isAssignableFrom(fieldValues[0].getClass())) {
                String msg = Localiser.msg((String)"021202", (Object[])new Object[]{this.resultClass.getName(), fieldValues[0].getClass().getName()});
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
        } else {
            if (fieldValues.length == 1 && fieldValues[0] != null && this.resultClass.isAssignableFrom(fieldValues[0].getClass())) {
                return fieldValues[0];
            }
            Object obj = QueryUtils.createResultObjectUsingArgumentedConstructor((Class)this.resultClass, (Object[])fieldValues, (Class[])this.resultFieldTypes);
            if (obj != null) {
                return obj;
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                if (this.resultFieldNames != null) {
                    Object[] ctr_arg_types = new Class[this.resultFieldNames.length];
                    for (int i2 = 0; i2 < this.resultFieldNames.length; ++i2) {
                        ctr_arg_types[i2] = fieldValues[i2] != null ? fieldValues[i2].getClass() : null;
                    }
                    NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021206", (Object[])new Object[]{this.resultClass.getName(), StringUtils.objectArrayToString((Object[])ctr_arg_types)}));
                } else {
                    StringBuilder str = new StringBuilder();
                    if (this.stmtMappings != null) {
                        for (StatementMappingIndex stmtMapping : this.stmtMappings) {
                            if (str.length() > 0) {
                                str.append(",");
                            }
                            Class javaType = stmtMapping.getMapping().getJavaType();
                            str.append(javaType.getName());
                        }
                        NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021206", (Object[])new Object[]{this.resultClass.getName(), str.toString()}));
                    }
                }
            }
            obj = QueryUtils.createResultObjectUsingDefaultConstructorAndSetters((Class)this.resultClass, (String[])this.resultFieldNames, (Map)this.resultClassFieldsByName, (Object[])fieldValues);
            return obj;
        }
        String msg = Localiser.msg((String)"021203", (Object[])new Object[]{this.resultClass.getName()});
        NucleusLogger.QUERY.error((Object)msg);
        throw new NucleusUserException(msg);
    }

    protected Object getValueForNewObject(StatementNewObjectMapping newMap, ExecutionContext ec, ResultSet rs) {
        Object value = null;
        if (newMap.getNumberOfConstructorArgMappings() == 0) {
            try {
                value = newMap.getObjectClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to create object for query result row of type " + newMap.getObjectClass().getName() + " threw an exception", (Throwable)e);
            }
        }
        int numArgs = newMap.getNumberOfConstructorArgMappings();
        Class[] ctrArgTypes = new Class[numArgs];
        Object[] ctrArgValues = new Object[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Object obj = newMap.getConstructorArgMapping(i);
            if (obj instanceof StatementMappingIndex) {
                StatementMappingIndex idx = (StatementMappingIndex)obj;
                ctrArgValues[i] = idx.getMapping().getObject(ec, rs, idx.getColumnPositions());
            } else {
                ctrArgValues[i] = obj instanceof StatementNewObjectMapping ? this.getValueForNewObject((StatementNewObjectMapping)obj, ec, rs) : obj;
            }
            ctrArgTypes[i] = ctrArgValues[i] != null ? ctrArgValues[i].getClass() : null;
        }
        Constructor ctr = ClassUtils.getConstructorWithArguments((Class)newMap.getObjectClass(), (Class[])ctrArgTypes);
        if (ctr == null) {
            StringBuilder str = new StringBuilder(newMap.getObjectClass().getName() + "(");
            for (int i = 0; i < ctrArgTypes.length; ++i) {
                if (ctrArgTypes[i] != null) {
                    str.append(ctrArgTypes[i].getName());
                } else {
                    str.append("(null)");
                }
                if (i == ctrArgTypes.length - 1) continue;
                str.append(',');
            }
            str.append(")");
            throw new NucleusUserException(Localiser.msg((String)"037013", (Object[])new Object[]{str.toString()}));
        }
        try {
            value = ctr.newInstance(ctrArgValues);
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"037015", (Object[])new Object[]{newMap.getObjectClass().getName(), e}));
        }
        return value;
    }

    private void populateDeclaredFieldsForUserType(Class cls) {
        Field[] declaredFields;
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            if (field.isSynthetic() || this.resultClassFieldsByName.put(field.getName().toUpperCase(), field) == null || field.getName().startsWith(this.ec.getMetaDataManager().getEnhancedMethodNamePrefix())) continue;
            throw new NucleusUserException(Localiser.msg((String)"021210", (Object[])new Object[]{field.getName()}));
        }
        if (cls.getSuperclass() != null) {
            this.populateDeclaredFieldsForUserType(cls.getSuperclass());
        }
    }

    private Object getResultObject(ResultSet rs, int columnNumber) throws SQLException {
        ResultSetGetter getter = resultSetGetters.get(this.resultClass);
        if (getter != null) {
            return getter.getValue(rs, columnNumber);
        }
        return rs.getObject(columnNumber);
    }

    static {
        resultSetGetters.put(Boolean.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBoolean(i);
            }
        });
        resultSetGetters.put(Byte.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getByte(i);
            }
        });
        resultSetGetters.put(Short.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getShort(i);
            }
        });
        resultSetGetters.put(Integer.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getInt(i);
            }
        });
        resultSetGetters.put(Long.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getLong(i);
            }
        });
        resultSetGetters.put(Float.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return Float.valueOf(rs.getFloat(i));
            }
        });
        resultSetGetters.put(Double.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDouble(i);
            }
        });
        resultSetGetters.put(BigDecimal.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBigDecimal(i);
            }
        });
        resultSetGetters.put(String.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getString(i);
            }
        });
        ResultSetGetter timestampGetter = new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getTimestamp(i);
            }
        };
        resultSetGetters.put(Timestamp.class, timestampGetter);
        resultSetGetters.put(java.util.Date.class, timestampGetter);
        resultSetGetters.put(Date.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDate(i);
            }
        });
        resultSetGetters.put(byte[].class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBytes(i);
            }
        });
        resultSetGetters.put(Reader.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getCharacterStream(i);
            }
        });
        resultSetGetters.put(Array.class, new ResultSetGetter(){

            @Override
            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getArray(i);
            }
        });
    }

    private static interface ResultSetGetter {
        public Object getValue(ResultSet var1, int var2) throws SQLException;
    }
}

