/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.LockMode;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleCollectionMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FetchRequest
extends Request {
    private String statementUnlocked;
    private String statementLocked;
    private int[] memberNumbersToFetch = null;
    private StatementClassMapping mappingDefinition;
    private final MappingCallbacks[] callbacks;
    private int numberOfFieldsToFetch = 0;
    private final String fieldsToFetch;
    private boolean fetchingSurrogateVersion = false;
    private String versionFieldName = null;

    public FetchRequest(DatastoreClass classTable, AbstractMemberMetaData[] mmds, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        super(classTable);
        JavaTypeMapping softDeleteMapping;
        DatastoreClass candidateTable;
        RDBMSStoreManager storeMgr = classTable.getStoreManager();
        boolean found = false;
        if (mmds != null) {
            for (candidateTable = classTable; candidateTable != null; candidateTable = candidateTable.getSuperDatastoreClass()) {
                for (int i = 0; i < mmds.length; ++i) {
                    JavaTypeMapping m = candidateTable.getMemberMappingInDatastoreClass(mmds[i]);
                    if (m == null) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
        if (candidateTable == null) {
            candidateTable = classTable;
        }
        this.table = candidateTable;
        this.key = ((AbstractClassTable)((Object)this.table)).getPrimaryKey();
        for (DatastoreClass currentTable = this.table; currentTable != null; currentTable = currentTable.getSuperDatastoreClass()) {
            VersionMetaData currentVermd = currentTable.getVersionMetaData();
            if (currentVermd == null) continue;
            if (currentVermd.getFieldName() == null) {
                this.fetchingSurrogateVersion = true;
                continue;
            }
            this.versionFieldName = currentVermd.getFieldName();
        }
        SelectStatement sqlStatement = new SelectStatement(storeMgr, this.table, null, null);
        this.mappingDefinition = new StatementClassMapping();
        HashSet fetchCallbacks = new HashSet();
        this.numberOfFieldsToFetch = this.processMembersOfClass(sqlStatement, mmds, this.table, sqlStatement.getPrimaryTable(), this.mappingDefinition, fetchCallbacks, clr);
        this.callbacks = fetchCallbacks.toArray(new MappingCallbacks[fetchCallbacks.size()]);
        this.memberNumbersToFetch = this.mappingDefinition.getMemberNumbers();
        int inputParamNum = 1;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false);
            SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, datastoreIdMapping, null, "ID");
            if (val instanceof ParameterLiteral) {
                val = exprFactory.replaceParameterLiteral((ParameterLiteral)val, expr);
            }
            sqlStatement.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                this.mappingDefinition.addMappingForMember(SurrogateColumnType.DATASTORE_ID.getFieldNumber(), datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum++});
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = this.table.getMemberMapping(mmd);
                SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, pkMapping, null, "PK" + i);
                if (val instanceof ParameterLiteral) {
                    val = exprFactory.replaceParameterLiteral((ParameterLiteral)val, expr);
                }
                sqlStatement.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = this.mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    this.mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfColumnMappings()];
                for (int j = 0; j < pkMapping.getNumberOfColumnMappings(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        JavaTypeMapping multitenancyMapping = this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
        if (multitenancyMapping != null) {
            SQLExpression tenantExpr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), multitenancyMapping);
            String[] tenantReadIds = storeMgr.getNucleusContext().getMultiTenancyReadIds(null);
            if (tenantReadIds != null && tenantReadIds.length > 1) {
                SQLExpression[] readIdExprs = new SQLExpression[tenantReadIds.length];
                for (int i = 0; i < tenantReadIds.length; ++i) {
                    readIdExprs[i] = sqlStatement.getSQLExpressionFactory().newLiteral(sqlStatement, multitenancyMapping, tenantReadIds[i].trim());
                }
                sqlStatement.whereAnd(new InExpression(tenantExpr, readIdExprs), true);
            } else {
                SQLExpression tenantVal = exprFactory.newLiteralParameter(sqlStatement, multitenancyMapping, null, "TENANT");
                if (tenantVal instanceof ParameterLiteral) {
                    tenantVal = exprFactory.replaceParameterLiteral((ParameterLiteral)tenantVal, tenantExpr);
                }
                sqlStatement.whereAnd(tenantExpr.eq(tenantVal), true);
                StatementMappingIndex multitenancyIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.MULTITENANCY.getFieldNumber());
                if (multitenancyIdx == null) {
                    multitenancyIdx = new StatementMappingIndex(multitenancyMapping);
                    this.mappingDefinition.addMappingForMember(SurrogateColumnType.MULTITENANCY.getFieldNumber(), multitenancyIdx);
                }
                multitenancyIdx.addParameterOccurrence(new int[]{inputParamNum++});
            }
        }
        if ((softDeleteMapping = this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
            SQLExpression softDeleteExpr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), softDeleteMapping);
            SQLExpression softDeleteValParam = exprFactory.newLiteralParameter(sqlStatement, softDeleteMapping, null, "SOFTDELETE");
            if (softDeleteValParam instanceof ParameterLiteral) {
                softDeleteValParam = exprFactory.replaceParameterLiteral((ParameterLiteral)softDeleteValParam, softDeleteExpr);
            }
            sqlStatement.whereAnd(softDeleteExpr.eq(softDeleteValParam), true);
            StatementMappingIndex softDeleteIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.SOFTDELETE.getFieldNumber());
            if (softDeleteIdx == null) {
                softDeleteIdx = new StatementMappingIndex(softDeleteMapping);
                this.mappingDefinition.addMappingForMember(SurrogateColumnType.SOFTDELETE.getFieldNumber(), softDeleteIdx);
            }
            softDeleteIdx.addParameterOccurrence(new int[]{inputParamNum++});
        }
        StringBuilder str = new StringBuilder();
        if (mmds != null) {
            for (int i = 0; i < mmds.length; ++i) {
                if (mmds[i].isPrimaryKey()) continue;
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(mmds[i].getName());
            }
        }
        if (this.fetchingSurrogateVersion) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("[VERSION]");
        }
        if (!this.fetchingSurrogateVersion && this.numberOfFieldsToFetch == 0) {
            this.fieldsToFetch = null;
            sqlStatement = null;
            this.mappingDefinition = null;
        } else {
            this.fieldsToFetch = str.toString();
            this.statementUnlocked = sqlStatement.getSQLText().toSQL();
            sqlStatement.addExtension("lock-for-update", Boolean.TRUE);
            this.statementLocked = sqlStatement.getSQLText().toSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ObjectProvider op) {
        if (this.fieldsToFetch != null && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052218", (Object[])new Object[]{op.getObjectAsPrintable(), this.fieldsToFetch, this.table}));
        }
        if ((!this.fetchingSurrogateVersion && this.versionFieldName == null || this.numberOfFieldsToFetch != 0 || !op.isVersionLoaded()) && this.statementLocked != null) {
            ExecutionContext ec = op.getExecutionContext();
            RDBMSStoreManager storeMgr = this.table.getStoreManager();
            boolean locked = ec.getSerializeReadForClass(op.getClassMetaData().getFullClassName());
            LockMode lockType = ec.getLockManager().getLockMode(op.getInternalObjectId());
            if (lockType != LockMode.LOCK_NONE && (lockType == LockMode.LOCK_PESSIMISTIC_READ || lockType == LockMode.LOCK_PESSIMISTIC_WRITE)) {
                locked = true;
            }
            String statement = locked ? this.statementLocked : this.statementUnlocked;
            StatementClassMapping mappingDef = this.mappingDefinition;
            try {
                ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    try {
                        JavaTypeMapping softDeleteMapping;
                        String[] tenantReadIds;
                        JavaTypeMapping multitenancyMapping;
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            StatementMappingIndex datastoreIdx = mappingDef.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
                            for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                                this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, datastoreIdx.getParameterPositionsForOccurrence(i), op.getInternalObjectId());
                            }
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            op.provideFields(cmd.getPKMemberPositions(), (FieldManager)new ParameterSetter(op, ps, mappingDef));
                        }
                        if ((multitenancyMapping = this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false)) != null && ((tenantReadIds = storeMgr.getNucleusContext().getMultiTenancyReadIds(op.getExecutionContext())) == null || tenantReadIds.length <= 1)) {
                            StatementMappingIndex multitenancyIdx = mappingDef.getMappingForMemberPosition(SurrogateColumnType.MULTITENANCY.getFieldNumber());
                            String tenantId = ec.getNucleusContext().getMultiTenancyId(ec);
                            for (int i = 0; i < multitenancyIdx.getNumberOfParameterOccurrences(); ++i) {
                                multitenancyMapping.setObject(ec, ps, multitenancyIdx.getParameterPositionsForOccurrence(i), tenantId);
                            }
                        }
                        if ((softDeleteMapping = this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
                            StatementMappingIndex softDeleteIdx = this.mappingDefinition.getMappingForMemberPosition(SurrogateColumnType.SOFTDELETE.getFieldNumber());
                            for (int i = 0; i < softDeleteIdx.getNumberOfParameterOccurrences(); ++i) {
                                softDeleteMapping.setObject(ec, ps, softDeleteIdx.getParameterPositionsForOccurrence(i), Boolean.FALSE);
                            }
                        }
                        try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, statement, ps);){
                            if (!rs.next()) {
                                if (NucleusLogger.DATASTORE_RETRIEVE.isInfoEnabled()) {
                                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)Localiser.msg((String)"050018", (Object[])new Object[]{op.getInternalObjectId()}));
                                }
                                throw new NucleusObjectNotFoundException("No such database row", op.getInternalObjectId());
                            }
                            ResultSetGetter rsGetter = new ResultSetGetter(ec, rs, mappingDef, op.getClassMetaData());
                            rsGetter.setObjectProvider(op);
                            if (op.getTransactionalVersion() == null) {
                                Object datastoreVersion = null;
                                if (this.fetchingSurrogateVersion) {
                                    StatementMappingIndex verIdx = mappingDef.getMappingForMemberPosition(SurrogateColumnType.VERSION.getFieldNumber());
                                    datastoreVersion = this.table.getSurrogateMapping(SurrogateColumnType.VERSION, true).getObject(ec, rs, verIdx.getColumnPositions());
                                } else if (this.versionFieldName != null) {
                                    int verAbsFieldNum = cmd.getAbsolutePositionOfMember(this.versionFieldName);
                                    op.replaceFields(new int[]{verAbsFieldNum}, (FieldManager)rsGetter);
                                    datastoreVersion = op.provideField(verAbsFieldNum);
                                }
                                op.setVersion(datastoreVersion);
                            }
                            op.replaceFields(this.memberNumbersToFetch, (FieldManager)rsGetter);
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException sqle) {
                String msg = Localiser.msg((String)"052219", (Object[])new Object[]{op.getObjectAsPrintable(), statement, sqle.getMessage()});
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(sqle);
                while ((sqle = sqle.getNextException()) != null) {
                    exceptions.add(sqle);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].postFetch(op);
        }
    }

    protected int processMembersOfClass(SelectStatement sqlStatement, AbstractMemberMetaData[] mmds, DatastoreClass table, SQLTable sqlTbl, StatementClassMapping mappingDef, Collection fetchCallbacks, ClassLoaderResolver clr) {
        JavaTypeMapping versionMapping;
        int number = 0;
        if (mmds != null) {
            for (int i = 0; i < mmds.length; ++i) {
                AbstractMemberMetaData mmd = mmds[i];
                JavaTypeMapping mapping = table.getMemberMapping(mmd);
                if (mapping == null) continue;
                if (!mmd.isPrimaryKey() && mapping.includeInFetchStatement()) {
                    JavaTypeMapping[] subMappings;
                    ReferenceMapping refMapping;
                    int depth = 0;
                    AbstractMemberMetaData mmdToUse = mmd;
                    JavaTypeMapping mappingToUse = mapping;
                    if (mapping instanceof SingleCollectionMapping) {
                        mappingToUse = ((SingleCollectionMapping)mapping).getWrappedMapping();
                        mmdToUse = ((SingleCollectionMapping)mapping).getWrappedMapping().getMemberMetaData();
                    }
                    if (mappingToUse instanceof PersistableMapping) {
                        depth = 1;
                        if (Modifier.isAbstract(mmdToUse.getType().getModifiers())) {
                            String[] subclasses;
                            String typeName = mmdToUse.getTypeName();
                            DatastoreClass relTable = table.getStoreManager().getDatastoreClass(typeName, clr);
                            if (relTable != null && relTable.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false) == null && (subclasses = table.getStoreManager().getMetaDataManager().getSubclassesForClass(typeName, false)) != null && subclasses.length > 0) {
                                depth = 0;
                            }
                        }
                    } else if (mappingToUse instanceof ReferenceMapping && (refMapping = (ReferenceMapping)mappingToUse).getMappingStrategy() == 0 && (subMappings = refMapping.getJavaTypeMapping()) != null && subMappings.length == 1) {
                        depth = 1;
                    }
                    SQLStatementHelper.selectMemberOfSourceInStatement(sqlStatement, mappingDef, null, sqlTbl, mmd, clr, depth, null);
                    ++number;
                }
                if (!(mapping instanceof MappingCallbacks)) continue;
                fetchCallbacks.add(mapping);
            }
        }
        if ((versionMapping = table.getSurrogateMapping(SurrogateColumnType.VERSION, true)) != null) {
            StatementMappingIndex verMapIdx = new StatementMappingIndex(versionMapping);
            SQLTable verSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStatement, sqlTbl, versionMapping);
            int[] cols = sqlStatement.select(verSqlTbl, versionMapping, null);
            verMapIdx.setColumnPositions(cols);
            mappingDef.addMappingForMember(SurrogateColumnType.VERSION.getFieldNumber(), verMapIdx);
        }
        return number;
    }
}

