/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.H2TypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.OtherColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.AvgWithCastFunction;
import org.datanucleus.store.rdbms.sql.method.StringTrim3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimLeft3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimRight3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod;
import org.datanucleus.store.rdbms.sql.operation.Mod2Operation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class H2Adapter
extends BaseDatastoreAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)"Exception when trying to get default schema name for datastore", (Throwable)e);
        }
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("LockRowUsingSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        H2TypeInfo sqlType = new H2TypeInfo("UUID", 1111, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "UUID", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
        sqlType = new H2TypeInfo("GEOMETRY", 1111, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "GEOMETRY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "h2";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return 128;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return 128;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 128;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        return "CREATE SCHEMA IF NOT EXISTS " + schemaName;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName;
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String extendedSetting = idx.getValueForExtension("extended-setting");
        String indexType = idx.getValueForExtension("index-type");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(idx.getUnique() ? " UNIQUE" : "");
        if (indexType != null) {
            stringBuilder.append(indexType.equalsIgnoreCase("HASH") ? " HASH" : (indexType.equalsIgnoreCase("SPATIAL") ? " SPATIAL" : ""));
        }
        stringBuilder.append(" INDEX ");
        stringBuilder.append(factory.newTableIdentifier(idx.getName()).getFullyQualifiedName(true));
        stringBuilder.append(" ON ").append(idx.getTable().toString());
        stringBuilder.append(" ").append(idx.getColumnList(true));
        if (extendedSetting != null) {
            stringBuilder.append(" ").append(extendedSetting);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 2147483647 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    @Override
    public String getIdentityKeyword() {
        return "IDENTITY";
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType datatype) {
        return true;
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE IF NOT EXISTS ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" START WITH " + min);
        } else if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (max != null) {
            throw new NucleusUserException(Localiser.msg((String)"051022"));
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CALL NEXT VALUE FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 90051;
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod2Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("avg".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
            if ("AVG".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("trim".equals(methodName)) {
                    return StringTrim3Method.class;
                }
                if ("trimLeft".equals(methodName)) {
                    return StringTrimLeft3Method.class;
                }
                if ("trimRight".equals(methodName)) {
                    return StringTrimRight3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
            } else {
                if ("java.time.LocalDate".equals(className) && "getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
                if ("java.time.LocalDateTime".equals(className) && "getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(UUID.class.getName(), OtherColumnMapping.class, JDBCType.OTHER, "UUID", false);
        this.registerColumnMapping(UUID.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(UUID.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

