/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final int[] insertFieldNumbers;
    private final int[] pkFieldNumbers;
    private final int[] reachableFieldNumbers;
    private final int[] relationFieldNumbers;
    private final String insertStmt;
    private boolean hasIdentityColumn = false;
    private StatementMappingIndex[] stmtMappings;
    private StatementMappingIndex[] retrievedStmtMappings;
    private StatementMappingIndex versionStmtMapping;
    private StatementMappingIndex discriminatorStmtMapping;
    private StatementMappingIndex multitenancyStmtMapping;
    private StatementMappingIndex softDeleteStmtMapping;
    private StatementMappingIndex[] externalFKStmtMappings;
    private StatementMappingIndex[] externalFKDiscrimStmtMappings;
    private StatementMappingIndex[] externalOrderStmtMappings;
    private boolean batch = false;

    public InsertRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        super(table);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideSurrogateMapping(SurrogateColumnType.DATASTORE_ID, consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideSurrogateMapping(SurrogateColumnType.VERSION, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.MULTITENANCY, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.SOFTDELETE, consumer);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_FK);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_FK_DISCRIMINATOR);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_INDEX);
        table.provideUnmappedColumns(consumer);
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.stmtMappings = consumer.getStatementMappings();
        this.versionStmtMapping = consumer.getVersionStatementMapping();
        this.discriminatorStmtMapping = consumer.getDiscriminatorStatementMapping();
        this.multitenancyStmtMapping = consumer.getMultitenancyStatementMapping();
        this.softDeleteStmtMapping = consumer.getSoftDeleteStatementMapping();
        this.externalFKStmtMappings = consumer.getExternalFKStatementMapping();
        this.externalFKDiscrimStmtMappings = consumer.getExternalFKDiscrimStatementMapping();
        this.externalOrderStmtMappings = consumer.getExternalOrderStatementMapping();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers.length < 1 && !this.hasIdentityColumn) {
            throw new NucleusException(Localiser.msg((String)"052200", (Object[])new Object[]{cmd.getFullClassName()})).setFatal();
        }
        this.insertFieldNumbers = consumer.getInsertFieldNumbers();
        this.retrievedStmtMappings = consumer.getReachableStatementMappings();
        this.reachableFieldNumbers = consumer.getReachableFieldNumbers();
        this.relationFieldNumbers = consumer.getRelationFieldNumbers();
        this.insertStmt = consumer.getInsertStmt();
        if (!this.hasIdentityColumn && !cmd.hasRelations(clr) && this.externalFKStmtMappings == null) {
            this.batch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ObjectProvider op) {
        ExecutionContext ec = op.getExecutionContext();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052207", (Object[])new Object[]{op.getObjectAsPrintable(), this.table}));
        }
        try {
            VersionMetaData vermd = this.table.getVersionMetaData();
            RDBMSStoreManager storeMgr = this.table.getStoreManager();
            if (vermd != null && vermd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                Object currentVersion = op.getVersion();
                if (currentVersion instanceof Number) {
                    currentVersion = ((Number)currentVersion).longValue();
                }
                Object nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                    nextOptimisticVersion = ((Number)nextOptimisticVersion).intValue();
                }
                op.replaceField(verfmd.getAbsoluteFieldNumber(), nextOptimisticVersion);
            }
            op.changeActivityState(ActivityState.INSERTING);
            SQLController sqlControl = storeMgr.getSQLController();
            ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.insertStmt, this.batch, this.hasIdentityColumn && storeMgr.getDatastoreAdapter().supportsOption("GetGeneratedKeysStatement"));
                try {
                    int i;
                    JavaTypeMapping discrimMapping;
                    int k;
                    Object nextOptimisticVersion;
                    JavaTypeMapping versionMapping;
                    int i2;
                    StatementClassMapping mappingDefinition = new StatementClassMapping();
                    StatementMappingIndex[] idxs = this.stmtMappings;
                    for (int i3 = 0; i3 < idxs.length; ++i3) {
                        if (idxs[i3] == null) continue;
                        mappingDefinition.addMappingForMember(i3, idxs[i3]);
                    }
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIdDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, paramNumber, op.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                        op.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(op, ps, mappingDefinition));
                    }
                    if (this.insertFieldNumbers.length > 0) {
                        int numberOfFieldsToProvide = 0;
                        for (int i4 = 0; i4 < this.insertFieldNumbers.length; ++i4) {
                            if (this.insertFieldNumbers[i4] >= op.getClassMetaData().getMemberCount()) continue;
                            AbstractMemberMetaData mmd = op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.insertFieldNumbers[i4]);
                            if (mmd.isCreateTimestamp()) {
                                op.replaceField(this.insertFieldNumbers[i4], (Object)new Timestamp(ec.getTransaction().getIsActive() ? ec.getTransaction().getBeginTime() : System.currentTimeMillis()));
                            } else if (mmd.isCreateUser()) {
                                op.replaceField(this.insertFieldNumbers[i4], (Object)ec.getNucleusContext().getCurrentUser(ec));
                            }
                            ++numberOfFieldsToProvide;
                        }
                        int j = 0;
                        int[] fieldNums = new int[numberOfFieldsToProvide];
                        for (i2 = 0; i2 < this.insertFieldNumbers.length; ++i2) {
                            if (this.insertFieldNumbers[i2] >= op.getClassMetaData().getMemberCount()) continue;
                            fieldNums[j++] = this.insertFieldNumbers[i2];
                        }
                        op.provideFields(fieldNums, (FieldManager)new ParameterSetter(op, ps, mappingDefinition));
                    }
                    if ((versionMapping = this.table.getSurrogateMapping(SurrogateColumnType.VERSION, false)) != null) {
                        Object currentVersion = op.getVersion();
                        nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                        for (k = 0; k < this.versionStmtMapping.getNumberOfParameterOccurrences(); ++k) {
                            versionMapping.setObject(ec, ps, this.versionStmtMapping.getParameterPositionsForOccurrence(k), nextOptimisticVersion);
                        }
                        op.setTransactionalVersion(nextOptimisticVersion);
                    } else if (vermd != null && vermd.getFieldName() != null) {
                        Object currentVersion = op.getVersion();
                        nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                        op.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.multitenancyStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false).setObject(ec, ps, this.multitenancyStmtMapping.getParameterPositionsForOccurrence(0), ec.getNucleusContext().getMultiTenancyId(ec, op.getClassMetaData()));
                    }
                    if (this.softDeleteStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false).setObject(ec, ps, this.softDeleteStmtMapping.getParameterPositionsForOccurrence(0), Boolean.FALSE);
                    }
                    if ((discrimMapping = this.table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false)) != null) {
                        Object discVal = op.getClassMetaData().getDiscriminatorValue();
                        for (k = 0; k < this.discriminatorStmtMapping.getNumberOfParameterOccurrences(); ++k) {
                            discrimMapping.setObject(ec, ps, this.discriminatorStmtMapping.getParameterPositionsForOccurrence(k), discVal);
                        }
                    }
                    if (this.externalFKStmtMappings != null) {
                        for (int i5 = 0; i5 < this.externalFKStmtMappings.length; ++i5) {
                            Object fkValue = op.getAssociatedValue((Object)this.externalFKStmtMappings[i5].getMapping());
                            if (fkValue != null) {
                                AbstractMemberMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStmtMappings[i5].getMapping(), MappingType.EXTERNAL_FK);
                                for (int k2 = 0; k2 < this.externalFKStmtMappings[i5].getNumberOfParameterOccurrences(); ++k2) {
                                    this.externalFKStmtMappings[i5].getMapping().setObject(ec, ps, this.externalFKStmtMappings[i5].getParameterPositionsForOccurrence(k2), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                }
                                continue;
                            }
                            for (int k3 = 0; k3 < this.externalFKStmtMappings[i5].getNumberOfParameterOccurrences(); ++k3) {
                                this.externalFKStmtMappings[i5].getMapping().setObject(ec, ps, this.externalFKStmtMappings[i5].getParameterPositionsForOccurrence(k3), null);
                            }
                        }
                    }
                    if (this.externalFKDiscrimStmtMappings != null) {
                        for (int i6 = 0; i6 < this.externalFKDiscrimStmtMappings.length; ++i6) {
                            Object discrimValue = op.getAssociatedValue((Object)this.externalFKDiscrimStmtMappings[i6].getMapping());
                            for (int k4 = 0; k4 < this.externalFKDiscrimStmtMappings[i6].getNumberOfParameterOccurrences(); ++k4) {
                                this.externalFKDiscrimStmtMappings[i6].getMapping().setObject(ec, ps, this.externalFKDiscrimStmtMappings[i6].getParameterPositionsForOccurrence(k4), discrimValue);
                            }
                        }
                    }
                    if (this.externalOrderStmtMappings != null) {
                        for (int i7 = 0; i7 < this.externalOrderStmtMappings.length; ++i7) {
                            Object orderValue = op.getAssociatedValue((Object)this.externalOrderStmtMappings[i7].getMapping());
                            if (orderValue == null) {
                                orderValue = -1;
                            }
                            for (int k5 = 0; k5 < this.externalOrderStmtMappings[i7].getNumberOfParameterOccurrences(); ++k5) {
                                this.externalOrderStmtMappings[i7].getMapping().setObject(ec, ps, this.externalOrderStmtMappings[i7].getParameterPositionsForOccurrence(k5), orderValue);
                            }
                        }
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, this.insertStmt, ps, !this.batch);
                    if (this.hasIdentityColumn) {
                        Object newId = this.getInsertedDatastoreIdentity(ec, sqlControl, op, mconn, ps);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052206", (Object[])new Object[]{op.getObjectAsPrintable(), newId}));
                        }
                        op.setPostStoreNewObjectId(newId);
                    }
                    for (i = 0; i < this.callbacks.length; ++i) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052222", (Object[])new Object[]{op.getObjectAsPrintable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getMemberMetaData().getFullFieldName()}));
                        }
                        this.callbacks[i].insertPostProcessing(op);
                    }
                    storeMgr.setObjectIsInsertedToLevel(op, this.table);
                    for (i = 0; i < this.relationFieldNumbers.length; ++i) {
                        Object value = op.provideField(this.relationFieldNumbers[i]);
                        if (value == null || !ec.getApiAdapter().isDetached(value)) continue;
                        Object valueAttached = ec.persistObjectInternal(value, null, -1, 0);
                        op.replaceField(this.relationFieldNumbers[i], valueAttached);
                    }
                    if (this.reachableFieldNumbers.length > 0) {
                        int i8;
                        int numberOfReachableFields = 0;
                        for (i2 = 0; i2 < this.reachableFieldNumbers.length; ++i2) {
                            if (this.reachableFieldNumbers[i2] >= op.getClassMetaData().getMemberCount()) continue;
                            ++numberOfReachableFields;
                        }
                        int[] fieldNums = new int[numberOfReachableFields];
                        int j = 0;
                        for (i8 = 0; i8 < this.reachableFieldNumbers.length; ++i8) {
                            if (this.reachableFieldNumbers[i8] >= op.getClassMetaData().getMemberCount()) continue;
                            fieldNums[j++] = this.reachableFieldNumbers[i8];
                        }
                        mappingDefinition = new StatementClassMapping();
                        idxs = this.retrievedStmtMappings;
                        for (i8 = 0; i8 < idxs.length; ++i8) {
                            if (idxs[i8] == null) continue;
                            mappingDefinition.addMappingForMember(i8, idxs[i8]);
                        }
                        NucleusLogger.PERSISTENCE.debug((Object)("Performing reachability on fields " + StringUtils.intArrayToString((int[])fieldNums)));
                        op.provideFields(fieldNums, (FieldManager)new ParameterSetter(op, ps, mappingDefinition));
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"052208", (Object[])new Object[]{op.getObjectAsPrintable(), this.insertStmt, e.getMessage()});
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052209", (Object[])new Object[]{op.getObjectAsPrintable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getMemberMetaData().getFullFieldName()}));
                }
                this.callbacks[i].postInsert(op);
                continue;
            }
            catch (NotYetFlushedException e) {
                op.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getMemberMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInsertedDatastoreIdentity(ExecutionContext ec, SQLController sqlControl, ObjectProvider op, ManagedConnection mconn, PreparedStatement ps) throws SQLException {
        Object datastoreId = null;
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        if (storeMgr.getDatastoreAdapter().supportsOption("GetGeneratedKeysStatement")) {
            try (ResultSet rs = null;){
                rs = ps.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
        }
        if (datastoreId == null) {
            String columnName = null;
            JavaTypeMapping idMapping = this.table.getIdMapping();
            if (idMapping != null) {
                for (int i = 0; i < idMapping.getNumberOfColumnMappings(); ++i) {
                    Column col = idMapping.getColumnMapping(i).getColumn();
                    if (!col.isIdentity()) continue;
                    columnName = col.getIdentifier().toString();
                    break;
                }
            }
            String autoIncStmt = storeMgr.getDatastoreAdapter().getIdentityLastValueStmt(this.table, columnName);
            PreparedStatement psAutoIncrement = sqlControl.getStatementForQuery(mconn, autoIncStmt);
            ResultSet rs = null;
            try {
                rs = sqlControl.executeStatementQuery(ec, mconn, autoIncStmt, psAutoIncrement);
                if (rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psAutoIncrement != null) {
                    psAutoIncrement.close();
                }
            }
        }
        if (datastoreId == null) {
            throw new NucleusDataStoreException(Localiser.msg((String)"052205", (Object[])new Object[]{this.table}));
        }
        return datastoreId;
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List insertFields = new ArrayList();
        List pkFields = new ArrayList();
        List reachableFields = new ArrayList();
        List relationFields = new ArrayList();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        Map assignedColumns = new HashMap();
        List mc = new ArrayList();
        boolean initialized = false;
        int paramIndex;
        private StatementMappingIndex[] statementMappings;
        private StatementMappingIndex[] retrievedStatementMappings;
        private StatementMappingIndex versionStatementMapping;
        private StatementMappingIndex discriminatorStatementMapping;
        private StatementMappingIndex multitenancyStatementMapping;
        private StatementMappingIndex softDeleteStatementMapping;
        private StatementMappingIndex[] externalFKStmtExprIndex;
        private StatementMappingIndex[] externalFKDiscrimStmtExprIndex;
        private StatementMappingIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        @Override
        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementMappings = new StatementMappingIndex[highestFieldNumber];
                this.retrievedStatementMappings = new StatementMappingIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData mmd) {
            if (!mmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInInsertStatement()) {
                if (m.getNumberOfColumnMappings() == 0 && (m instanceof PersistableMapping || m instanceof ReferenceMapping)) {
                    this.retrievedStatementMappings[mmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    RelationType relationType = mmd.getRelationType(this.clr);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() != null) {
                            this.reachableFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            this.reachableFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    }
                } else {
                    RelationType relationType;
                    if (mmd.hasExtension("insertable") && mmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                        return;
                    }
                    ColumnMetaData[] colmds = mmd.getColumnMetaData();
                    if (colmds != null && colmds.length > 0) {
                        for (int i = 0; i < colmds.length; ++i) {
                            if (colmds[i].getInsertable()) continue;
                            return;
                        }
                    }
                    if ((relationType = mmd.getRelationType(this.clr)) == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() == null) {
                            // empty if block
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                            this.relationFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    }
                    this.statementMappings[mmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    int[] parametersIndex = new int[m.getNumberOfColumnMappings()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        Column c = m.getColumnMapping(j).getColumn();
                        DatastoreIdentifier columnId = c.getIdentifier();
                        boolean columnExists = this.assignedColumns.containsKey(columnId.toString());
                        if (columnExists) {
                            parametersIndex[j] = (Integer)this.assignedColumns.get(c.getIdentifier().toString());
                        }
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.isBaseDatastoreClass() || !InsertRequest.this.table.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, mmd.getAbsoluteFieldNumber()) && !c.isIdentity()) {
                            if (!columnExists) {
                                if (this.columnNames.length() > 0) {
                                    this.columnNames.append(',');
                                    this.columnValues.append(',');
                                }
                                this.columnNames.append(columnId);
                                this.columnValues.append(m.getColumnMapping(j).getInsertionInputParameter());
                            }
                            if (m.getColumnMapping(j).insertValuesOnInsert()) {
                                Integer abs_field_num = mmd.getAbsoluteFieldNumber();
                                if (mmd.isPrimaryKey()) {
                                    if (!this.pkFields.contains(abs_field_num)) {
                                        this.pkFields.add(abs_field_num);
                                    }
                                } else if (!this.insertFields.contains(abs_field_num)) {
                                    this.insertFields.add(abs_field_num);
                                }
                                if (columnExists) {
                                    parametersIndex[j] = (Integer)this.assignedColumns.get(c.getIdentifier().toString());
                                } else {
                                    ++this.paramIndex;
                                }
                            }
                            if (columnExists) continue;
                            this.assignedColumns.put(c.getIdentifier().toString(), mmd.getAbsoluteFieldNumber());
                            continue;
                        }
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                    this.statementMappings[mmd.getAbsoluteFieldNumber()].addParameterOccurrence(parametersIndex);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, MappingType mappingType) {
            if (mappingType == MappingType.VERSION) {
                JavaTypeMapping versionMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.VERSION, false);
                if (versionMapping != null) {
                    String val = versionMapping.getColumnMapping(0).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(versionMapping.getColumnMapping(0).getColumn().getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementMapping = new StatementMappingIndex(versionMapping);
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementMapping.addParameterOccurrence(param);
                } else {
                    this.versionStatementMapping = null;
                }
            } else if (mappingType == MappingType.DISCRIMINATOR) {
                JavaTypeMapping discrimMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
                if (discrimMapping != null) {
                    String val = discrimMapping.getColumnMapping(0).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(discrimMapping.getColumnMapping(0).getColumn().getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementMapping = new StatementMappingIndex(discrimMapping);
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementMapping.addParameterOccurrence(param);
                } else {
                    this.discriminatorStatementMapping = null;
                }
            } else if (mappingType == MappingType.DATASTORE_ID) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIdDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Column)iterator.next()).getIdentifier().toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                }
            } else if (mappingType == MappingType.EXTERNAL_FK) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKStmtExprIndex);
            } else if (mappingType == MappingType.EXTERNAL_FK_DISCRIMINATOR) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == MappingType.EXTERNAL_INDEX) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalOrderStmtExprIndex);
            } else if (mappingType == MappingType.MULTITENANCY) {
                JavaTypeMapping multitenancyMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
                String val = multitenancyMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(multitenancyMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.multitenancyStatementMapping = new StatementMappingIndex(multitenancyMapping);
                int[] param = new int[]{this.paramIndex++};
                this.multitenancyStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.SOFTDELETE) {
                JavaTypeMapping softDeleteMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false);
                String val = softDeleteMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(softDeleteMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.softDeleteStatementMapping = new StatementMappingIndex(softDeleteMapping);
                int[] param = new int[]{this.paramIndex++};
                this.softDeleteStatementMapping.addParameterOccurrence(param);
            }
        }

        @Override
        public void consumeUnmappedColumn(Column col) {
            if (this.columnNames.length() > 0) {
                this.columnNames.append(',');
                this.columnValues.append(',');
            }
            this.columnNames.append(col.getIdentifier());
            ColumnMetaData colmd = col.getColumnMetaData();
            String value = colmd.getInsertValue();
            if (value != null && value.equalsIgnoreCase("#NULL")) {
                value = null;
            }
            if (MetaDataUtils.isJdbcTypeString((JdbcType)colmd.getJdbcType())) {
                if (value != null) {
                    value = "'" + value + "'";
                } else if (!col.isNullable()) {
                    value = "''";
                }
            }
            this.columnValues.append(value);
        }

        private StatementMappingIndex[] processExternalMapping(JavaTypeMapping mapping, StatementMappingIndex[] fieldStmtExprIndex, StatementMappingIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementMappingIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementMappingIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementMappingIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementMappingIndex(mapping);
            int[] param = new int[mapping.getNumberOfColumnMappings()];
            for (i = 0; i < mapping.getNumberOfColumnMappings(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(mapping.getColumnMapping(i).getColumn().getIdentifier());
                this.columnValues.append(mapping.getColumnMapping(i).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].addParameterOccurrence(param);
            return stmtExprIndex;
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getInsertFieldNumbers() {
            int[] fieldNumbers = new int[this.insertFields.size()];
            for (int i = 0; i < this.insertFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.insertFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getReachableFieldNumbers() {
            int[] fieldNumbers = new int[this.reachableFields.size()];
            for (int i = 0; i < this.reachableFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.reachableFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getRelationFieldNumbers() {
            int[] fieldNumbers = new int[this.relationFields.size()];
            for (int i = 0; i < this.relationFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.relationFields.get(i);
            }
            return fieldNumbers;
        }

        public StatementMappingIndex[] getStatementMappings() {
            return this.statementMappings;
        }

        public StatementMappingIndex[] getReachableStatementMappings() {
            return this.retrievedStatementMappings;
        }

        public StatementMappingIndex getVersionStatementMapping() {
            return this.versionStatementMapping;
        }

        public StatementMappingIndex getDiscriminatorStatementMapping() {
            return this.discriminatorStatementMapping;
        }

        public StatementMappingIndex getMultitenancyStatementMapping() {
            return this.multitenancyStatementMapping;
        }

        public StatementMappingIndex getSoftDeleteStatementMapping() {
            return this.softDeleteStatementMapping;
        }

        public StatementMappingIndex[] getExternalFKStatementMapping() {
            return this.externalFKStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalFKDiscrimStatementMapping() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalOrderStatementMapping() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + InsertRequest.this.table.toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return InsertRequest.this.table.getStoreManager().getDatastoreAdapter().getInsertStatementForNoColumns(InsertRequest.this.table);
        }
    }
}

