/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DynamicSchemaFieldManager
extends AbstractFieldManager {
    RDBMSStoreManager rdbmsMgr;
    ObjectProvider op;
    boolean schemaUpdatesPerformed = false;

    public DynamicSchemaFieldManager(RDBMSStoreManager rdbmsMgr, ObjectProvider op) {
        this.rdbmsMgr = rdbmsMgr;
        this.op = op;
    }

    public boolean hasPerformedSchemaUpdates() {
        return this.schemaUpdatesPerformed;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        DatastoreClass table;
        JavaTypeMapping fieldMapping;
        if (value == null) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd != null && (fieldMapping = (table = this.rdbmsMgr.getDatastoreClass(this.op.getObject().getClass().getName(), clr)).getMemberMapping(mmd)) != null) {
            if (fieldMapping instanceof InterfaceMapping) {
                InterfaceMapping intfMapping = (InterfaceMapping)fieldMapping;
                if (mmd.getFieldTypes() != null || mmd.hasExtension("implementation-classes")) {
                    return;
                }
                this.processInterfaceMappingForValue(intfMapping, value, mmd, ec);
            } else if (mmd.hasCollection() || mmd.hasArray()) {
                boolean hasJoin = false;
                if (mmd.getJoinMetaData() != null) {
                    hasJoin = true;
                } else {
                    AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                    if (relMmds != null && relMmds[0].getJoinMetaData() != null) {
                        hasJoin = true;
                    }
                }
                if (!hasJoin) {
                    return;
                }
                Table joinTbl = fieldMapping.getStoreManager().getTable(mmd);
                ElementContainerTable collTbl = (ElementContainerTable)joinTbl;
                JavaTypeMapping elemMapping = collTbl.getElementMapping();
                if (elemMapping instanceof InterfaceMapping) {
                    InterfaceMapping intfMapping = (InterfaceMapping)elemMapping;
                    if (mmd.hasCollection()) {
                        Collection coll = (Collection)value;
                        if (coll.isEmpty()) {
                            return;
                        }
                        Object elementValue = coll.iterator().next();
                        this.processInterfaceMappingForValue(intfMapping, elementValue, mmd, ec);
                    } else if (mmd.hasArray()) {
                        if (Array.getLength(value) == 0) {
                            return;
                        }
                        Object elementValue = Array.get(value, 0);
                        this.processInterfaceMappingForValue(intfMapping, elementValue, mmd, ec);
                    }
                }
            } else if (mmd.hasMap()) {
                JavaTypeMapping valMapping;
                boolean hasJoin = false;
                if (mmd.getJoinMetaData() != null) {
                    hasJoin = true;
                } else {
                    AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                    if (relMmds != null && relMmds[0].getJoinMetaData() != null) {
                        hasJoin = true;
                    }
                }
                if (!hasJoin) {
                    return;
                }
                Map map = (Map)value;
                if (map.isEmpty()) {
                    return;
                }
                Table joinTbl = fieldMapping.getStoreManager().getTable(mmd);
                MapTable mapTbl = (MapTable)joinTbl;
                JavaTypeMapping keyMapping = mapTbl.getKeyMapping();
                if (keyMapping instanceof InterfaceMapping) {
                    InterfaceMapping intfMapping = (InterfaceMapping)keyMapping;
                    Object keyValue = map.keySet().iterator().next();
                    this.processInterfaceMappingForValue(intfMapping, keyValue, mmd, ec);
                }
                if ((valMapping = mapTbl.getValueMapping()) instanceof InterfaceMapping) {
                    InterfaceMapping intfMapping = (InterfaceMapping)valMapping;
                    Object valValue = map.values().iterator().next();
                    this.processInterfaceMappingForValue(intfMapping, valValue, mmd, ec);
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    protected void processInterfaceMappingForValue(InterfaceMapping intfMapping, Object value, AbstractMemberMetaData mmd, ExecutionContext ec) {
        int intfImplMappingNumber;
        if (intfMapping.getMappingStrategy() == 0 && (intfImplMappingNumber = intfMapping.getMappingNumberForValue(ec, value)) == -1) {
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dynamic schema updates : field=" + mmd.getFullFieldName() + " has an interface mapping yet " + StringUtils.toJVMIDString((Object)value) + " is not a known implementation - trying to update the schema ..."));
            }
            MetaDataManager mmgr = ec.getNucleusContext().getMetaDataManager();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            mmgr.getMetaDataForClass(value.getClass(), clr);
            String[] impls = ec.getMetaDataManager().getClassesImplementingInterface(intfMapping.getType(), clr);
            if (ClassUtils.stringArrayContainsValue((String[])impls, (String)value.getClass().getName())) {
                try {
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Dynamic schema updates : field=" + mmd.getFullFieldName() + " has a new implementation available so reinitialising its mapping"));
                    }
                    intfMapping.initialize(mmd, intfMapping.getTable(), clr);
                    intfMapping.getStoreManager().validateTable((TableImpl)intfMapping.getTable(), clr);
                }
                catch (Exception e) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)"Exception thrown trying to create missing columns for implementation", (Throwable)e);
                    throw new NucleusException("Exception thrown performing dynamic update of schema", (Throwable)e);
                }
                this.schemaUpdatesPerformed = true;
            }
        }
    }
}

