/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKListStore<E>
extends AbstractListStore<E> {
    private String updateFkStmt;
    private String clearNullifyStmt;
    private String removeAtNullifyStmt;
    private String setStmt;
    private String unsetStmt;

    public FKListStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        CollectionMetaData colmd = mmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056001", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.elementIsPersistentInterface = storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(element_class.getName());
            this.elementCmd = this.elementIsPersistentInterface ? storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(element_class, clr) : storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
        } else {
            this.elementCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.elementCmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056003", (Object[])new Object[]{element_class.getName(), mmd.getFullFieldName()}));
        }
        this.elementInfo = this.getComponentInformationForClass(this.elementType, this.elementCmd);
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            throw new NucleusUserException(Localiser.msg((String)"056075", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), this.elementType}));
        }
        if (this.elementInfo.length == 1 && ClassUtils.isReferenceType((Class)element_class)) {
            this.elementType = this.elementCmd.getFullClassName();
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        for (int i = 0; i < this.elementInfo.length; ++i) {
            JavaTypeMapping ownerMapping = null;
            if (mmd.getMappedBy() != null) {
                if (mmd.getMappedBy().indexOf(46) < 0) {
                    AbstractMemberMetaData eofmd = this.elementInfo[i].getAbstractClassMetaData().getMetaDataForMember(mmd.getMappedBy());
                    if (eofmd == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056024", (Object[])new Object[]{mmd.getFullFieldName(), mmd.getMappedBy(), element_class.getName()}));
                    }
                    if (!clr.isAssignableFrom(eofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                        throw new NucleusUserException(Localiser.msg((String)"056025", (Object[])new Object[]{mmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), mmd.getAbstractClassMetaData().getFullClassName()}));
                    }
                    String ownerFieldName = eofmd.getName();
                    ownerMapping = this.elementInfo[i].getDatastoreClass().getMemberMapping(eofmd);
                    if (ownerMapping == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056029", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType, ownerFieldName}));
                    }
                    if (this.isEmbeddedMapping(ownerMapping)) {
                        throw new NucleusUserException(Localiser.msg((String)"056026", (Object[])new Object[]{ownerFieldName, this.elementType, eofmd.getTypeName(), mmd.getClassName()}));
                    }
                } else {
                    AbstractMemberMetaData otherMmd = null;
                    AbstractClassMetaData otherCmd = this.elementCmd;
                    String remainingMappedBy = this.ownerMemberMetaData.getMappedBy();
                    JavaTypeMapping otherMapping = null;
                    while (remainingMappedBy.indexOf(46) > 0) {
                        int dotPosition = remainingMappedBy.indexOf(46);
                        String thisMappedBy = remainingMappedBy.substring(0, dotPosition);
                        otherMmd = otherCmd.getMetaDataForMember(thisMappedBy);
                        if (otherMapping == null) {
                            otherMapping = this.elementInfo[i].getDatastoreClass().getMemberMapping(thisMappedBy);
                        } else {
                            if (!(otherMapping instanceof EmbeddedPCMapping)) {
                                throw new NucleusUserException("Processing of mappedBy DOT notation for " + this.ownerMemberMetaData.getFullFieldName() + " found mapping=" + otherMapping + " but expected to be embedded");
                            }
                            otherMapping = ((EmbeddedPCMapping)otherMapping).getJavaTypeMapping(thisMappedBy);
                        }
                        remainingMappedBy = remainingMappedBy.substring(dotPosition + 1);
                        otherCmd = storeMgr.getMetaDataManager().getMetaDataForClass(otherMmd.getTypeName(), clr);
                        if (remainingMappedBy.indexOf(46) >= 0) continue;
                        if (!(otherMapping instanceof EmbeddedPCMapping)) {
                            throw new NucleusUserException("Processing of mappedBy DOT notation for " + this.ownerMemberMetaData.getFullFieldName() + " found mapping=" + otherMapping + " but expected to be embedded");
                        }
                        otherMapping = ((EmbeddedPCMapping)otherMapping).getJavaTypeMapping(remainingMappedBy);
                    }
                    ownerMapping = otherMapping;
                }
            } else {
                ownerMapping = this.elementInfo[i].getDatastoreClass().getExternalMapping(mmd, 5);
                if (ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056030", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
                }
            }
            this.elementInfo[i].setOwnerMapping(ownerMapping);
        }
        this.ownerMapping = this.elementInfo[0].getOwnerMapping();
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.indexedList) {
            this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 4);
            if (this.orderMapping == null) {
                throw new NucleusUserException(Localiser.msg((String)"056041", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
            }
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.containerTable) {
            this.containerTable = this.ownerMapping.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E set(ObjectProvider op, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(op, element, -1);
        Object oldElement = this.get(op, index);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String unsetStmt = this.getUnsetStmt();
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    if (this.orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, unsetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
                String setStmt = this.getSetStmt(element);
                try (PreparedStatement ps2 = sqlControl.getStatementForUpdate(mconn, setStmt, false);){
                    ComponentInfo elemInfo = this.getComponentInfoForElement(element);
                    JavaTypeMapping elemMapping = this.elementMapping;
                    JavaTypeMapping orderMapping = this.orderMapping;
                    if (elemInfo != null) {
                        elemMapping = elemInfo.getDatastoreClass().getIdMapping();
                        orderMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 4);
                    }
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps2, jdbcPosition, this);
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps2, index, jdbcPosition, orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps2, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps2, element, jdbcPosition, elemMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, setStmt, ps2, true);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056015", (Object[])new Object[]{this.setStmt}), (Throwable)e);
        }
        boolean dependent = this.getOwnerMemberMetaData().getCollection().isDependentElement();
        if (this.getOwnerMemberMetaData().isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && allowDependentField && oldElement != null) {
            op.getExecutionContext().deleteObjectInternal(oldElement);
        }
        return oldElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(ObjectProvider op, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ExecutionContext ec = op.getExecutionContext();
        String updateFkStmt = this.getUpdateFkStmt(element);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    ComponentInfo elemInfo = this.getComponentInfoForElement(element);
                    JavaTypeMapping ownerMapping = elemInfo.getOwnerMapping();
                    JavaTypeMapping elemMapping = elemInfo.getDatastoreClass().getIdMapping();
                    JavaTypeMapping orderMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 4);
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, ownerMapping), null, op, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, ownerMapping), null);
                        }
                        jdbcPosition += ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    }
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, elemMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056027", (Object[])new Object[]{updateFkStmt}), (Throwable)e);
        }
        return retval;
    }

    @Override
    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(op);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.equals(coll)) {
            return;
        }
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalAdd(ObjectProvider op, int startAt, boolean atEnd, Collection<E> c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = size < 0 ? this.size(op) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator<E> elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(op, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                int shift = c.size();
                ExecutionContext ec = op.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.internalShift(op, mconn, true, i, shift, false);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{e.getMessage()}), e.getCause());
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            for (E element : c) {
                this.updateElementFk(op, element, op.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        if (this.indexedList) {
            int[] indices = this.getIndicesOf(op, elements);
            if (indices == null) {
                return false;
            }
            for (int i = 0; i < indices.length; ++i) {
                this.internalRemoveAt(op, indices[i], -1);
                modified = true;
            }
            boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
            if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
                dependent = true;
            }
            if (dependent) {
                op.getExecutionContext().deleteObjects(elements.toArray());
            }
        } else {
            for (Object element : elements) {
                this.remove(op, element, size, true);
            }
        }
        return modified;
    }

    @Override
    protected boolean internalRemove(ObjectProvider op, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(op, element);
            if (index == -1) {
                return false;
            }
            this.internalRemoveAt(op, index, size);
        } else if (this.ownerMapping.isNullable()) {
            ExecutionContext ec = op.getExecutionContext();
            ObjectProvider elementSM = ec.findObjectProvider(element);
            if (this.relationType == RelationType.ONE_TO_MANY_BI) {
                elementSM.replaceFieldMakeDirty(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null);
                if (op.getExecutionContext().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(op, element, null, -1);
            }
        } else {
            op.getExecutionContext().deleteObjectInternal(element);
        }
        return true;
    }

    protected void manageRemovalOfElement(ObjectProvider ownerOP, Object element) {
    }

    @Override
    protected void internalRemoveAt(ObjectProvider op, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        boolean nullify = false;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056043"));
            nullify = true;
        } else {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056042"));
        }
        String stmt = nullify ? this.getRemoveAtNullifyStmt() : this.getRemoveAtStmt();
        this.internalRemoveAt(op, index, stmt, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(ObjectProvider op) {
        boolean deleteElements = false;
        ExecutionContext ec = op.getExecutionContext();
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056036"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            Iterator elementsIter = this.iterator(op);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                        ObjectProvider objSM = ec.findObjectProvider(element);
                        objSM.flush();
                        continue;
                    }
                    ec.deleteObjectInternal(element);
                }
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        if (this.relationDiscriminatorMapping != null) {
                            BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        sqlControl.executeStatementUpdate(ec, mconn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearNullifyStmt}), (Throwable)e);
            }
        }
    }

    protected boolean validateElementForWriting(final ObjectProvider op, Object element, final int index) {
        final Object newOwner = op.getObject();
        final ComponentInfo info = this.getComponentInfoForElement(element);
        final DatastoreClass elementTable = this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(this.elementType) ? this.storeMgr.getDatastoreClass(this.storeMgr.getNucleusContext().getMetaDataManager().getImplementationNameForPersistentInterface(this.elementType), this.clr) : this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
        final JavaTypeMapping orderMapping = info != null ? info.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 4) : this.orderMapping;
        boolean inserted = super.validateElementForWriting(op.getExecutionContext(), element, new FieldValues(){

            public void fetchFields(ObjectProvider elemOP) {
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        elemOP.setAssociatedValue((Object)externalFKMapping, op.getObject());
                    }
                    if (FKListStore.this.relationDiscriminatorMapping != null) {
                        elemOP.setAssociatedValue((Object)FKListStore.this.relationDiscriminatorMapping, (Object)FKListStore.this.relationDiscriminatorValue);
                    }
                    if (orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)Long.valueOf(index) : (Number)index;
                            elemOP.replaceFieldMakeDirty(orderMapping.getMemberMetaData().getAbsoluteFieldNumber(), (Object)indexValue);
                        } else {
                            elemOP.setAssociatedValue((Object)orderMapping, (Object)index);
                        }
                    }
                }
                if (FKListStore.this.ownerMemberMetaData.getMappedBy() != null) {
                    Object currentOwner;
                    ObjectProvider ownerHolderOP = elemOP;
                    int ownerFieldNumberInHolder = -1;
                    if (FKListStore.this.ownerMemberMetaData.getMappedBy().indexOf(46) > 0) {
                        AbstractMemberMetaData otherMmd = null;
                        AbstractClassMetaData otherCmd = info.getAbstractClassMetaData();
                        String remainingMappedBy = FKListStore.this.ownerMemberMetaData.getMappedBy();
                        while (remainingMappedBy.indexOf(46) > 0) {
                            int dotPosition = remainingMappedBy.indexOf(46);
                            String thisMappedBy = remainingMappedBy.substring(0, dotPosition);
                            otherMmd = otherCmd.getMetaDataForMember(thisMappedBy);
                            Object holderValueAtField = ownerHolderOP.provideField(otherMmd.getAbsoluteFieldNumber());
                            ownerHolderOP = op.getExecutionContext().findObjectProviderForEmbedded(holderValueAtField, ownerHolderOP, otherMmd);
                            remainingMappedBy = remainingMappedBy.substring(dotPosition + 1);
                            otherCmd = FKListStore.this.storeMgr.getMetaDataManager().getMetaDataForClass(otherMmd.getTypeName(), FKListStore.this.clr);
                            if (remainingMappedBy.indexOf(46) >= 0) continue;
                            otherMmd = otherCmd.getMetaDataForMember(remainingMappedBy);
                            ownerFieldNumberInHolder = otherMmd.getAbsoluteFieldNumber();
                        }
                    } else {
                        ownerFieldNumberInHolder = info.getAbstractClassMetaData().getAbsolutePositionOfMember(FKListStore.this.ownerMemberMetaData.getMappedBy());
                    }
                    if ((currentOwner = ownerHolderOP.provideField(ownerFieldNumberInHolder)) == null) {
                        NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"056037", (Object[])new Object[]{op.getObjectAsPrintable(), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)ownerHolderOP.getObject())}));
                        ownerHolderOP.replaceFieldMakeDirty(ownerFieldNumberInHolder, newOwner);
                    } else if (currentOwner != newOwner && op.getReferencedPC() == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056038", (Object[])new Object[]{op.getObjectAsPrintable(), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)ownerHolderOP.getObject()), StringUtils.toJVMIDString((Object)currentOwner)}));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider op2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ListIterator<E> listIterator(ObjectProvider ownerOP, int startIdx, int endIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateFkStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getUpdateFkStatementString(element);
        }
        if (this.updateFkStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                this.updateFkStmt = this.getUpdateFkStatementString(element);
            }
        }
        return this.updateFkStmt;
    }

    private String getUpdateFkStatementString(Object element) {
        int i;
        ComponentInfo elemInfo;
        JavaTypeMapping ownerMapping = this.ownerMapping;
        JavaTypeMapping elemMapping = this.elementMapping;
        JavaTypeMapping orderMapping = this.orderMapping;
        JavaTypeMapping relDiscrimMapping = this.relationDiscriminatorMapping;
        Table table = this.containerTable;
        if (this.elementInfo.length > 1 && (elemInfo = this.getComponentInfoForElement(element)) != null) {
            table = elemInfo.getDatastoreClass();
            ownerMapping = elemInfo.getOwnerMapping();
            elemMapping = elemInfo.getDatastoreClass().getIdMapping();
            orderMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 4);
            relDiscrimMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 6);
        }
        StringBuilder stmt = new StringBuilder("UPDATE ").append(table.toString()).append(" SET ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append("=");
            stmt.append(((AbstractDatastoreMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (orderMapping != null) {
            for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((AbstractDatastoreMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        if (relDiscrimMapping != null) {
            for (i = 0; i < relDiscrimMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(relDiscrimMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((AbstractDatastoreMapping)relDiscrimMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForElement(stmt, elemMapping, element, this.elementsAreSerialised, null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.containerTable.toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + "=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + "=-1");
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.clearNullifyStmt = stmt.toString();
            }
        }
        return this.clearNullifyStmt;
    }

    private String getSetStmt(Object element) {
        if (this.setStmt != null) {
            return this.setStmt;
        }
        String stmt = this.getSetStatementString(element);
        if (this.elementInfo.length == 1) {
            this.setStmt = stmt;
        }
        return stmt;
    }

    private String getSetStatementString(Object element) {
        int i;
        ComponentInfo elemInfo = this.getComponentInfoForElement(element);
        Table table = this.containerTable;
        JavaTypeMapping ownerMapping = this.ownerMapping;
        JavaTypeMapping elemMapping = this.elementMapping;
        JavaTypeMapping relDiscrimMapping = this.relationDiscriminatorMapping;
        JavaTypeMapping orderMapping = this.orderMapping;
        if (elemInfo != null) {
            table = elemInfo.getDatastoreClass();
            elemMapping = elemInfo.getDatastoreClass().getIdMapping();
            ownerMapping = elemInfo.getOwnerMapping();
            orderMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 4);
            relDiscrimMapping = elemInfo.getDatastoreClass().getExternalMapping(this.ownerMemberMetaData, 6);
        }
        StringBuilder stmt = new StringBuilder("UPDATE ").append(table.toString()).append(" SET ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((AbstractDatastoreMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (orderMapping != null) {
            for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        if (relDiscrimMapping != null) {
            for (i = 0; i < relDiscrimMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(relDiscrimMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)relDiscrimMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForElement(stmt, elemMapping, element, this.isElementsAreSerialised(), null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnsetStmt() {
        if (this.unsetStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                stmt.append(this.containerTable.toString());
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append("=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=-1");
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append(" = NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.unsetStmt = stmt.toString();
            }
        }
        return this.unsetStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveAtNullifyStmt() {
        if (this.removeAtNullifyStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.containerTable.toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append("=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=-1");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.removeAtNullifyStmt = stmt.toString();
            }
        }
        return this.removeAtNullifyStmt;
    }

    public IteratorStatement getIteratorStatement(ExecutionContext ec, FetchPlan fp, boolean addRestrictionOnOwner, int startIdx, int endIdx) {
        SQLExpression[] orderExprs;
        SQLStatement sqlStmt = null;
        StatementClassMapping stmtClassMapping = new StatementClassMapping();
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getCollection().getElementType();
            if (ClassUtils.isReferenceType((Class)this.clr.classForName(elementType))) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, this.clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = this.clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, cls, true, null, null).getStatement(ec);
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, this.clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement(ec);
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement((SelectStatement)sqlStmt, stmtClassMapping, fp, sqlStmt.getPrimaryTable(), this.elementCmd, fp.getMaxFetchDepth());
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = this.clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null);
                stmtGen.setOption("selectDnType");
                stmtClassMapping.setNucleusTypeColumnName("DN_TYPE");
                SelectStatement subStmt = stmtGen.getStatement(ec);
                if (sqlStmt == null) {
                    if (this.elementInfo.length > 1) {
                        SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, stmtClassMapping, this.elementInfo[i].getAbstractClassMetaData());
                    } else {
                        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, stmtClassMapping, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), fp.getMaxFetchDepth());
                    }
                } else if (this.elementInfo.length > 1) {
                    SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, null, this.elementInfo[i].getAbstractClassMetaData());
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), fp.getMaxFetchDepth());
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                ((SelectStatement)sqlStmt).union(subStmt);
            }
            if (sqlStmt == null) {
                throw new NucleusException("Unable to generate iterator statement for field=" + this.getOwnerMemberMetaData().getFullFieldName());
            }
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            ((SelectStatement)sqlStmt).whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            ((SelectStatement)sqlStmt).whereAnd(distExpr.eq(distVal), true);
        }
        if (this.indexedList) {
            SQLExpression indexVal;
            SQLExpression indexExpr;
            boolean needsOrdering = true;
            if (startIdx == -1 && endIdx == -1) {
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                ((SelectStatement)sqlStmt).whereAnd(indexExpr.ge(indexVal), true);
            } else if (startIdx >= 0 && endIdx == startIdx) {
                needsOrdering = false;
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                ((SelectStatement)sqlStmt).whereAnd(indexExpr.eq(indexVal), true);
            } else {
                if (startIdx >= 0) {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                    ((SelectStatement)sqlStmt).whereAnd(indexExpr.ge(indexVal), true);
                } else {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                    ((SelectStatement)sqlStmt).whereAnd(indexExpr.ge(indexVal), true);
                }
                if (endIdx >= 0) {
                    SQLExpression indexExpr2 = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    SQLExpression indexVal2 = exprFactory.newLiteral(sqlStmt, this.orderMapping, endIdx);
                    ((SelectStatement)sqlStmt).whereAnd(indexExpr2.lt(indexVal2), true);
                }
            }
            if (needsOrdering) {
                SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
                orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
                ((SelectStatement)sqlStmt).setOrdering(orderExprs, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            orderExprs = new SQLExpression[orderComponents.length];
            boolean[] orderDirs = new boolean[orderComponents.length];
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getMemberMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                orderDirs[i] = !orderComponents[i].isForward();
                SQLTable fieldSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), fieldMapping);
                orderExprs[i] = exprFactory.newExpression(sqlStmt, fieldSqlTbl, fieldMapping);
            }
            ((SelectStatement)sqlStmt).setOrdering(orderExprs, orderDirs);
        }
        return new IteratorStatement(this, (SelectStatement)sqlStmt, stmtClassMapping);
    }
}

