/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.util.Localiser;

public abstract class AbstractCollectionStore
extends ElementContainerStore
implements CollectionStore {
    protected String containsStmt;

    protected AbstractCollectionStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public boolean updateEmbeddedElement(ObjectProvider op, Object element, int fieldNumber, Object value) {
        boolean modified = false;
        if (this.elementMapping != null && this.elementMapping instanceof EmbeddedElementPCMapping) {
            String fieldName = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedElementPCMapping)this.elementMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.updateEmbeddedElement(op, element, fieldNumber, value, fieldMapping);
        }
        return modified;
    }

    public void update(ObjectProvider op, Collection coll) {
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    public boolean contains(ObjectProvider op, Object element) {
        if (!this.validateElementForReading(op, element)) {
            return false;
        }
        return this.containsInternal(op, element);
    }

    protected String getUpdateEmbeddedElementStmt(JavaTypeMapping fieldMapping) {
        JavaTypeMapping ownerMapping = this.getOwnerMapping();
        Table containerTable = this.getContainerTable();
        JavaTypeMapping elementMapping = this.getElementMapping();
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(containerTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < fieldMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((AbstractDatastoreMapping)fieldMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, null, true);
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreMappings(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)m.getDatastoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedElement(ObjectProvider op, Object element, int fieldNumber, Object value, JavaTypeMapping fieldMapping) {
        boolean modified = false;
        String stmt = this.getUpdateEmbeddedElementStmt(fieldMapping);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    fieldMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, fieldMapping), value);
                    jdbcPosition += fieldMapping.getNumberOfDatastoreMappings();
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateEmbeddedElementFieldsInStatement(op, element, ps, jdbcPosition, ((JoinTable)this.getContainerTable()).getOwnerMemberMetaData(), this.getElementMapping(), this.getEmd(), this);
                    sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                    modified = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContainsStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getContainsStatementString(element);
        }
        if (this.containsStmt == null) {
            AbstractCollectionStore abstractCollectionStore = this;
            synchronized (abstractCollectionStore) {
                this.containsStmt = this.getContainsStatementString(element);
            }
        }
        return this.containsStmt;
    }

    private String getContainsStatementString(Object element) {
        JavaTypeMapping discrimMapping;
        JavaTypeMapping ownerMapping = this.getOwnerMapping();
        Table containerTable = this.getContainerTable();
        boolean elementsAreSerialised = this.isElementsAreSerialised();
        JavaTypeMapping elementMapping = this.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = this.getElementInfo();
        StringBuilder stmt = new StringBuilder("SELECT ");
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        for (int i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.getContainerTable().toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, containerAlias, true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, elementMapping, element, elementsAreSerialised, containerAlias, false);
        JavaTypeMapping javaTypeMapping = discrimMapping = elementInfo != null ? elementInfo[0].getDiscriminatorMapping() : null;
        if (elementInfo != null && containerTable == elementInfo[0].getDatastoreClass() && discrimMapping != null) {
            StringBuilder discrimStr = new StringBuilder();
            Collection subclasses = this.storeMgr.getSubClassesForClass(elementInfo[0].getClassName(), true, this.clr);
            for (String subclass : subclasses) {
                Class cls = this.clr.classForName(subclass);
                if (Modifier.isAbstract(cls.getModifiers())) continue;
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (discrimStr.length() > 0) {
                        discrimStr.append(" OR ");
                    }
                    if (joinedDiscrim) {
                        discrimStr.append(joinedElementAlias);
                    } else {
                        discrimStr.append(containerAlias);
                    }
                    discrimStr.append(".").append(discrimMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                    discrimStr.append(" = ");
                    discrimStr.append(((AbstractDatastoreMapping)discrimMapping.getDatastoreMapping(j)).getUpdateInputParameter());
                }
            }
            if (discrimStr.length() > 0) {
                stmt.append(" AND (").append(discrimStr.toString()).append(")");
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsInternal(ObjectProvider op, Object element) {
        boolean retval;
        Table containerTable = this.getContainerTable();
        JavaTypeMapping elementMapping = this.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = this.getElementInfo();
        String stmt = this.getContainsStmt(element);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, elementMapping);
                    if (elementInfo != null && elementInfo[0].getDiscriminatorMapping() != null && elementInfo[0].getDatastoreClass() == containerTable) {
                        jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(ec, ps, jdbcPosition, true, elementInfo[0], this.clr);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                        retval = rs.next();
                        JDBCUtils.logWarnings(rs);
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056008", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] internalRemove(ObjectProvider op, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt(element);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
            jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
            }
            nArray = sqlControl.executeStatementUpdate(ec, conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new MappedDatastoreException("SQLException", sqle);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRemoveStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getRemoveStatementString(element);
        }
        if (this.removeStmt == null) {
            AbstractCollectionStore abstractCollectionStore = this;
            synchronized (abstractCollectionStore) {
                this.removeStmt = this.getRemoveStatementString(element);
            }
        }
        return this.removeStmt;
    }

    private String getRemoveStatementString(Object element) {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, this.containerTable.toString(), true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, this.containerTable.toString(), false);
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, this.containerTable.toString(), false);
        }
        return stmt.toString();
    }
}

