/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EnumMapping
extends SingleFieldMapping {
    protected static final String ENUM_VALUE_GETTER = "enum-value-getter";
    protected static final String ENUM_GETTER_BY_VALUE = "enum-getter-by-value";
    protected String datastoreJavaType = ClassNameConstants.JAVA_LANG_STRING;

    @Override
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        ColumnMetaData[] colmds;
        if (fmd != null && fmd.isSerialized()) {
            this.datastoreJavaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
        } else if (fmd != null && (colmds = EnumMapping.getColumnMetaDataForMember(fmd, this.roleForMember)) != null && colmds.length > 0 && MetaDataUtils.isJdbcTypeNumeric((JdbcType)colmds[0].getJdbcType())) {
            this.datastoreJavaType = ClassNameConstants.JAVA_LANG_INTEGER;
        }
        super.initialize(fmd, table, clr);
    }

    @Override
    public Object[] getValidValues(int index) {
        if (this.mmd != null && this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0 && this.mmd.getColumnMetaData()[0].hasExtension("enum-check-constraint") && this.mmd.getColumnMetaData()[0].getValueForExtension("enum-check-constraint").equalsIgnoreCase("true")) {
            try {
                Enum[] values = (Enum[])this.mmd.getType().getMethod("values", null).invoke((Object)null, (Object[])null);
                if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
                    Object[] valueStrings = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        valueStrings[i] = values[i].toString();
                    }
                    return valueStrings;
                }
                Object[] valueInts = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueInts[i] = values[i].ordinal();
                }
                return valueInts;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn((Object)StringUtils.getStringFromStackTrace((Throwable)e));
            }
        }
        return super.getValidValues(index);
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return this.datastoreJavaType;
    }

    @Override
    public Class getJavaType() {
        return Enum.class;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            if (value instanceof Enum) {
                String getterMethodName;
                Long longVal;
                int intVal = ((Enum)value).ordinal();
                String methodName = null;
                if (this.roleForMember == FieldRole.ROLE_FIELD) {
                    if (this.mmd != null && this.mmd.hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT || this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT) {
                    if (this.mmd != null && this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_MAP_KEY) {
                    if (this.mmd != null && this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getKeyMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_MAP_VALUE && this.mmd != null && this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                    methodName = this.mmd.getValueMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                }
                if (methodName != null && (longVal = this.getValueForEnumUsingMethod((Enum)value, getterMethodName = this.mmd.getValueForExtension(ENUM_VALUE_GETTER))) != null) {
                    intVal = longVal.intValue();
                }
                this.getDatastoreMapping(0).setInt(ps, exprIndex[0], intVal);
            } else if (value instanceof BigInteger) {
                this.getDatastoreMapping(0).setInt(ps, exprIndex[0], ((BigInteger)value).intValue());
            }
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = value instanceof String ? (String)value : ((Enum)value).name();
            this.getDatastoreMapping(0).setString(ps, exprIndex[0], stringVal);
        } else {
            super.setObject(ec, ps, exprIndex, value);
        }
    }

    protected Long getValueForEnumUsingMethod(Enum value, String methodName) {
        try {
            Method getterMethod = ClassUtils.getMethodForClass(value.getClass(), (String)methodName, null);
            Number num = (Number)getterMethod.invoke((Object)value, null);
            return num.longValue();
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.warn((Object)("Specified enum value-getter for method " + methodName + " on field " + this.mmd.getFullFieldName() + " gave an error on extracting the value : " + e.getMessage()));
            return null;
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            long longVal = this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = ec.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == FieldRole.ROLE_FIELD && this.mmd.hasExtension(ENUM_GETTER_BY_VALUE)) {
                    String getterMethodName = this.mmd.getValueForExtension(ENUM_GETTER_BY_VALUE);
                    return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                }
                if (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                    if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                    if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_MAP_KEY) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                    if (this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getKeyMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == FieldRole.ROLE_MAP_VALUE) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                    if (this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getValueMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                }
            }
            return enumType.getEnumConstants()[(int)longVal];
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = ec.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == FieldRole.ROLE_COLLECTION_ELEMENT) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                } else if (this.roleForMember == FieldRole.ROLE_ARRAY_ELEMENT) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                } else if (this.roleForMember == FieldRole.ROLE_MAP_KEY) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                } else if (this.roleForMember == FieldRole.ROLE_MAP_VALUE) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                }
            }
            return Enum.valueOf(enumType, stringVal);
        }
        return super.getObject(ec, resultSet, exprIndex);
    }

    protected Object getEnumValueForMethod(Class enumType, long val, String methodName) {
        try {
            Method getterMethod = ClassUtils.getMethodForClass((Class)enumType, (String)methodName, (Class[])new Class[]{Short.TYPE});
            return getterMethod.invoke(null, (short)val);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.warn((Object)("Specified enum getter-by-value for field " + this.mmd.getFullFieldName() + " gave an error on extracting the enum so just using the ordinal : " + e.getMessage()));
            try {
                Method getterMethod = ClassUtils.getMethodForClass((Class)enumType, (String)methodName, (Class[])new Class[]{Integer.TYPE});
                return getterMethod.invoke(null, (int)val);
            }
            catch (Exception e2) {
                NucleusLogger.PERSISTENCE.warn((Object)("Specified enum getter-by-value for field " + this.mmd.getFullFieldName() + " gave an error on extracting the enum so just using the ordinal : " + e2.getMessage()));
                return null;
            }
        }
    }
}

