/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;

public class TypeConverterMapping
extends SingleFieldMapping {
    TypeConverter converter;

    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        this.converter = storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fieldType);
        if (this.converter == null) {
            throw new NucleusUserException("Unable to find TypeConverter for converting " + fieldType + " to String");
        }
        super.initialize(storeMgr, type);
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.initialize(mmd, table, clr, null);
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, TypeConverter conv) {
        if (mmd.getTypeConverterName() != null) {
            this.converter = table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
        } else if (conv != null) {
            this.converter = conv;
        } else {
            throw new NucleusUserException("Unable to initialise mapping of type " + this.getClass().getName() + " for field " + mmd.getFullFieldName() + " since no TypeConverter was provided");
        }
        super.initialize(mmd, table, clr);
    }

    public TypeConverter getTypeConverter() {
        return this.converter;
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)this.getJavaType()).getName();
    }

    @Override
    public Class getJavaType() {
        return this.mmd != null ? this.mmd.getType() : this.storeMgr.getNucleusContext().getClassLoaderResolver(null).classForName(this.type);
    }

    @Override
    public void setBoolean(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, boolean value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setBoolean(ps, exprIndex[0], (Boolean)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public boolean getBoolean(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return false;
        }
        Boolean datastoreValue = this.getDatastoreMapping(0).getBoolean(resultSet, exprIndex[0]);
        return (Boolean)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setByte(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, byte value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setByte(ps, exprIndex[0], (Byte)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public byte getByte(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Byte datastoreValue = this.getDatastoreMapping(0).getByte(resultSet, exprIndex[0]);
        return (Byte)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setChar(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, char value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setChar(ps, exprIndex[0], ((Character)this.converter.toDatastoreType((Object)Character.valueOf(value))).charValue());
    }

    @Override
    public char getChar(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return '\u0000';
        }
        Character datastoreValue = Character.valueOf(this.getDatastoreMapping(0).getChar(resultSet, exprIndex[0]));
        return ((Character)this.converter.toMemberType((Object)datastoreValue)).charValue();
    }

    @Override
    public void setDouble(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, double value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setDouble(ps, exprIndex[0], (Double)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public double getDouble(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0;
        }
        Double datastoreValue = this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0]);
        return (Double)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setFloat(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, float value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setFloat(ps, exprIndex[0], ((Float)this.converter.toDatastoreType((Object)Float.valueOf(value))).floatValue());
    }

    @Override
    public float getFloat(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0f;
        }
        Float datastoreValue = Float.valueOf(this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]));
        return ((Float)this.converter.toMemberType((Object)datastoreValue)).floatValue();
    }

    @Override
    public void setInt(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, int value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setInt(ps, exprIndex[0], (Integer)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public int getInt(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Integer datastoreValue = this.getDatastoreMapping(0).getInt(resultSet, exprIndex[0]);
        return (Integer)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setLong(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, long value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setLong(ps, exprIndex[0], (Long)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public long getLong(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0L;
        }
        Long datastoreValue = this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0]);
        return (Long)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setShort(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, short value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setShort(ps, exprIndex[0], (Short)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public short getShort(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Short datastoreValue = this.getDatastoreMapping(0).getShort(resultSet, exprIndex[0]);
        return (Short)this.converter.toMemberType((Object)datastoreValue);
    }

    @Override
    public void setString(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, String value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setString(ps, exprIndex[0], (String)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public String getString(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        String datastoreValue = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
        return datastoreValue != null ? (String)this.converter.toMemberType((Object)datastoreValue) : null;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setObject(ps, exprIndex[0], this.converter.toDatastoreType(value));
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        return datastoreValue != null ? this.converter.toMemberType(datastoreValue) : null;
    }
}

