/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.key;

import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.key.Key;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;

public class ForeignKey
extends Key {
    private boolean initiallyDeferred;
    private DatastoreClass refTable;
    private DatastoreAdapter dba;
    private FKAction updateAction;
    private FKAction deleteAction;
    private ArrayList refColumns = new ArrayList();

    public ForeignKey(boolean initiallyDeferred) {
        super(null);
        this.initiallyDeferred = initiallyDeferred;
        this.refTable = null;
        this.dba = null;
    }

    public ForeignKey(JavaTypeMapping mapping, DatastoreAdapter dba, DatastoreClass refTable, boolean initiallyDeferred) {
        super(mapping.getTable());
        this.initiallyDeferred = initiallyDeferred;
        this.refTable = refTable;
        this.dba = dba;
        if (refTable.getIdMapping() == null) {
            throw new NucleusException("ForeignKey ID mapping is not initilized for " + mapping + ". Table referenced: " + ((Object)refTable).toString()).setFatal();
        }
        for (int i = 0; i < refTable.getIdMapping().getNumberOfDatastoreMappings(); ++i) {
            this.setColumn(i, mapping.getDatastoreMapping(i).getColumn(), refTable.getIdMapping().getDatastoreMapping(i).getColumn());
        }
    }

    public void setForMetaData(ForeignKeyMetaData fkmd) {
        ForeignKeyAction updateAction;
        ForeignKeyAction deleteAction;
        if (fkmd == null) {
            return;
        }
        if (fkmd.getName() != null) {
            this.setName(fkmd.getName());
        }
        if ((deleteAction = fkmd.getDeleteAction()) != null) {
            if (deleteAction.equals((Object)ForeignKeyAction.CASCADE)) {
                this.setDeleteAction(FKAction.CASCADE);
            } else if (deleteAction.equals((Object)ForeignKeyAction.RESTRICT)) {
                this.setDeleteAction(FKAction.RESTRICT);
            } else if (deleteAction.equals((Object)ForeignKeyAction.NULL)) {
                this.setDeleteAction(FKAction.NULL);
            } else if (deleteAction.equals((Object)ForeignKeyAction.DEFAULT)) {
                this.setDeleteAction(FKAction.DEFAULT);
            }
        }
        if ((updateAction = fkmd.getUpdateAction()) != null) {
            if (updateAction.equals((Object)ForeignKeyAction.CASCADE)) {
                this.setUpdateAction(FKAction.CASCADE);
            } else if (updateAction.equals((Object)ForeignKeyAction.RESTRICT)) {
                this.setUpdateAction(FKAction.RESTRICT);
            } else if (updateAction.equals((Object)ForeignKeyAction.NULL)) {
                this.setUpdateAction(FKAction.NULL);
            } else if (updateAction.equals((Object)ForeignKeyAction.DEFAULT)) {
                this.setUpdateAction(FKAction.DEFAULT);
            }
        }
        if (fkmd.isDeferred()) {
            this.initiallyDeferred = true;
        }
    }

    public Table getReferredTable() {
        return this.refTable;
    }

    public FKAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(FKAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public FKAction getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(FKAction updateAction) {
        this.updateAction = updateAction;
    }

    public void addColumn(Column col, Column refCol) {
        this.setColumn(this.columns.size(), col, refCol);
    }

    public void setColumn(int seq, Column col, Column refCol) {
        if (this.table == null) {
            this.table = col.getTable();
            this.refTable = (DatastoreClass)refCol.getTable();
            this.dba = this.table.getStoreManager().getDatastoreAdapter();
        } else {
            if (!this.table.equals(col.getTable())) {
                throw new NucleusException("Cannot add " + col + " as FK column for " + this.table).setFatal();
            }
            if (!this.refTable.equals(refCol.getTable())) {
                throw new NucleusException("Cannot add " + refCol + " as referenced FK column for " + this.refTable).setFatal();
            }
        }
        ForeignKey.setMinSize(this.columns, seq + 1);
        ForeignKey.setMinSize(this.refColumns, seq + 1);
        this.columns.set(seq, col);
        this.refColumns.set(seq, refCol);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.refColumns.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ForeignKey)) {
            return false;
        }
        ForeignKey fk = (ForeignKey)obj;
        if (!this.refColumns.equals(fk.refColumns)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("FOREIGN KEY ");
        s.append(ForeignKey.getColumnList(this.columns));
        if (this.refTable != null) {
            s.append(" REFERENCES ");
            s.append(((Object)this.refTable).toString());
            s.append(" ").append(ForeignKey.getColumnList(this.refColumns));
        }
        if (this.deleteAction != null && (this.deleteAction == FKAction.CASCADE && this.dba.supportsOption("FkDeleteActionCascade") || this.deleteAction == FKAction.RESTRICT && this.dba.supportsOption("FkDeleteActionRestrict") || this.deleteAction == FKAction.NULL && this.dba.supportsOption("FkDeleteActionNull") || this.deleteAction == FKAction.DEFAULT && this.dba.supportsOption("FkDeleteActionDefault"))) {
            s.append(" ON DELETE ").append(this.deleteAction.toString());
        }
        if (this.updateAction != null && (this.updateAction == FKAction.CASCADE && this.dba.supportsOption("FkUpdateActionCascade") || this.updateAction == FKAction.RESTRICT && this.dba.supportsOption("FkUpdateActionRestrict") || this.updateAction == FKAction.NULL && this.dba.supportsOption("FkUpdateActionNull") || this.updateAction == FKAction.DEFAULT && this.dba.supportsOption("FkUpdateActionDefault"))) {
            s.append(" ON UPDATE ").append(this.updateAction.toString());
        }
        if (this.initiallyDeferred && this.dba.supportsOption("DeferredConstraints")) {
            s.append(" INITIALLY DEFERRED");
        }
        s.append(" ");
        return s.toString();
    }

    public static enum FKAction {
        CASCADE("CASCADE"),
        RESTRICT("RESTRICT"),
        NULL("SET NULL"),
        DEFAULT("SET DEFAULT");

        String keyword;

        private FKAction(String word) {
            this.keyword = word;
        }

        public String toString() {
            return this.keyword;
        }
    }
}

