/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDBCUtils {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private static Map<Integer, String> supportedJdbcTypesById = new HashMap<Integer, String>();
    private static Map<Integer, String> unsupportedJdbcTypesById = new HashMap<Integer, String>();

    public static String getNameForJDBCType(int jdbcType) {
        String typeName = supportedJdbcTypesById.get(jdbcType);
        if (typeName == null) {
            typeName = unsupportedJdbcTypesById.get(jdbcType);
        }
        return typeName;
    }

    public static int getJDBCTypeForName(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Set<Map.Entry<Integer, String>> entries = supportedJdbcTypesById.entrySet();
        for (Map.Entry<Integer, String> entry : entries) {
            if (!typeName.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        return 0;
    }

    public static String getSubprotocolForURL(String url) {
        StringTokenizer tokeniser = new StringTokenizer(url, ":");
        tokeniser.nextToken();
        return tokeniser.nextToken();
    }

    public static void logWarnings(SQLWarning warning) {
        while (warning != null) {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("052700", (Object)warning.getMessage()));
            warning = warning.getNextWarning();
        }
    }

    public static void logWarnings(Connection conn) {
        try {
            JDBCUtils.logWarnings(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052701", (Object)conn), (Throwable)e);
        }
    }

    public static void logWarnings(Statement stmt) {
        try {
            JDBCUtils.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052702", (Object)stmt), (Throwable)e);
        }
    }

    public static void logWarnings(ResultSet rs) {
        try {
            JDBCUtils.logWarnings(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("052703", (Object)rs), (Throwable)e);
        }
    }

    static {
        supportedJdbcTypesById.put(-5, "BIGINT");
        supportedJdbcTypesById.put(-7, "BIT");
        supportedJdbcTypesById.put(2004, "BLOB");
        supportedJdbcTypesById.put(16, "BOOLEAN");
        supportedJdbcTypesById.put(1, "CHAR");
        supportedJdbcTypesById.put(2005, "CLOB");
        supportedJdbcTypesById.put(70, "DATALINK");
        supportedJdbcTypesById.put(91, "DATE");
        supportedJdbcTypesById.put(3, "DECIMAL");
        supportedJdbcTypesById.put(8, "DOUBLE");
        supportedJdbcTypesById.put(6, "FLOAT");
        supportedJdbcTypesById.put(4, "INTEGER");
        supportedJdbcTypesById.put(-4, "LONGVARBINARY");
        supportedJdbcTypesById.put(-1, "LONGVARCHAR");
        supportedJdbcTypesById.put(2, "NUMERIC");
        supportedJdbcTypesById.put(7, "REAL");
        supportedJdbcTypesById.put(5, "SMALLINT");
        supportedJdbcTypesById.put(92, "TIME");
        supportedJdbcTypesById.put(93, "TIMESTAMP");
        supportedJdbcTypesById.put(-6, "TINYINT");
        supportedJdbcTypesById.put(-3, "VARBINARY");
        supportedJdbcTypesById.put(12, "VARCHAR");
        supportedJdbcTypesById.put(-9, "NVARCHAR");
        supportedJdbcTypesById.put(-15, "NCHAR");
        supportedJdbcTypesById.put(2011, "NCLOB");
        unsupportedJdbcTypesById.put(2003, "ARRAY");
        unsupportedJdbcTypesById.put(-2, "BINARY");
        unsupportedJdbcTypesById.put(2001, "DISTINCT");
        unsupportedJdbcTypesById.put(2000, "JAVA_OBJECT");
        unsupportedJdbcTypesById.put(0, "NULL");
        unsupportedJdbcTypesById.put(1111, "OTHER");
        unsupportedJdbcTypesById.put(2006, "REF");
        unsupportedJdbcTypesById.put(2002, "STRUCT");
    }
}

