/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.NullValueException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.CharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class NCharRDBMSMapping
extends CharRDBMSMapping {
    public NCharRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public NCharRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(-15, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(-15);
    }

    @Override
    public void setChar(Object ps, int param, char value) {
        try {
            if (value == '\u0000' && !this.getDatabaseAdapter().supportsOption("PersistOfUnassignedChar")) {
                value = (char)32;
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("055008"));
            }
            ((PreparedStatement)ps).setNString(param, Character.valueOf(value).toString());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"char", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public char getChar(Object rs, int param) {
        char value;
        try {
            value = ((ResultSet)rs).getNString(param).charAt(0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"char", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setNString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value.length() == 0) {
                if (this.storeMgr.getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull")) {
                    ((PreparedStatement)ps).setNString(param, null);
                } else {
                    if (this.getDatabaseAdapter().supportsOption("NullEqualsEmptyString")) {
                        value = this.getDatabaseAdapter().getSurrogateForEmptyStrings();
                    }
                    ((PreparedStatement)ps).setNString(param, value);
                }
            } else {
                Integer colLength;
                if (this.column != null && (colLength = this.column.getColumnMetaData().getLength()) != null && colLength < value.length()) {
                    String action = this.storeMgr.getStringProperty("datanucleus.rdbms.stringLengthExceededAction");
                    if (action.equals("EXCEPTION")) {
                        throw new NucleusUserException(LOCALISER_RDBMS.msg("055007", (Object)value, (Object)this.column.getIdentifier().toString(), (Object)("" + colLength))).setFatal();
                    }
                    if (action.equals("TRUNCATE")) {
                        value = value.substring(0, colLength);
                    }
                }
                ((PreparedStatement)ps).setNString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String getString(Object rs, int param) {
        try {
            String value = ((ResultSet)rs).getNString(param);
            if (value == null) {
                return value;
            }
            if (this.getDatabaseAdapter().supportsOption("NullEqualsEmptyString") && value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                return "";
            }
            if (this.column.getJdbcType() == 1 && this.getDatabaseAdapter().supportsOption("CharColumnsPaddedWithSpaces")) {
                int numPaddingChars = 0;
                for (int i = value.length() - 1; i >= 0 && value.charAt(i) == ' '; --i) {
                    ++numPaddingChars;
                }
                if (numPaddingChars > 0) {
                    value = value.substring(0, value.length() - numPaddingChars);
                }
            }
            return value;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setNString(param, value ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block6: {
            try {
                String s = ((ResultSet)rs).getNString(param);
                if (s == null) {
                    if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                        throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                    }
                    return false;
                }
                if (s.equals("Y")) {
                    value = true;
                    break block6;
                }
                if (s.equals("N")) {
                    value = false;
                    break block6;
                }
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Boolean) {
                ((PreparedStatement)ps).setNString(param, (Boolean)value != false ? "Y" : "N");
            } else if (value instanceof Time) {
                ((PreparedStatement)ps).setNString(param, ((Time)value).toString());
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setNString(param, ((Date)value).toString());
            } else if (value instanceof java.util.Date) {
                ((PreparedStatement)ps).setNString(param, this.getJavaUtilDateFormat().format((java.util.Date)value));
            } else if (value instanceof Timestamp) {
                Calendar cal = this.storeMgr.getCalendarForDateTimezone();
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
                }
            } else if (value instanceof String) {
                ((PreparedStatement)ps).setNString(param, (String)value);
            } else {
                ((PreparedStatement)ps).setNString(param, value.toString());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(Object rs, int param) {
        try {
            String s = ((ResultSet)rs).getNString(param);
            if (s == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                if (s.equals("Y")) {
                    return Boolean.TRUE;
                }
                if (!s.equals("N")) throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                return Boolean.FALSE;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_CHARACTER)) {
                return Character.valueOf(s.charAt(0));
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
                return Time.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
                return Date.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                return this.getJavaUtilDateFormat().parse(s);
            }
            if (!this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIMESTAMP)) return s;
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            return TypeConversionHelper.stringToTimestamp((String)s, (Calendar)cal);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }
}

