/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datatype;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobImpl
implements Clob {
    private String string;
    private long length;
    private StringReader reader;
    private InputStream inputStream;
    boolean freed = false;

    public ClobImpl(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        this.string = string;
        this.length = string.length();
    }

    @Override
    public long length() throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        return this.length;
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        if (this.inputStream == null) {
            this.inputStream = new ByteArrayInputStream(this.string.getBytes());
        }
        return this.inputStream;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        if (this.reader == null) {
            this.reader = new StringReader(this.string);
        }
        return this.reader;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
        if (this.freed) {
            return;
        }
        this.string = null;
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.freed = true;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        if (this.reader == null) {
            this.reader = new StringReader(this.string);
        }
        return this.reader;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Initial position cannot be larger than 2147483647");
        }
        if (pos + (long)length - 1L > this.length()) {
            throw new IndexOutOfBoundsException("The requested substring is greater than the actual length of the Clob String.");
        }
        return this.string.substring((int)pos - 1, (int)pos + length - 1);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (this.freed) {
            throw new SQLException("free() has been called");
        }
        throw new UnsupportedOperationException();
    }
}

