/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.Column;

public class ColumnExpression
extends SQLExpression {
    Column column;
    Object value;

    protected ColumnExpression(SQLStatement stmt, String parameterName, JavaTypeMapping mapping, Object value, int colNumber) {
        super(stmt, null, mapping);
        this.st.appendParameter(parameterName, mapping, value, colNumber);
    }

    protected ColumnExpression(SQLStatement stmt, SQLTable table, Column col) {
        super(stmt, table, null);
        this.column = col;
        this.st.append(this.toString());
    }

    protected ColumnExpression(SQLStatement stmt, Object value) {
        super(stmt, null, null);
        this.value = value;
        this.st.append(this.toString());
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_EQ, expr);
    }

    public BooleanExpression noteq(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
    }

    public String toString() {
        if (this.value != null) {
            if (this.value instanceof String || this.value instanceof Character) {
                return "'" + this.value + "'";
            }
            return "" + this.value;
        }
        if (this.table == null) {
            return "?";
        }
        if (this.table.getAlias() != null) {
            return this.table.getAlias() + "." + this.column.getIdentifier().toString();
        }
        return this.table.getTable() + "." + this.column.getIdentifier().toString();
    }
}

