/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class CollectionSizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        Class elementType;
        if (args != null && args.size() > 0) {
            throw new NucleusException(LOCALISER.msg("060015", (Object)"size", (Object)"CollectionExpression"));
        }
        if (expr instanceof CollectionLiteral) {
            Collection coll = (Collection)((CollectionLiteral)expr).getValue();
            return this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), coll.size());
        }
        AbstractMemberMetaData mmd = expr.getJavaTypeMapping().getMemberMetaData();
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Cannot perform Collection.size when the collection is being serialised");
        }
        ApiAdapter api = this.stmt.getRDBMSManager().getApiAdapter();
        if (!api.isPersistable(elementType = this.clr.classForName(mmd.getCollection().getElementType())) && mmd.getJoinMetaData() == null) {
            throw new NucleusUserException("Cannot perform Collection.size when the collection<Non-Persistable> is not in a join table");
        }
        String elementType2 = mmd.getCollection().getElementType();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject collectionTbl = null;
        if (mmd.getMappedBy() != null) {
            AbstractMemberMetaData elementMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
            if (mmd.getJoinMetaData() != null || elementMmd.getJoinMetaData() != null) {
                collectionTbl = storeMgr.getDatastoreContainerObject(mmd);
                ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
            } else {
                collectionTbl = storeMgr.getDatastoreClass(elementType2, this.clr);
                ownerMapping = collectionTbl.getMemberMapping(elementMmd);
            }
        } else if (mmd.getJoinMetaData() != null) {
            collectionTbl = storeMgr.getDatastoreContainerObject(mmd);
            ownerMapping = ((JoinTable)collectionTbl).getOwnerMapping();
        } else {
            collectionTbl = storeMgr.getDatastoreClass(elementType2, this.clr);
            ownerMapping = ((DatastoreClass)collectionTbl).getExternalMapping(mmd, 5);
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, collectionTbl, null, null);
        subStmt.setClassLoaderResolver(this.clr);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, this.clr);
        SQLExpression countExpr = this.exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        JavaTypeMapping subqMapping = this.exprFactory.getMappingForType(Integer.class, false);
        NumericSubqueryExpression subqExpr = new NumericSubqueryExpression(this.stmt, subStmt);
        subqExpr.setJavaTypeMapping(subqMapping);
        return subqExpr;
    }
}

