/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractArrayStore
extends ElementContainerStore
implements ArrayStore {
    protected AbstractArrayStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List getArray(ObjectProvider ownerSM) {
        Iterator iter = this.iterator(ownerSM);
        ArrayList elements = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    public void clear(ObjectProvider ownerSM) {
        HashSet dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.clearInternal(ownerSM);
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(ObjectProvider ownerSM, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ec, obj, null);
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                this.processBatchedWrites(mconn);
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        int[] rc = this.internalAdd(ownerSM, element, mconn, batched, i, i == length - 1);
                        if (rc == null) continue;
                        for (int j = 0; j < rc.length; ++j) {
                            if (rc[j] <= 0) continue;
                            modified = true;
                        }
                        continue;
                    }
                    catch (MappedDatastoreException mde) {
                        mde.printStackTrace();
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error((Object)mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), ownerSM.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjectProvider sm, Object element, int position) {
        ExecutionContext ec = sm.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        boolean modified = false;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                int[] returnCode = this.internalAdd(sm, element, mconn, false, position, true);
                if (returnCode[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)e.getMessage()), e.getCause());
        }
        return modified;
    }

    public abstract Iterator iterator(ObjectProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInternal(ObjectProvider ownerSM) {
        String clearStmt = this.getClearStmt();
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    if (this.getRelationDiscriminatorMapping() != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)clearStmt), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] internalAdd(ObjectProvider sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        ExecutionContext ec = sm.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, false);
            boolean notYetFlushedError = false;
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.getElementMapping());
                jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, this.getOrderMapping());
                if (this.getRelationDiscriminatorMapping() != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                }
                int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(addStmt, (Throwable)e);
        }
    }

    public void processBatchedWrites(ManagedConnection mconn) throws MappedDatastoreException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            sqlControl.processStatementsForConnection(mconn);
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", (Throwable)e);
        }
    }
}

