/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.util.ClassUtils;

public class BoneCPDataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(StoreManager storeMgr) {
        int value;
        int size;
        String dbPassword;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.jolbox.bonecp.BoneCPDataSource", (String)"bonecp.jar");
        BoneCPConfig config = new BoneCPConfig();
        config.setUsername(dbUser);
        config.setPassword(dbPassword);
        Properties dbProps = BoneCPDataSourceFactory.getPropertiesForDriver(storeMgr);
        config.setDriverProperties(dbProps);
        BoneCPDataSource ds = new BoneCPDataSource(config);
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
            ds.setStatementsCacheSize(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            ds.setMaxConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
            ds.setMinConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
            ds.setIdleMaxAgeInMinutes((long)value);
        }
        ds.setJdbcUrl(dbURL);
        ds.setUsername(dbUser);
        ds.setPassword(dbPassword);
        return ds;
    }
}

