/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

public final class ScrollableQueryResult
extends AbstractRDBMSQueryResult {
    private Map<Integer, Object> resultsObjsByIndex = null;
    protected Map<Integer, Object> resultIds = null;
    int startIndex = 0;
    int endIndex = -1;

    public ScrollableQueryResult(Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) {
        super(query, rof, rs);
        String ext;
        if (candidates != null) {
            throw new NucleusException("Unsupported Feature: Candidate Collection is only allowed using ForwardQueryResults").setFatal();
        }
        if (query.useResultsCaching()) {
            this.resultIds = new HashMap<Integer, Object>();
        }
        this.resultsObjsByIndex = (ext = (String)query.getExtension("datanucleus.query.resultCacheType")) != null ? (ext.equalsIgnoreCase("soft") ? new SoftValueMap() : (ext.equalsIgnoreCase("weak") ? new WeakValueMap() : (ext.equalsIgnoreCase("strong") ? new HashMap<Integer, Object>() : (ext.equalsIgnoreCase("none") ? null : new WeakValueMap())))) : new WeakValueMap();
        if (this.applyRangeChecks()) {
            this.startIndex = (int)query.getRangeFromIncl();
        }
        if (this.resultsObjsByIndex != null) {
            int fetchSize = query.getFetchPlan().getFetchSize();
            if (fetchSize == -1) {
                this.loadObjects(this.startIndex, -1);
                this.cacheQueryResults();
            } else if (fetchSize > 0) {
                this.loadObjects(this.startIndex, fetchSize);
            }
        }
    }

    protected void loadObjects(int start, int maxNumber) {
        int index = start;
        boolean hasMoreResults = true;
        while (hasMoreResults) {
            if (maxNumber >= 0 && index == maxNumber + start) {
                hasMoreResults = false;
                continue;
            }
            if (this.applyRangeChecks() && (long)index >= this.query.getRangeToExcl()) {
                this.size = (int)(this.query.getRangeToExcl() - this.query.getRangeFromIncl());
                hasMoreResults = false;
                continue;
            }
            try {
                boolean rowExists = this.rs.absolute(index + 1);
                if (!rowExists) {
                    hasMoreResults = false;
                    this.size = index;
                    if (this.applyRangeChecks() && (long)index < this.query.getRangeToExcl()) {
                        this.size = (int)((long)index - this.query.getRangeFromIncl());
                    }
                    this.endIndex = index - 1;
                    continue;
                }
                this.getObjectForIndex(index);
                ++index;
            }
            catch (SQLException sqle) {}
        }
    }

    protected Object getObjectForIndex(int index) {
        Object obj;
        if (this.resultsObjsByIndex != null && (obj = this.resultsObjsByIndex.get(index)) != null) {
            return obj;
        }
        if (this.rs == null) {
            throw new NucleusUserException("Results for query have already been closed. Perhaps you called flush(), closed the query, or ended a transaction");
        }
        try {
            this.rs.absolute(index + 1);
            obj = this.rof.getObject(this.query.getExecutionContext(), (Object)this.rs);
            JDBCUtils.logWarnings(this.rs);
            if (this.resultsObjsByIndex != null) {
                this.resultsObjsByIndex.put(index, obj);
                if (this.resultIds != null) {
                    this.resultIds.put(index, this.query.getExecutionContext().getApiAdapter().getIdForObject(obj));
                }
            }
            return obj;
        }
        catch (SQLException sqe) {
            throw this.query.getExecutionContext().getApiAdapter().getDataStoreExceptionForException(LOCALISER.msg("052601", (Object)sqe.getMessage()), (Exception)sqe);
        }
    }

    public synchronized void close() {
        if (this.resultsObjsByIndex != null) {
            this.resultsObjsByIndex.clear();
        }
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen()) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            if (this.endIndex < 0) {
                this.endIndex = this.size() - 1;
                if (this.applyRangeChecks()) {
                    this.endIndex = (int)this.query.getRangeToExcl() - 1;
                }
            }
            for (int i = this.startIndex; i < this.endIndex + 1; ++i) {
                this.getObjectForIndex(i);
            }
            this.cacheQueryResults();
        }
    }

    protected void cacheQueryResults() {
        if (this.resultIds != null) {
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Integer position : this.resultIds.keySet()) {
                Object resultId = this.resultIds.get(position);
                ids.add(resultId);
            }
            this.query.getQueryManager().addDatastoreQueryResult(this.query, this.query.getInputParameters(), ids);
        }
        this.resultIds = null;
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ScrollableQueryResult)) {
            return false;
        }
        ScrollableQueryResult other = (ScrollableQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getObjectForIndex(index + this.startIndex);
    }

    protected int getSizeUsingMethod() {
        int theSize = 0;
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            if (this.rs == null) {
                throw new NucleusUserException("Results for query have already been closed. Perhaps you called flush(), closed the query, or ended a transaction");
            }
            try {
                boolean hasLast = this.rs.last();
                theSize = !hasLast ? 0 : this.rs.getRow();
            }
            catch (SQLException sqle) {
                throw this.query.getExecutionContext().getApiAdapter().getDataStoreExceptionForException(LOCALISER.msg("052601", (Object)sqle.getMessage()), (Exception)sqle);
            }
            if (this.applyRangeChecks()) {
                if ((long)theSize > this.query.getRangeToExcl()) {
                    this.endIndex = (int)(this.query.getRangeToExcl() - 1L);
                    theSize = (int)(this.query.getRangeToExcl() - this.query.getRangeFromIncl());
                } else {
                    this.endIndex = theSize - 1;
                    theSize = (int)((long)theSize - this.query.getRangeFromIncl());
                }
            }
        } else {
            theSize = super.getSizeUsingMethod();
        }
        return theSize;
    }

    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException("null argument is illegal!");
        }
        return this.toArrayInternal(a);
    }

    private Object[] toArrayInternal(Object[] a) {
        int size;
        ArrayList<Object> resultList;
        Object[] result;
        block13: {
            result = a;
            resultList = null;
            size = -1;
            try {
                size = this.size();
            }
            catch (Exception x) {
                size = -1;
                if (!NucleusLogger.QUERY.isDebugEnabled()) break block13;
                NucleusLogger.QUERY.debug((Object)"toArray: Could not determine size.", (Throwable)x);
            }
        }
        if (size >= 0 && (result == null || result.length < size)) {
            result = null;
            resultList = new ArrayList<Object>(size);
        }
        Iterator iterator = null;
        if (result != null) {
            iterator = this.iterator();
            int idx = -1;
            while (iterator.hasNext()) {
                if (++idx < result.length) {
                    result[idx] = iterator.next();
                    continue;
                }
                int capacity = result.length * 3 / 2 + 1;
                if (capacity < result.length) {
                    capacity = result.length;
                }
                resultList = new ArrayList(capacity);
                for (int i = 0; i < result.length; ++i) {
                    resultList.add(result[i]);
                }
                result = null;
                break;
            }
            if (result != null && ++idx < result.length) {
                result[idx] = null;
            }
        }
        if (result == null) {
            if (resultList == null) {
                resultList = new ArrayList();
            }
            if (iterator == null) {
                iterator = this.iterator();
            }
            while (iterator.hasNext()) {
                resultList.add(iterator.next());
            }
            result = a == null ? resultList.toArray() : resultList.toArray(a);
        }
        return result;
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int iterRowNum = 0;

        public QueryResultIterator() {
            if (ScrollableQueryResult.this.applyRangeChecks()) {
                this.iterRowNum = (int)ScrollableQueryResult.this.query.getRangeFromIncl();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    return false;
                }
                int theSize = ScrollableQueryResult.this.size();
                if (ScrollableQueryResult.this.applyRangeChecks()) {
                    if ((long)theSize < ScrollableQueryResult.this.query.getRangeToExcl() - ScrollableQueryResult.this.query.getRangeFromIncl()) {
                        return (long)this.iterRowNum <= ScrollableQueryResult.this.query.getRangeFromIncl() + (long)theSize - 1L;
                    }
                    if ((long)this.iterRowNum == ScrollableQueryResult.this.query.getRangeToExcl() - 1L) {
                        ScrollableQueryResult.this.endIndex = this.iterRowNum;
                    }
                    return (long)this.iterRowNum <= ScrollableQueryResult.this.query.getRangeToExcl() - 1L;
                }
                return this.iterRowNum <= theSize - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    return false;
                }
                if (ScrollableQueryResult.this.applyRangeChecks()) {
                    return (long)this.iterRowNum > ScrollableQueryResult.this.query.getRangeFromIncl();
                }
                return this.iterRowNum > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next element");
                }
                Object obj = ScrollableQueryResult.this.getObjectForIndex(this.iterRowNum);
                ++this.iterRowNum;
                return obj;
            }
        }

        public int nextIndex() {
            if (this.hasNext()) {
                if (ScrollableQueryResult.this.applyRangeChecks()) {
                    return this.iterRowNum - (int)ScrollableQueryResult.this.query.getRangeFromIncl();
                }
                return this.iterRowNum;
            }
            return ScrollableQueryResult.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous element");
                }
                --this.iterRowNum;
                return ScrollableQueryResult.this.getObjectForIndex(this.iterRowNum);
            }
        }

        public int previousIndex() {
            if (ScrollableQueryResult.this.applyRangeChecks()) {
                return (int)((long)this.iterRowNum == ScrollableQueryResult.this.query.getRangeFromIncl() ? -1L : (long)this.iterRowNum - ScrollableQueryResult.this.query.getRangeFromIncl() - 1L);
            }
            return this.iterRowNum == 0 ? -1 : this.iterRowNum - 1;
        }
    }
}

